/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class IPUtils {
    private static InetAddress address = null;
    private static Boolean isClient = null;

    public static InetAddress getLocleAddress() throws SocketException {
        if (address == null) {
            address = IPUtils.getFirstLocleAddress(true);
        }
        return address;
    }

    public static InetAddress getFirstLocleAddress(boolean excludeIPV6) throws SocketException {
        return IPUtils.getFirstLocleAddress(excludeIPV6, true, IPUtils.isClient());
    }

    private static boolean isClient() {
        if (isClient == null) {
            isClient = System.getProperty("easclient.root") != null;
        }
        return isClient;
    }

    public static InetAddress getFirstLocleAddress(boolean excludeIPV6, boolean onlyUp, boolean excludeAdapter) throws SocketException {
        Method methodIsUp = null;
        if (onlyUp) {
            try {
                methodIsUp = NetworkInterface.class.getMethod("isUp", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        InetAddress loopbackAddress = null;
        InetAddress locleAddress = null;
        Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
        while (e1.hasMoreElements()) {
            String displayName;
            NetworkInterface netif = e1.nextElement();
            if (excludeAdapter && (displayName = netif.getDisplayName()) != null && displayName.indexOf("Adapter") >= 0) continue;
            if (methodIsUp != null) {
                try {
                    boolean isUp = (Boolean)methodIsUp.invoke((Object)netif, new Object[0]);
                    if (!isUp) {
                        continue;
                    }
                }
                catch (Exception isUp) {
                    // empty catch block
                }
            }
            Enumeration<InetAddress> e2 = netif.getInetAddresses();
            while (e2.hasMoreElements()) {
                InetAddress addr = e2.nextElement();
                if (excludeIPV6 && addr instanceof Inet6Address) continue;
                if (addr.isLoopbackAddress()) {
                    loopbackAddress = addr;
                    continue;
                }
                if (addr.isAnyLocalAddress() || addr.isMulticastAddress()) continue;
                locleAddress = addr;
            }
            if (locleAddress == null) continue;
            break;
        }
        return locleAddress == null ? loopbackAddress : locleAddress;
    }

    public static void setAddress(String inetAddress) {
        String[] strs = inetAddress.split("/");
        String hostName = strs[0];
        String addr = strs[1];
        String[] parts = addr.split("\\.");
        byte[] bytes = new byte[4];
        for (int i = 0; i < parts.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(parts[i]);
        }
        try {
            address = InetAddress.getByAddress(hostName, bytes);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

