/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class LocaleUtils {
    private static Locale defaultLocale = Locale.getDefault();
    private static Locale defaultOriginLocale = Locale.getDefault();
    private static Map<String, Locale> locales = new HashMap<String, Locale>(4);
    private static Map<Locale, String> localeStrings = new HashMap<Locale, String>(4);
    private static Map<Locale, String> shortCodes = new HashMap<Locale, String>(4);
    public static final Locale locale_l1 = new Locale("l1", "");
    public static final Locale locale_L1 = new Locale("L1", "");
    public static final Locale locale_en_US = new Locale("en", "US");
    public static final Locale locale_l2 = new Locale("l2", "");
    public static final Locale locale_L2 = new Locale("L2", "");
    public static final Locale locale_zh_CN = new Locale("zh", "CN");
    public static final Locale locale_l3 = new Locale("l3", "");
    public static final Locale locale_L3 = new Locale("L3", "");
    public static final Locale locale_zh_TW = new Locale("zh", "TW");
    public static final Locale locale_en = new Locale("en", "");
    public static final String l1 = "l1";
    public static final String l2 = "l2";
    public static final String l3 = "l3";
    public static final String zh_cn = "zh_CN";
    public static final String zh_tw = "zh_TW";
    public static final String zh_en = "en_US";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale getLocale(String localeString) {
        if (localeString == null) {
            return null;
        }
        if (l2.equals(localeString)) {
            return locale_l2;
        }
        if ("L2".equals(localeString)) {
            return locale_L2;
        }
        if (zh_cn.equals(localeString) || "CH".equals(localeString)) {
            return locale_zh_CN;
        }
        if (l1.equals(localeString)) {
            return locale_l1;
        }
        if ("L1".equals(localeString)) {
            return locale_L1;
        }
        if (zh_en.equals(localeString)) {
            return locale_en_US;
        }
        if (zh_tw.equals(localeString) || "TW".equals(localeString)) {
            return locale_zh_TW;
        }
        if ("en".equals(localeString)) {
            return locale_en;
        }
        if (l3.equals(localeString)) {
            return locale_l3;
        }
        if ("L3".equals(localeString)) {
            return locale_L3;
        }
        Locale locale = locales.get(localeString);
        if (locale == null) {
            Map<String, Locale> map = locales;
            synchronized (map) {
                locale = locales.get(localeString);
                if (locale == null) {
                    locale = LocaleUtils.innerGetLocale(localeString);
                    locales.put(localeString, locale);
                    localeStrings.put(locale, localeString);
                }
            }
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<Object, Object> map = locales;
        synchronized (map) {
            locales.clear();
            localeStrings.clear();
        }
        map = shortCodes;
        synchronized (map) {
            shortCodes.clear();
        }
    }

    public static Locale getShortLocale(Locale local) {
        return LocaleUtils.getLocale(LocaleUtils.getShortCode(local));
    }

    public static String getShortCode(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (locale_l2.equals(locale)) {
            return l2;
        }
        if (locale_L2.equals(locale)) {
            return l2;
        }
        if (locale_zh_CN.equals(locale)) {
            return l2;
        }
        if (locale_l1.equals(locale)) {
            return l1;
        }
        if (locale_L1.equals(locale)) {
            return l1;
        }
        if (locale_en_US.equals(locale)) {
            return l1;
        }
        if (locale_zh_TW.equals(locale)) {
            return l3;
        }
        if (locale_en.equals(locale)) {
            return l1;
        }
        if (locale_l3.equals(locale)) {
            return l3;
        }
        if (locale_L3.equals(locale)) {
            return l3;
        }
        return shortCodes.get(locale);
    }

    public static void addShortCode(Locale locale, String shortCode) {
        LocaleUtils.addShortCode(locale, shortCode, false);
    }

    public static void addShortCode(Locale locale, String shortCode, boolean isFromConfig) {
        if (locale != null && shortCode != null) {
            String scl = shortCode.toLowerCase();
            if (isFromConfig) {
                Iterator<Map.Entry<Locale, String>> iterator = shortCodes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Locale, String> entry = iterator.next();
                    String value = entry.getValue();
                    if (!scl.equals(value)) continue;
                    iterator.remove();
                    break;
                }
            }
            shortCodes.put(locale, scl);
        }
    }

    public static List<Locale> getOriginLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (shortCodes.containsKey(locale)) {
            ArrayList<Locale> ls = new ArrayList<Locale>(1);
            ls.add(locale);
            return ls;
        }
        return LocaleUtils.getLocaleByShortCode(locale.toString());
    }

    public static Locale getFirstOriginLocale(Locale locale) {
        List<Locale> locales = LocaleUtils.getOriginLocale(locale);
        if (locales != null && locales.size() > 0) {
            return locales.get(0);
        }
        return null;
    }

    public static List<Locale> getLocaleByShortCode(String shortCode) {
        Iterator<Map.Entry<Locale, String>> ite = shortCodes.entrySet().iterator();
        ArrayList<Locale> ls = new ArrayList<Locale>(2);
        while (ite.hasNext()) {
            Map.Entry<Locale, String> entry = ite.next();
            if (!entry.getValue().equalsIgnoreCase(shortCode)) continue;
            ls.add(entry.getKey());
        }
        if (ls.size() == 0) {
            ls.add(LocaleUtils.getLocale(shortCode));
        }
        return ls;
    }

    private static Locale innerGetLocale(String localeString) {
        ArrayList<String> vect = new ArrayList<String>(3);
        StringTokenizer token = new StringTokenizer(localeString, "_");
        while (token.hasMoreTokens()) {
            vect.add(token.nextToken());
        }
        Locale locale = null;
        if (vect.size() == 1) {
            locale = new Locale((String)vect.get(0), "");
        } else if (vect.size() == 2) {
            locale = new Locale((String)vect.get(0), (String)vect.get(1));
        } else if (vect.size() == 3) {
            locale = new Locale((String)vect.get(0), (String)vect.get(1), (String)vect.get(2));
        }
        return locale;
    }

    public static String getLocaleString(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (locale_l2.equals(locale)) {
            return l2;
        }
        if (locale_L2.equals(locale)) {
            return l2;
        }
        if (locale_zh_CN.equals(locale)) {
            return zh_cn;
        }
        if (locale_l1.equals(locale)) {
            return l1;
        }
        if (locale_L1.equals(locale)) {
            return l1;
        }
        if (locale_en_US.equals(locale)) {
            return zh_en;
        }
        if (locale_zh_TW.equals(locale)) {
            return zh_tw;
        }
        if (locale_en.equals(locale)) {
            return "en";
        }
        if (locale_l3.equals(locale)) {
            return l3;
        }
        if (locale_L3.equals(locale)) {
            return l3;
        }
        String str = localeStrings.get(locale);
        if (str == null) {
            str = locale.toString();
        }
        return str;
    }

    public static String getMappingLocals(String localeString) {
        if (localeString == null) {
            return null;
        }
        if (l2.equals(localeString)) {
            return zh_cn;
        }
        if ("L2".equals(localeString)) {
            return zh_cn;
        }
        if (l1.equals(localeString)) {
            return zh_en;
        }
        if ("L1".equals(localeString)) {
            return zh_en;
        }
        if (l3.equals(localeString)) {
            return zh_tw;
        }
        if ("L3".equals(localeString)) {
            return zh_tw;
        }
        if (zh_en.equals(localeString) || "en".equals(localeString)) {
            return l1;
        }
        if (zh_cn.equals(localeString) || "CH".equals(localeString)) {
            return l2;
        }
        if (zh_tw.equals(localeString) || "TW".equals(localeString)) {
            return l3;
        }
        return zh_cn;
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static void setDefaultLocale(Locale loc) {
        defaultLocale = LocaleUtils.getShortLocale(loc);
        defaultOriginLocale = LocaleUtils.getFirstOriginLocale(loc);
    }

    public static Locale getDefaultOriginLocale() {
        return defaultOriginLocale;
    }
}

