/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.ConfigurationException;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.io.PrintStream;
import java.util.List;

public class RWSplitingConfiguration {
    private XMLConfiguration xmlConfig;
    private File file;
    private static volatile RWSplitingConfiguration myself;

    private RWSplitingConfiguration() {
        String configPath = System.getProperty("EAS_HOME") + "/server/properties/RWSplitingConfig.xml";
        this.file = new File(configPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RWSplitingConfiguration getInstance() throws ConfigurationException {
        if (myself != null) return myself;
        Class<RWSplitingConfiguration> clazz = RWSplitingConfiguration.class;
        synchronized (RWSplitingConfiguration.class) {
            if (myself != null) return myself;
            RWSplitingConfiguration config = new RWSplitingConfiguration();
            config.load();
            myself = config;
            // ** MonitorExit[var0] (shouldn't be in output)
            return myself;
        }
    }

    public void addConfigItem(ConfigurationItem item) {
        this.xmlConfig.addConfigItem(item);
    }

    public ConfigurationItem getConfigItem(String name) {
        return this.xmlConfig.getConfigItem(name);
    }

    public List getConfigItemList(String name) {
        return this.xmlConfig.getConfigItemList(name);
    }

    public ConfigurationItem getConfigItemByPath(String path) {
        return this.xmlConfig.getConfigItemByPath(path);
    }

    public List getConfigItemListByPath(String path) {
        return this.xmlConfig.getConfigItemListByPath(path);
    }

    public void removeConfigItem(String name) {
        this.xmlConfig.removeConfigItem(name);
    }

    public void removeAll() {
        this.xmlConfig.removeAll();
    }

    public void store() throws ConfigurationException {
        this.xmlConfig.store();
    }

    private void load() throws ConfigurationException {
        if (this.file == null) {
            throw new ConfigurationException("config file not exists.");
        }
        if (this.file != null) {
            if (!this.file.exists()) {
                throw new ConfigurationException("config file " + this.file.getAbsolutePath() + " not exists.");
            }
        } else {
            throw new ConfigurationException("config file not exists.");
        }
        this.xmlConfig = XMLConfiguration.getInstance(this.file);
    }

    public void dump(PrintStream ps) {
        this.xmlConfig.dump(ps);
    }
}

