/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.Sequence;
import com.kingdee.util.Uuid;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class UuidWrapper {
    private Object val;
    private byte type;
    public static final byte TYPE_UUID = 1;
    public static final byte TYPE_SEQUENCE = 2;

    private UuidWrapper(Object val, byte type) {
        this.type = type;
        this.val = val;
    }

    public static UuidWrapper create(Object val) {
        byte type;
        assert (val != null);
        if (val instanceof Uuid) {
            type = 1;
        } else if (val instanceof Sequence) {
            type = 2;
        } else {
            throw new IllegalArgumentException("ID TYPE: " + val.getClass().getName());
        }
        return new UuidWrapper(val, type);
    }

    public static UuidWrapper read(byte type, DataInput in) throws IOException {
        Comparable val;
        if (type == 1) {
            val = Uuid.read(in);
        } else if (type == 2) {
            val = Sequence.read(in);
        } else {
            throw new IllegalArgumentException("ID TYPE: " + type);
        }
        return new UuidWrapper(val, type);
    }

    public void write(DataOutput out) throws IOException {
        if (this.type == 1) {
            ((Uuid)this.val).write(out);
        } else {
            ((Sequence)this.val).write(out);
        }
    }

    public String toString() {
        return this.val.toString();
    }

    public int hashCode() {
        return this.val.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UuidWrapper other = (UuidWrapper)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.val == null ? other.val != null : !this.val.equals(other.val));
    }
}

