/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.db;

import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.InvalidDateException;
import com.kingdee.util.TypeConversionUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public final class TableDesc {
    protected final String tableName;
    protected Map types;

    public TableDesc(String tableName) {
        this.tableName = tableName;
        this.types = new HashMap();
    }

    public String getTableName() {
        return this.tableName;
    }

    public TableDesc addFieldDesc(String name, int sqltype) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null!");
        }
        this.types.put(name.toUpperCase(), sqltype);
        return this;
    }

    public void reset() {
        this.types = new HashMap();
    }

    public void bindToParam(PreparedStatement preparedStmt, int i, String fieldname, Object fieldValue) throws SQLException {
        if (fieldname == null) {
            throw new SQLException("fieldname is null!");
        }
        Object typeObject = this.types.get(fieldname.toUpperCase());
        if (typeObject == null) {
            throw new SQLException("fieldname [" + fieldname + "] cannot found in TableDesc: " + this.tableName);
        }
        int sqltype = (Integer)typeObject;
        try {
            if (fieldValue == null || fieldValue instanceof String && ((String)fieldValue).length() == 0) {
                if (sqltype == 2005) {
                    preparedStmt.setString(i, null);
                    return;
                }
                if (sqltype == 2004) {
                    preparedStmt.setBytes(i, null);
                    return;
                }
                if (fieldValue == null) {
                    preparedStmt.setNull(i, sqltype);
                } else {
                    preparedStmt.setString(i, "");
                }
                return;
            }
            switch (sqltype) {
                case -1: 
                case 1: 
                case 12: {
                    String tmp = TypeConversionUtils.objToString(fieldValue);
                    if (tmp.startsWith("~9^Nz")) {
                        preparedStmt.setString(i, tmp.substring(tmp.lastIndexOf("~9^Nz") + 5));
                    } else {
                        preparedStmt.setString(i, tmp);
                    }
                    return;
                }
                case 4: {
                    if (fieldValue != null && fieldValue instanceof Boolean) {
                        if (((Boolean)fieldValue).booleanValue()) {
                            preparedStmt.setInt(i, 1);
                        } else {
                            preparedStmt.setInt(i, 0);
                        }
                    } else {
                        preparedStmt.setInt(i, TypeConversionUtils.objToInt(fieldValue));
                    }
                    return;
                }
                case -7: {
                    preparedStmt.setBoolean(i, TypeConversionUtils.objToBoolean(fieldValue));
                    return;
                }
                case -6: {
                    preparedStmt.setByte(i, TypeConversionUtils.objToByte(fieldValue));
                    return;
                }
                case 5: {
                    preparedStmt.setShort(i, TypeConversionUtils.objToShort(fieldValue));
                    return;
                }
                case -5: {
                    preparedStmt.setLong(i, TypeConversionUtils.objToLong(fieldValue));
                    return;
                }
                case 6: 
                case 7: 
                case 8: {
                    preparedStmt.setDouble(i, TypeConversionUtils.objToDouble(fieldValue));
                    return;
                }
                case 2: 
                case 3: {
                    preparedStmt.setBigDecimal(i, TypeConversionUtils.objToBigDecimal(fieldValue));
                    return;
                }
                case 91: {
                    preparedStmt.setDate(i, TypeConversionUtils.objToDate(fieldValue));
                    return;
                }
                case 92: {
                    preparedStmt.setTime(i, TypeConversionUtils.objToTime(fieldValue));
                    return;
                }
                case 93: {
                    preparedStmt.setTimestamp(i, TypeConversionUtils.objToTimestamp(fieldValue));
                    return;
                }
                case -4: 
                case -3: 
                case -2: {
                    preparedStmt.setBytes(i, TypeConversionUtils.objToBytes(fieldValue));
                }
                case 2004: {
                    byte[] bytesTemp = TypeConversionUtils.objToBytes(fieldValue);
                    preparedStmt.setBinaryStream(i, (InputStream)new ByteArrayInputStream(bytesTemp), bytesTemp.length);
                    return;
                }
                case 2005: {
                    preparedStmt.setString(i, TypeConversionUtils.objToString(fieldValue));
                    return;
                }
            }
            throw new SQLException("Cannot deal with type: " + sqltype);
        }
        catch (IllegalConversionException ice) {
            throw new SQLException(fieldname + "Illegal conversion");
        }
        catch (InvalidDateException dte) {
            throw new SQLException(fieldname + "Invalida Date");
        }
    }
}

