/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.db;

import com.kingdee.util.BOSGlobalConfiguration;
import com.kingdee.util.ConfigurationItem;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ThridDbContionPool {
    private static final Logger logger = Logger.getLogger(ThridDbContionPool.class);
    private static Map<String, ThridDbContionPool> instances = new HashMap<String, ThridDbContionPool>();
    private static ThridDbContionPool instance;
    private String jdbcDriver = "";
    private String dbUrl = "";
    private String dbUsername = "";
    private String dbPassword = "";
    private int initialConnections = 10;
    private int incrementalConnections = 5;
    private int maxConnections = 50;
    private Vector connections = null;

    private static void initFromConfig() {
        BOSGlobalConfiguration config = BOSGlobalConfiguration.getInstance();
        ConfigurationItem item = config.getConfigItem("thriddb");
        List dataSources = item.getAllChildren();
        for (ConfigurationItem ds : dataSources) {
            String ais = ds.getName();
            String driver = ds.getProperty("driver");
            String user = ds.getProperty("user");
            String password = ds.getProperty("password");
            String originalUrl = ds.getProperty("originalUrl");
            instance = new ThridDbContionPool(driver, originalUrl, user, password);
            instances.put(ais, instance);
        }
    }

    public static final ThridDbContionPool getInstance(String ais) {
        if (ais == null || ais.length() == 0) {
            return instance;
        }
        return instances.get(ais);
    }

    private ThridDbContionPool(String jdbcDriver, String dbUrl, String dbUsername, String dbPassword) {
        this.jdbcDriver = jdbcDriver;
        this.dbUrl = dbUrl;
        this.dbUsername = dbUsername;
        this.dbPassword = dbPassword;
        try {
            this.createPool();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private synchronized void createPool() throws Exception {
        if (this.connections != null) {
            return;
        }
        Driver driver = (Driver)Class.forName(this.jdbcDriver).newInstance();
        DriverManager.registerDriver(driver);
        this.connections = new Vector();
        this.createConnections(this.initialConnections);
    }

    private void createConnections(int numConnections) throws SQLException {
        for (int x = 0; x < numConnections && (this.maxConnections <= 0 || this.connections.size() < this.maxConnections); ++x) {
            try {
                this.connections.addElement(new PooledConnection(this.newConnection()));
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)(" \u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01 " + e.getMessage()));
                throw new SQLException();
            }
        }
    }

    private Connection newConnection() throws SQLException {
        DatabaseMetaData metaData;
        int driverMaxConnections;
        Connection conn = DriverManager.getConnection(this.dbUrl, this.dbUsername, this.dbPassword);
        if (this.connections.size() == 0 && (driverMaxConnections = (metaData = conn.getMetaData()).getMaxConnections()) > 0 && this.maxConnections > driverMaxConnections) {
            this.maxConnections = driverMaxConnections;
        }
        return conn;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.connections == null) {
            return null;
        }
        Connection conn = this.getFreeConnection();
        while (conn == null) {
            this.wait(250);
            conn = this.getFreeConnection();
        }
        return conn;
    }

    private Connection getFreeConnection() throws SQLException {
        Connection conn = this.findFreeConnection();
        if (conn == null) {
            this.createConnections(this.incrementalConnections);
            conn = this.findFreeConnection();
            if (conn == null) {
                return null;
            }
        }
        return conn;
    }

    private Connection findFreeConnection() throws SQLException {
        Connection conn = null;
        PooledConnection pConn = null;
        Enumeration enumerate = this.connections.elements();
        while (enumerate.hasMoreElements()) {
            pConn = (PooledConnection)enumerate.nextElement();
            if (pConn.isBusy()) continue;
            conn = pConn.getConnection();
            pConn.setBusy(true);
            if (!conn.isClosed()) break;
            try {
                conn = this.newConnection();
            }
            catch (SQLException e) {
                logger.error((Object)(" \u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01 " + e.getMessage()));
                return null;
            }
            pConn.setConnection(conn);
            break;
        }
        return conn;
    }

    public void returnConnection(Connection conn) {
        if (this.connections == null) {
            logger.error((Object)" \u8fde\u63a5\u6c60\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fd4\u56de\u6b64\u8fde\u63a5\u5230\u8fde\u63a5\u6c60\u4e2d !");
            return;
        }
        PooledConnection pConn = null;
        Enumeration enumerate = this.connections.elements();
        while (enumerate.hasMoreElements()) {
            pConn = (PooledConnection)enumerate.nextElement();
            if (conn != pConn.getConnection()) continue;
            pConn.setBusy(false);
            break;
        }
    }

    public synchronized void refreshConnections() throws SQLException {
        if (this.connections == null) {
            logger.error((Object)" \u8fde\u63a5\u6c60\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5237\u65b0 !");
            return;
        }
        PooledConnection pConn = null;
        Enumeration enumerate = this.connections.elements();
        while (enumerate.hasMoreElements()) {
            pConn = (PooledConnection)enumerate.nextElement();
            if (pConn.isBusy()) {
                this.wait(5000);
            }
            this.closeConnection(pConn.getConnection());
            pConn.setConnection(this.newConnection());
            pConn.setBusy(false);
        }
    }

    public synchronized void closeConnectionPool() throws SQLException {
        if (this.connections == null) {
            logger.error((Object)" \u8fde\u63a5\u6c60\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5173\u95ed !");
            return;
        }
        PooledConnection pConn = null;
        Enumeration enumerate = this.connections.elements();
        while (enumerate.hasMoreElements()) {
            pConn = (PooledConnection)enumerate.nextElement();
            if (pConn.isBusy()) {
                this.wait(5000);
            }
            this.closeConnection(pConn.getConnection());
            this.connections.removeElement(pConn);
        }
        this.connections = null;
    }

    private void closeConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            logger.error((Object)(" \u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519\uff1a " + e.getMessage()));
        }
    }

    private void wait(int mSeconds) {
        try {
            Thread.sleep(mSeconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        try {
            ThridDbContionPool.initFromConfig();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    class PooledConnection {
        Connection connection = null;
        boolean busy = false;

        public PooledConnection(Connection connection) {
            this.connection = connection;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        public boolean isBusy() {
            return this.busy;
        }

        public void setBusy(boolean busy) {
            this.busy = busy;
        }
    }
}

