/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.db;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.db.ThridDbContionPool;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ThridDbUtils {
    private static final Logger logger = Logger.getLogger(ThridDbContionPool.class);
    private static int fetchMaxRowToJson = 1000;

    public static String query(String sql, String ais) throws Exception {
        String json = "";
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = ThridDbContionPool.getInstance(ais).getConnection();
            st = con.createStatement();
            rs = st.executeQuery(sql);
            json = ThridDbUtils.resultSetToJson(rs);
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                if (con != null && ThridDbContionPool.getInstance(ais) != null) {
                    ThridDbContionPool.getInstance(ais).returnConnection(con);
                }
                SQLUtils.cleanup(rs, st, null);
                throw throwable;
            }
        }
        if (con != null && ThridDbContionPool.getInstance(ais) != null) {
            ThridDbContionPool.getInstance(ais).returnConnection(con);
        }
        SQLUtils.cleanup(rs, st, null);
        return json;
    }

    public static IRowSet queryForRs(String sql, String ais) throws Exception {
        JdbcRowSet jdbcRowSet;
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = ThridDbContionPool.getInstance(ais).getConnection();
            st = con.createStatement();
            rs = st.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs, fetchMaxRowToJson);
            jdbcRowSet = rowset;
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                if (con != null && ThridDbContionPool.getInstance(ais) != null) {
                    ThridDbContionPool.getInstance(ais).returnConnection(con);
                }
                SQLUtils.cleanup(rs, st, null);
                throw throwable;
            }
        }
        if (con != null && ThridDbContionPool.getInstance(ais) != null) {
            ThridDbContionPool.getInstance(ais).returnConnection(con);
        }
        SQLUtils.cleanup(rs, st, null);
        return jdbcRowSet;
    }

    private static String resultSetToJson(ResultSet rs) throws SQLException, JSONException {
        JSONArray array = new JSONArray();
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        int rowcount = 0;
        while (rs.next() && ++rowcount <= fetchMaxRowToJson) {
            JSONObject jsonObj = new JSONObject();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = metaData.getColumnLabel(i);
                String value = rs.getString(columnName);
                jsonObj.put(columnName, (Object)value);
            }
            array.add((Object)jsonObj);
        }
        return array.toString();
    }
}

