/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.enums;

import com.kingdee.util.enums.Enum;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class DynamicEnum
extends Enum {
    private static final long serialVersionUID = 1503155337522681396L;
    private final String sValue;
    private final String pk;

    public DynamicEnum(String pk, String name, String value) {
        super(name, DynamicAssist.getFactory().getInstance(pk));
        this.pk = pk;
        this.sValue = value;
    }

    public final String getValue() {
        return this.sValue;
    }

    @Override
    public int compareTo(Object other) {
        DynamicEnum that = (DynamicEnum)other;
        if (!this.pk.equals(that.pk)) {
            throw new IllegalArgumentException("DynamicEnum's pk must be same.");
        }
        return this.sValue.compareTo(that.sValue);
    }

    public static DynamicEnum getEnum(String pk, Object value) {
        List list = DynamicEnum.getEnumList(pk);
        for (DynamicEnum _enum : list) {
            if (!_enum.getValue().equals(value)) continue;
            return _enum;
        }
        return null;
    }

    public static DynamicEnum getEnumByName(String pk, Object value) {
        Map map = DynamicEnum.getEnumMap(pk);
        return (DynamicEnum)map.get(value);
    }

    public String getPK() {
        return this.pk;
    }

    @Override
    protected Object readResolve() {
        return DynamicEnum.getEnum(this.pk, (Object)this.sValue);
    }

    public static EnumDesc getEnumDesc(DynamicEnum e) {
        if (e == null) {
            return null;
        }
        return new EnumDesc(e.pk, e.getName(), e.sValue);
    }

    public static DynamicEnum createEnum(EnumDesc e) {
        if (e == null) {
            return null;
        }
        return new DynamicEnum(e.pk, e.name, e.value);
    }

    public static Map getEnumMap(String pk) {
        return Enum.getEnumMap(DynamicAssist.getFactory().getInstance(pk), true);
    }

    public static List getEnumList(String pk) {
        return Enum.getEnumList(DynamicAssist.getFactory().getInstance(pk), true);
    }

    public static Iterator iterator(String pk) {
        return DynamicEnum.getEnumList(pk).iterator();
    }

    @Override
    Enum.Assist getAssist(String className) {
        return DynamicAssist.getFactory().getInstance(this.pk);
    }

    public static class EnumDesc
    implements Serializable {
        private static final long serialVersionUID = 3597449218655312411L;
        final String pk;
        final String name;
        final String value;

        public EnumDesc(String pk, String name, String value) {
            this.pk = pk;
            this.name = name;
            this.value = value;
        }
    }

    public static abstract class DynamicAssist
    extends Enum.Assist {
        protected final String pk;
        private static Factory factory = null;

        public DynamicAssist(String pk) {
            this.pk = pk;
        }

        static Factory getFactory() {
            return factory;
        }

        protected static void registerFactory(Factory f) {
            factory = f;
        }

        protected static interface Factory {
            public DynamicAssist getInstance(String var1);
        }
    }
}

