/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.marshal;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.Null;
import com.kingdee.util.Uuid;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.MarshalConstants;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class Unmarshaller
implements ObjectInput,
MarshalConstants {
    private static Logger logger = Logger.getLogger(Unmarshaller.class);
    private static final int NULL_HANDLE = -1;
    private static final Object unsharedMarker = new Object();
    private static final HashMap primClasses = new HashMap(16, 1.0f);
    private int depth;
    private boolean closed;
    private final HandleTable handles;
    private int passHandle = -1;
    private final ObjectInput in;
    private static Method hasReadResolveMethod;
    private static Method invokeReadResolve;

    public Unmarshaller(ObjectInput in) throws IOException {
        this.in = in;
        this.handles = new HandleTable(10);
        this.readStreamHeader();
    }

    int assignHandles(Object obj) {
        this.passHandle = this.handles.assign(obj);
        return this.passHandle;
    }

    void finishHandle(int handle) {
        this.handles.finish(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        int outerHandle = this.passHandle;
        try {
            Object obj = this.readObject0();
            this.handles.markDependency(outerHandle, this.passHandle);
            ClassNotFoundException ex = this.handles.lookupException(this.passHandle);
            if (ex != null) {
                throw ex;
            }
            Object object = obj;
            return object;
        }
        finally {
            this.passHandle = outerHandle;
            if (this.closed && this.depth == 0) {
                this.clear();
            }
        }
    }

    protected Class resolveClass(String className) throws IOException, ClassNotFoundException {
        if (className == null) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            Class cl = (Class)primClasses.get(className);
            if (cl != null) {
                return cl;
            }
            throw ex;
        }
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        byte One = this.in.readByte();
        byte Two = this.in.readByte();
        if (One != 51 || Two != 1) {
            throw new StreamCorruptedException("invalid stream header:" + One + ", " + Two);
        }
    }

    private void clear() {
        this.handles.clear();
    }

    private Object readObject0() throws IOException {
        byte tc = this.in.readByte();
        ++this.depth;
        try {
            switch (tc) {
                case 64: {
                    Object object = this.readNull();
                    return object;
                }
                case 65: 
                case 66: 
                case 67: {
                    Object object = this.readHandle(tc);
                    return object;
                }
                case 70: {
                    String string = this.readString();
                    return string;
                }
                case 84: {
                    Integer n = this.readIntObject();
                    return n;
                }
                case 90: {
                    java.util.Date date = this.readUtilDate();
                    return date;
                }
                case 89: {
                    BigDecimal bigDecimal = this.readBigDecimal();
                    return bigDecimal;
                }
                case 101: {
                    Object object = this.readResolveObject(this.readMarshalData());
                    return object;
                }
                case 68: {
                    Object object = this.readResolveObject(this.readExternalData());
                    return object;
                }
                case 69: {
                    Object object = this.readSerialData();
                    return object;
                }
                case 92: {
                    Date date = this.readDate();
                    return date;
                }
                case 94: {
                    Timestamp timestamp = this.readTimestamp();
                    return timestamp;
                }
                case 99: {
                    BOSUuid bOSUuid = this.readBOSUuid();
                    return bOSUuid;
                }
                case 100: {
                    Enum enum_ = this.readEnum();
                    return enum_;
                }
                case 98: {
                    BOSObjectType bOSObjectType = this.readBOSObjectType();
                    return bOSObjectType;
                }
                case 91: {
                    Locale locale = this.readLocale();
                    return locale;
                }
                case 96: {
                    Null nullVal = this.readNullObject();
                    return nullVal;
                }
                case 80: {
                    Boolean bl = this.readBooleanObject();
                    return bl;
                }
                case 81: {
                    Byte by = this.readByteObject();
                    return by;
                }
                case 83: {
                    Short s = this.readShortObject();
                    return s;
                }
                case 82: {
                    Character c = this.readCharObject();
                    return c;
                }
                case 97: {
                    Uuid uuid = this.readUuid();
                    return uuid;
                }
                case 86: {
                    Float f = this.readFloatObject();
                    return f;
                }
                case 71: {
                    Object object = this.readArray();
                    return object;
                }
                case 85: {
                    Long l = this.readLongObject();
                    return l;
                }
                case 87: {
                    Double d = this.readDoubleObject();
                    return d;
                }
                case 93: {
                    Time time = this.readTime();
                    return time;
                }
                case 88: {
                    BigInteger bigInteger = this.readBigInteger();
                    return bigInteger;
                }
                case 72: {
                    IOException ex = this.readFatalException();
                    throw new WriteAbortedException("writing aborted", ex);
                }
            }
            throw new StreamCorruptedException("tc is " + tc);
        }
        finally {
            --this.depth;
        }
    }

    private Object readResolveObject(Object orig) {
        if (orig == null) {
            return null;
        }
        Class<?> cl = orig.getClass();
        ObjectStreamClass osc = ObjectStreamClass.lookup(cl);
        try {
            Boolean hasMethod = (Boolean)hasReadResolveMethod.invoke((Object)osc, null);
            if (hasMethod.booleanValue()) {
                return invokeReadResolve.invoke((Object)osc, orig);
            }
            return orig;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return orig;
        }
    }

    private Object readNull() throws IOException {
        this.passHandle = -1;
        return null;
    }

    private Object readHandle(byte tc) throws IOException {
        this.passHandle = tc == 65 ? this.in.readUnsignedByte() : (tc == 66 ? this.in.readUnsignedShort() : this.in.readInt());
        if (this.passHandle < 0 || this.passHandle >= this.handles.size()) {
            throw new StreamCorruptedException("illegal handle value");
        }
        Object obj = this.handles.lookupObject(this.passHandle);
        if (obj == unsharedMarker) {
            throw new InvalidObjectException("cannot read back reference to unshared object");
        }
        return obj;
    }

    private Class readClassDesc() throws IOException, ClassNotFoundException {
        return this.resolveClass(this.readString0());
    }

    private String readString0() throws IOException {
        String str;
        byte tc = this.in.readByte();
        switch (tc) {
            case 64: {
                str = (String)this.readNull();
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                str = (String)this.readHandle(tc);
                break;
            }
            case 70: {
                str = this.readString();
                break;
            }
            default: {
                throw new StreamCorruptedException();
            }
        }
        return str;
    }

    private String readString() throws IOException {
        String str = null;
        try {
            str = (String)this.in.readObject();
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e, (Throwable)e);
            throw new IllegalStateException("Unmarshaller met a non-String readObject");
        }
        this.passHandle = this.handles.assign(str);
        this.handles.finish(this.passHandle);
        return str;
    }

    private Object readArray() throws IOException {
        Class ccl = null;
        ClassNotFoundException resolveEx = null;
        try {
            ccl = this.readClassDesc();
        }
        catch (ClassNotFoundException cnfEx) {
            resolveEx = cnfEx;
        }
        int len = this.in.readInt();
        Object array = null;
        if (ccl != null) {
            array = Array.newInstance(ccl, len);
        }
        int arrayHandle = this.handles.assign(array);
        if (resolveEx != null) {
            this.handles.markException(arrayHandle, resolveEx);
        }
        if (ccl == null) {
            for (int i = 0; i < len; ++i) {
                this.readObject0();
            }
        } else if (ccl.isPrimitive()) {
            for (int i = 0; i < len; ++i) {
                if (ccl == Integer.TYPE) {
                    ((int[])array)[i] = this.in.readInt();
                    continue;
                }
                if (ccl == Byte.TYPE) {
                    ((byte[])array)[i] = this.in.readByte();
                    continue;
                }
                if (ccl == Long.TYPE) {
                    ((long[])array)[i] = this.in.readLong();
                    continue;
                }
                if (ccl == Float.TYPE) {
                    ((float[])array)[i] = this.in.readFloat();
                    continue;
                }
                if (ccl == Double.TYPE) {
                    ((double[])array)[i] = this.in.readDouble();
                    continue;
                }
                if (ccl == Short.TYPE) {
                    ((short[])array)[i] = this.in.readShort();
                    continue;
                }
                if (ccl == Character.TYPE) {
                    ((char[])array)[i] = this.in.readChar();
                    continue;
                }
                if (ccl == Boolean.TYPE) {
                    ((boolean[])array)[i] = this.in.readBoolean();
                    continue;
                }
                throw new InternalError();
            }
        } else {
            Object[] oa = (Object[])array;
            for (int i = 0; i < len; ++i) {
                oa[i] = this.readObject0();
                this.handles.markDependency(arrayHandle, this.passHandle);
            }
        }
        this.handles.finish(arrayHandle);
        this.passHandle = arrayHandle;
        return array;
    }

    private Object newObject() throws IOException, InvalidClassException {
        Class cl = null;
        ClassNotFoundException resolveEx = null;
        try {
            cl = this.readClassDesc();
        }
        catch (ClassNotFoundException cnfEx) {
            resolveEx = cnfEx;
        }
        Object obj = null;
        try {
            if (cl != null) {
                obj = cl.newInstance();
            }
        }
        catch (Exception ex) {
            throw new InvalidClassException(cl.getName(), "unable to create instance");
        }
        this.passHandle = this.handles.assign(obj);
        if (resolveEx != null) {
            this.handles.markException(this.passHandle, resolveEx);
        }
        return obj;
    }

    private Object readMarshalData() throws IOException {
        Object obj = this.newObject();
        if (obj != null) {
            try {
                ((IMarshalObject)obj).unmarshal(this);
            }
            catch (ClassNotFoundException ex) {
                this.handles.markException(this.passHandle, ex);
            }
        }
        this.handles.finish(this.passHandle);
        return obj;
    }

    private Object readExternalData() throws IOException {
        Object obj = this.newObject();
        if (obj != null) {
            try {
                ((Externalizable)obj).readExternal(this.in);
            }
            catch (ClassNotFoundException ex) {
                this.handles.markException(this.passHandle, ex);
            }
        }
        this.handles.finish(this.passHandle);
        return obj;
    }

    private Object readSerialData() throws IOException {
        Object obj;
        try {
            obj = this.in.readObject();
        }
        catch (ClassNotFoundException ex) {
            logger.error((Object)"class not found", (Throwable)ex);
            throw new InvalidClassException(ex.getMessage(), "class not found");
        }
        this.passHandle = this.handles.assign(obj);
        this.handles.finish(this.passHandle);
        return obj;
    }

    private IOException readFatalException() throws IOException {
        this.clear();
        return (IOException)this.readObject0();
    }

    private Boolean readBooleanObject() throws IOException {
        return this.in.readBoolean();
    }

    private Byte readByteObject() throws IOException {
        this.passHandle = -1;
        return new Byte(this.in.readByte());
    }

    private Short readShortObject() throws IOException {
        this.passHandle = -1;
        return new Short(this.in.readShort());
    }

    private Character readCharObject() throws IOException {
        this.passHandle = -1;
        return new Character(this.in.readChar());
    }

    private Integer readIntObject() throws IOException {
        this.passHandle = -1;
        return this.in.readInt();
    }

    private Float readFloatObject() throws IOException {
        this.passHandle = -1;
        return new Float(this.in.readFloat());
    }

    private Long readLongObject() throws IOException {
        Long l = this.in.readLong();
        this.passHandle = this.handles.assign(l);
        this.handles.finish(this.passHandle);
        return l;
    }

    private Double readDoubleObject() throws IOException {
        Double d = new Double(this.in.readDouble());
        this.passHandle = this.handles.assign(d);
        this.handles.finish(this.passHandle);
        return d;
    }

    private BigInteger readBigInteger() throws IOException {
        int len = this.in.readInt();
        byte[] ba = new byte[len];
        for (int i = 0; i < len; ++i) {
            ba[i] = this.in.readByte();
        }
        BigInteger bi = new BigInteger(ba);
        this.passHandle = this.handles.assign(bi);
        this.handles.finish(this.passHandle);
        return bi;
    }

    private BigDecimal readBigDecimal() throws IOException {
        int len = this.in.readInt();
        byte[] ba = new byte[len];
        for (int i = 0; i < len; ++i) {
            ba[i] = this.in.readByte();
        }
        int scale = this.in.readInt();
        BigDecimal dec = new BigDecimal(new BigInteger(ba), scale);
        this.passHandle = this.handles.assign(dec);
        this.handles.finish(this.passHandle);
        return dec;
    }

    private Date readDate() throws IOException {
        Date dt = new Date(this.in.readLong());
        this.passHandle = this.handles.assign(dt);
        this.handles.finish(this.passHandle);
        return dt;
    }

    private Time readTime() throws IOException {
        Time t = new Time(this.in.readLong());
        this.passHandle = this.handles.assign(t);
        this.handles.finish(this.passHandle);
        return t;
    }

    private Timestamp readTimestamp() throws IOException {
        Timestamp t = new Timestamp(this.in.readLong());
        t.setNanos(this.in.readInt());
        this.passHandle = this.handles.assign(t);
        this.handles.finish(this.passHandle);
        return t;
    }

    private java.util.Date readUtilDate() throws IOException {
        java.util.Date dt = new java.util.Date(this.in.readLong());
        this.passHandle = this.handles.assign(dt);
        this.handles.finish(this.passHandle);
        return dt;
    }

    private Locale readLocale() throws IOException {
        Locale locale = LocaleUtils.getLocale(this.in.readUTF());
        this.passHandle = this.handles.assign(locale);
        this.handles.finish(this.passHandle);
        return locale;
    }

    private Null readNullObject() throws IOException {
        this.passHandle = -1;
        return Null.NULL;
    }

    private Uuid readUuid() throws IOException {
        Uuid uuid = Uuid.read(this.in);
        this.passHandle = this.handles.assign(uuid);
        this.handles.finish(this.passHandle);
        return uuid;
    }

    private BOSObjectType readBOSObjectType() throws IOException {
        BOSObjectType type = BOSObjectType.read(this.in);
        this.passHandle = this.handles.assign(type);
        this.handles.finish(this.passHandle);
        return type;
    }

    private BOSUuid readBOSUuid() throws IOException {
        BOSUuid id = BOSUuid.read(this.in);
        this.passHandle = this.handles.assign(id);
        this.handles.finish(this.passHandle);
        return id;
    }

    private Enum readEnum() throws IOException {
        Enum obj;
        try {
            Class cl = this.readClassDesc();
            String enumName = this.readString0();
            obj = EnumUtils.getEnum(cl, enumName);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidClassException(e.getMessage(), "class not found");
        }
        this.passHandle = this.handles.assign(obj);
        this.handles.finish(this.passHandle);
        return obj;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.depth == 0) {
            this.clear();
        }
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
        try {
            Method method = ObjectStreamClass.class.getDeclaredMethod("hasReadResolveMethod", null);
            method.setAccessible(true);
            hasReadResolveMethod = method;
            Method method1 = ObjectStreamClass.class.getDeclaredMethod("invokeReadResolve", Object.class);
            method1.setAccessible(true);
            invokeReadResolve = method1;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private static class HandleTable {
        private static final byte STATUS_OK = 1;
        private static final byte STATUS_UNKNOWN = 2;
        private static final byte STATUS_EXCEPTION = 3;
        byte[] status;
        Object[] entries;
        HandleList[] deps;
        int lowDep = -1;
        int size = 0;

        HandleTable(int initialCapacity) {
            this.status = new byte[initialCapacity];
            this.entries = new Object[initialCapacity];
            this.deps = new HandleList[initialCapacity];
        }

        int assign(Object obj) {
            if (this.size >= this.entries.length) {
                this.grow();
            }
            this.status[this.size] = 2;
            this.entries[this.size] = obj;
            return this.size++;
        }

        void markDependency(int dependent, int target) {
            if (dependent == -1 || target == -1) {
                return;
            }
            block0 : switch (this.status[dependent]) {
                case 2: {
                    switch (this.status[target]) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            this.markException(dependent, (ClassNotFoundException)this.entries[target]);
                            break block0;
                        }
                        case 2: {
                            if (this.deps[target] == null) {
                                this.deps[target] = new HandleList();
                            }
                            this.deps[target].add(dependent);
                            if (this.lowDep >= 0 && this.lowDep <= target) break block0;
                            this.lowDep = target;
                            break block0;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        void markException(int handle, ClassNotFoundException ex) {
            switch (this.status[handle]) {
                case 2: {
                    this.status[handle] = 3;
                    this.entries[handle] = ex;
                    HandleList dlist = this.deps[handle];
                    if (dlist == null) break;
                    int ndeps = dlist.size();
                    for (int i = 0; i < ndeps; ++i) {
                        this.markException(dlist.get(i), ex);
                    }
                    this.deps[handle] = null;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        void finish(int handle) {
            int end;
            if (this.lowDep < 0) {
                end = handle + 1;
            } else if (this.lowDep >= handle) {
                end = this.size;
                this.lowDep = -1;
            } else {
                return;
            }
            block4: for (int i = handle; i < end; ++i) {
                switch (this.status[i]) {
                    case 2: {
                        this.status[i] = 1;
                        this.deps[i] = null;
                        continue block4;
                    }
                    case 1: 
                    case 3: {
                        continue block4;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void setObject(int handle, Object obj) {
            switch (this.status[handle]) {
                case 1: 
                case 2: {
                    this.entries[handle] = obj;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        Object lookupObject(int handle) {
            return handle != -1 && this.status[handle] != 3 ? this.entries[handle] : null;
        }

        ClassNotFoundException lookupException(int handle) {
            return handle != -1 && this.status[handle] == 3 ? (ClassNotFoundException)this.entries[handle] : null;
        }

        void clear() {
            Arrays.fill(this.status, 0, this.size, (byte)0);
            Arrays.fill(this.entries, 0, this.size, null);
            Arrays.fill(this.deps, 0, this.size, null);
            this.lowDep = -1;
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void grow() {
            int newCapacity = (this.entries.length << 1) + 1;
            byte[] newStatus = new byte[newCapacity];
            Object[] newEntries = new Object[newCapacity];
            HandleList[] newDeps = new HandleList[newCapacity];
            System.arraycopy(this.status, 0, newStatus, 0, this.size);
            System.arraycopy(this.entries, 0, newEntries, 0, this.size);
            System.arraycopy(this.deps, 0, newDeps, 0, this.size);
            this.status = newStatus;
            this.entries = newEntries;
            this.deps = newDeps;
        }

        private static class HandleList {
            private int[] list = new int[4];
            private int size = 0;

            public void add(int handle) {
                if (this.size >= this.list.length) {
                    int[] newList = new int[this.list.length << 1];
                    System.arraycopy(this.list, 0, newList, 0, this.list.length);
                    this.list = newList;
                }
                this.list[this.size++] = handle;
            }

            public int get(int index) {
                if (index >= this.size) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return this.list[index];
            }

            public int size() {
                return this.size;
            }
        }
    }
}

