/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.objbuddy;

import com.kingdee.util.StringUtils;
import com.kingdee.util.objbuddy.IBuddyObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class BuddyObjectRegistry {
    private static Map buddyNameMap;
    private static Logger logger;

    private BuddyObjectRegistry() {
    }

    public static IBuddyObject getObjectBuddyInstance(Object source) {
        String buddy = BuddyObjectRegistry.getObjectBuddyName(source.getClass().getName());
        if (StringUtils.isEmpty(buddy)) {
            return null;
        }
        try {
            Class<?> buddyClass = Class.forName(buddy);
            Class[] argTypes = new Class[]{source.getClass()};
            Object[] initArgs = new Object[]{source};
            return (IBuddyObject)buddyClass.getConstructor(argTypes).newInstance(initArgs);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot create ObjectBuddy for " + source.getClass().getName() + ", ignore."), (Throwable)e);
            return null;
        }
    }

    public static synchronized void regisiterObjectBuddy(String sourceClassName, String buddyClassName) {
        assert (!StringUtils.isEmpty(sourceClassName));
        assert (!StringUtils.isEmpty(buddyClassName));
        if (buddyNameMap == null) {
            buddyNameMap = new HashMap();
        }
        buddyNameMap.put(sourceClassName, buddyClassName);
    }

    public static synchronized void unregisiterObjectBuddy(String sourceClassName) {
        assert (!StringUtils.isEmpty(sourceClassName));
        if (buddyNameMap != null) {
            buddyNameMap.remove(sourceClassName);
        }
    }

    public static synchronized String getObjectBuddyName(String sourceClassName) {
        assert (!StringUtils.isEmpty(sourceClassName));
        if (buddyNameMap != null) {
            return (String)buddyNameMap.get(sourceClassName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        logger = Logger.getLogger((String)"com.kingdee.util.objbuddy.BuddyObjectRegistry");
        InputStream is = null;
        try {
            Properties props = new Properties();
            is = BuddyObjectRegistry.class.getResourceAsStream("BuddyObjectRegistry.properties");
            if (is != null) {
                props.load(is);
            }
            for (String string : props.keySet()) {
                String buddy = props.getProperty(string);
                if (StringUtils.isEmpty(string)) continue;
                if (!StringUtils.isEmpty(buddy)) {
                    BuddyObjectRegistry.regisiterObjectBuddy(string, buddy);
                    continue;
                }
                BuddyObjectRegistry.regisiterObjectBuddy(string, string + "Buddy");
            }
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

