/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.profile;

import com.kingdee.util.profile.ThreadProfileContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class ObjectProfileInterceptor
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.util.profile.ObjectProfileInterceptor");
    private final Object target;

    public ObjectProfileInterceptor(Object target) {
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ThreadProfileContext.getInstance().enter(this.target.getClass().getName(), method.getName(), method.toString());
        try {
            Object object = method.invoke(this.target, args);
            return object;
        }
        catch (IllegalAccessException iae) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Proxy invoke catch a IllegalAccessException", (Throwable)iae);
            }
            throw new RuntimeException(iae);
        }
        catch (IllegalArgumentException iae) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Prxoy invoke catch a IllegalArgumentException", (Throwable)iae);
            }
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException ie) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Proxy Invoke catch a target Exception, process continue", (Throwable)ie);
            }
            Throwable t = ie.getCause();
            throw t;
        }
        finally {
            ThreadProfileContext.getInstance().exit();
        }
    }
}

