/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.profile;

import com.kingdee.util.Queue;
import com.kingdee.util.profile.ProfileConfig;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ProfileLogger {
    private static boolean initialized = false;
    private static RandomAccessFile logfile;
    private static int nextFileNumber;
    private static Queue queue;
    private static ProfileConfig logConfig;

    private static synchronized void init() {
        if (initialized) {
            return;
        }
        logConfig = ProfileConfig.getInstance();
        nextFileNumber = 0;
        try {
            logfile = new RandomAccessFile(ProfileLogger.logConfig.filename, "rw");
            logfile.seek(logfile.length());
        }
        catch (IOException e) {
            ProfileLogger.logConfig.console = true;
            ProfileLogger.logToConsole("Cannot open log file " + ProfileLogger.logConfig.filename);
        }
        queue = new Queue();
        JVMHook hook = new JVMHook();
        Runtime.getRuntime().addShutdownHook(hook);
        LazyLog lazy = new LazyLog();
        lazy.setDaemon(true);
        lazy.setPriority(1);
        lazy.start();
        initialized = true;
    }

    static void write(String[] msgs) {
        if (!initialized) {
            return;
        }
        if (msgs == null || msgs.length == 0) {
            return;
        }
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < msgs.length; ++i) {
            sbuf.append(msgs[i]);
            if (i >= msgs.length - 1) continue;
            sbuf.append(",");
        }
        String msg = sbuf.toString();
        ProfileLogger.logToConsole(msg);
        queue.put(msg);
    }

    static void flush() {
        while (!queue.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    private static void logToConsole(String msg) {
        if (logConfig == null) {
            return;
        }
        if (ProfileLogger.logConfig.console) {
            System.out.println(msg);
        }
    }

    private static void logToFile(String msg) {
        if (logfile == null) {
            return;
        }
        try {
            if (ProfileLogger.logConfig.maxFileSize > 0 && logfile.length() > (long)ProfileLogger.logConfig.maxFileSize * 1024L) {
                ProfileLogger.rotateLog();
            }
        }
        catch (IOException e) {
            ProfileLogger.logToConsole("Cannot rotate log file: " + e);
            return;
        }
        try {
            byte[] b = (msg + "\n").getBytes();
            logfile.write(b);
        }
        catch (IOException e) {
            ProfileLogger.logToConsole("Error: Cannot write to log file. Disk full?");
        }
    }

    private static void rotateLog() throws IOException {
        File newfile;
        logfile.close();
        logfile = null;
        File file = new File(ProfileLogger.logConfig.filename);
        while ((newfile = new File(ProfileLogger.logConfig.filename + "." + ++nextFileNumber)).exists()) {
        }
        if (!file.renameTo(newfile)) {
            ProfileLogger.logToConsole("Couldn't rename log file, log not rotated.");
        }
        logfile = new RandomAccessFile(ProfileLogger.logConfig.filename, "rw");
        logfile.seek(logfile.length());
    }

    static {
        ProfileLogger.init();
    }

    static class JVMHook
    extends Thread {
        JVMHook() {
        }

        @Override
        public void run() {
            while (!queue.isEmpty()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            try {
                logfile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class LazyLog
    extends Thread {
        LazyLog() {
        }

        @Override
        public void run() {
            while (true) {
                String msg = (String)queue.get();
                ProfileLogger.logToFile(msg);
            }
        }
    }
}

