/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.dom.expr;

import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.parser.Position;

public class StringExpr
extends CodeExpr {
    public String text;

    public StringExpr() {
        super(null, 5);
    }

    public StringExpr(Position pos) {
        super(pos, 5);
    }

    public StringExpr(String text) {
        this(null, text);
    }

    public StringExpr(Position pos, String text) {
        super(pos, 5);
        this.text = text;
    }

    @Override
    public void setExprClass(Class val) {
        throw new UnsupportedOperationException();
    }

    public String getJavaString() {
        StringBuffer buff = new StringBuffer();
        int length = this.text.length();
        for (int i = 0; i < length; ++i) {
            char c = this.text.charAt(i);
            if (c == '\'' && i != length - 1 && this.text.charAt(i + 1) == '\'') continue;
            buff.append(c);
        }
        return buff.toString();
    }

    @Override
    public void output(StringBuffer buff) {
        buff.append('\"');
        block7: for (int i = 0; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            switch (ch) {
                case '\\': {
                    buff.append("\\\\");
                    continue block7;
                }
                case '\"': {
                    buff.append("\\\"");
                    continue block7;
                }
                case '\t': {
                    buff.append("\\t");
                    continue block7;
                }
                case '\r': {
                    buff.append("\\r");
                    continue block7;
                }
                case '\n': {
                    buff.append("\\n");
                    continue block7;
                }
                default: {
                    buff.append(ch);
                }
            }
        }
        buff.append('\"');
    }

    @Override
    public final Class getExprClass() {
        return String.class;
    }
}

