/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.parser;

import com.kingdee.bos.kscript.debug.SourceCache;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class Source
implements Serializable {
    public final String name;
    public transient String text;
    private int hashCode;
    private Object key;
    private int[] poses = null;
    private int line_count = 0;

    public Source(String text) {
        this(null, text);
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        Source s = SourceCache.getRegisteredSource(this);
        if (s != null && s.name != null) {
            return s.name;
        }
        return "KS#" + this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object x) {
        if (x == null) {
            return false;
        }
        if (!(x instanceof Source)) {
            return false;
        }
        if (this == x) {
            return true;
        }
        return this.key.equals(((Source)x).key);
    }

    public Source(File file) throws IOException {
        this(file.getName(), Source.loadFile(file));
        SourceCache.registerSource(this);
    }

    private static String loadFile(File file) throws IOException {
        int size = (int)file.length();
        byte[] data = new byte[size];
        FileInputStream in = new FileInputStream(file);
        new DataInputStream(in).readFully(data);
        in.close();
        return new String(data);
    }

    public Source(String name, String text) {
        this.name = name;
        this.text = text;
        this.hashCode = this.text.hashCode();
        this.key = new Long((long)text.length() << 32 | 0xFFFFFFFFL & (long)this.hashCode);
    }

    public Object getKey() {
        return this.key;
    }

    public synchronized String getText() {
        Source s;
        if (this.text == null && (s = SourceCache.getRegisteredSource(this)) != null) {
            this.text = s.text;
        }
        return this.text;
    }

    private int[] getPoses() {
        if (this.poses == null) {
            int i;
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(0);
            int c = 10;
            this.line_count = 0;
            for (i = 0; i < this.getText().length(); ++i) {
                if (c == 10) {
                    ++this.line_count;
                }
                if ((c = (int)this.text.charAt(i)) != 10) continue;
                list.add(i + 1);
            }
            if (c != 10) {
                list.add(this.text.length());
            }
            this.poses = new int[list.size()];
            for (i = 0; i < list.size(); ++i) {
                this.poses[i] = (Integer)list.get(i);
            }
        }
        return this.poses;
    }

    public int getLineCount() {
        this.getPoses();
        return this.line_count;
    }

    public String getLine(int lineNumber) {
        int[] poses = this.getPoses();
        if (lineNumber < 1 || lineNumber > this.line_count) {
            return null;
        }
        int p0 = poses[lineNumber - 1];
        int p1 = poses[lineNumber];
        String line = this.getText().substring(p0, p1);
        if (line.endsWith("\r\n")) {
            line = line.substring(0, line.length() - 2);
        } else if (line.endsWith("\n")) {
            line = line.substring(0, line.length() - 1);
        }
        return line;
    }

    public int getLineStartPosition(int lineNumber) {
        int[] poses = this.getPoses();
        return poses[lineNumber - 1];
    }

    public int getLineNumberByPosition(int position) {
        int[] poses = this.getPoses();
        for (int i = 0; i < poses.length - 1; ++i) {
            if (position < poses[i] || position >= poses[i + 1]) continue;
            return i + 1;
        }
        return 0;
    }

    public int getColumnByPosition(int position) {
        int[] poses = this.getPoses();
        for (int i = 0; i < poses.length - 1; ++i) {
            if (position < poses[i] || position >= poses[i + 1]) continue;
            return position - poses[i] + 1;
        }
        return 0;
    }

    public int getPosition(int line, int col) {
        return this.getLineStartPosition(line) + col - 1;
    }
}

