/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.runtime;

import com.kingdee.bos.kscript.runtime.PrimitiveNumber;

public class PrimitiveDouble
extends PrimitiveNumber {
    private double value;

    @Override
    public Class getBoxType() {
        return Double.class;
    }

    @Override
    public Class getUnBoxType() {
        return Double.TYPE;
    }

    public PrimitiveDouble(double val) {
        this.value = val;
    }

    public PrimitiveDouble(Double val) {
        this.value = val.floatValue();
    }

    public void setValue(float val) {
        this.value = val;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Object getBoxValue() {
        return new Double(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrimitiveDouble) {
            return this.value == ((PrimitiveDouble)obj).value;
        }
        return false;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }
}

