/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.ui;

import com.kingdee.bos.kscript.debug.AbstractBreakPoints;
import com.kingdee.bos.kscript.debug.BreakPoints;
import com.kingdee.bos.kscript.debug.DebugEnv;
import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.debug.IDebugProvider;
import com.kingdee.bos.kscript.debug.IDebugRuntime;
import com.kingdee.bos.kscript.debug.remote.DebugRemoteContext;
import com.kingdee.bos.kscript.debug.remote.IDebugServerController;
import com.kingdee.bos.kscript.debug.ui.ChangedManager;
import com.kingdee.bos.util.lightremote.ICloseListener;
import com.kingdee.bos.util.lightremote.IObjectStub;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DebugManager
extends ChangedManager {
    static final Logger logger = Logger.getLogger(DebugManager.class);
    private IDebugProvider localDebugProvider;
    private ArrayList list = new ArrayList();
    private IDebugRuntime local = null;
    private HashMap sources = new HashMap();

    public IDebugProvider getLocalDebugProvider() {
        return this.localDebugProvider;
    }

    public void setLocalDebugProvider(IDebugProvider localDebugProvider) {
        this.localDebugProvider = localDebugProvider;
    }

    private void unlistDebug(IDebugRuntime runtime, int index) {
        if (index >= 0 && index < this.list.size()) {
            Element elem = (Element)this.list.remove(index);
            if (!elem.localClose) {
                // empty if block
            }
        }
        try {
            runtime.terminate();
        }
        catch (Exception elem) {
            // empty catch block
        }
        try {
            IObjectStub stub = DebugRemoteContext.getStubInterface(runtime);
            if (stub != null) {
                stub._getRemoteContext().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.fireChangedEvent(this, null);
    }

    public static String getDebugRuntimeName(IDebugRuntime runtime) {
        String name = (String)runtime.getTag((Object)"name");
        if (name == null) {
            return "(local)";
        }
        return name;
    }

    public static String getDebugRuntimeName(IDebugContext debug) {
        return DebugManager.getDebugRuntimeName(debug.getEnv());
    }

    public synchronized Element[] getRuntimes() {
        Element[] ar = new Element[this.list.size()];
        this.list.toArray(ar);
        return ar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateAll() {
        DebugManager debugManager = this;
        synchronized (debugManager) {
            for (int i = 0; i < this.list.size(); ++i) {
                Element x = (Element)this.list.get(i);
                try {
                    x.runtime.terminate();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.local = null;
            this.list.clear();
        }
        super.fireChangedEvent(this, null);
    }

    public boolean isRemote(IDebugRuntime runtime) {
        return runtime.getLocalIdentifier() != DebugEnv.LOCAL_IDENTIFIER;
    }

    public boolean isRemote(IDebugContext debug) {
        return debug.getLocalIdentifier() != DebugEnv.LOCAL_IDENTIFIER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlistDebug(IDebugRuntime debugRuntime) {
        DebugManager debugManager = this;
        synchronized (debugManager) {
            for (int i = 0; i < this.list.size(); ++i) {
                Element e = (Element)this.list.get(i);
                if (e.isLocal() || e.runtime != debugRuntime) continue;
                this.unlistDebug(debugRuntime, i);
                return;
            }
        }
        this.unlistDebug(debugRuntime, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enlistDebug(String name, final IDebugRuntime debugRuntime) {
        DebugManager debugManager = this;
        synchronized (debugManager) {
            if (name == null) {
                this.local = debugRuntime;
            }
            debugRuntime.setSourcesAndBreakPoints(new HashMap(this.sources));
            debugRuntime.setTag((Object)"name", (Object)name);
            this.list.add(new Element(name, debugRuntime));
            IObjectStub stub = DebugRemoteContext.getStubInterface(debugRuntime);
            if (stub != null) {
                stub._getRemoteContext().addCloseListener(new ICloseListener(){

                    @Override
                    public void onClosed(Object source) {
                        DebugManager.this.unlistDebug(debugRuntime);
                    }
                });
            }
        }
        super.fireChangedEvent(this, null);
    }

    public synchronized void registerDebugSource(Object sourceKey) {
        if (!this.sources.containsKey(sourceKey)) {
            this.sources.put(sourceKey, null);
        }
        for (int i = this.list.size() - 1; i >= 0; --i) {
            Element x = (Element)this.list.get(i);
            boolean remove = true;
            try {
                x.runtime.registerDebugSource(sourceKey);
                remove = false;
            }
            catch (Exception ex) {
                logger.debug((Object)ex);
                logger.debug((Object)("remove debug runtime " + x.name));
            }
            if (!remove) continue;
            this.unlistDebug(x.runtime, i);
        }
    }

    public synchronized void unregisterDebugSource(Object sourceKey) {
        this.sources.remove(sourceKey);
        for (int i = this.list.size() - 1; i >= 0; --i) {
            Element x = (Element)this.list.get(i);
            boolean remove = true;
            try {
                x.runtime.unregisterDebugSource(sourceKey);
                remove = false;
            }
            catch (Exception ex) {
                logger.debug((Object)ex);
                logger.debug((Object)("remove debug runtime " + x.name));
            }
            if (!remove) continue;
            this.unlistDebug(x.runtime, i);
        }
    }

    public synchronized void setBreakPoints(Object sourceKey, BreakPoints breakPoints) {
        breakPoints = breakPoints.copy();
        this.sources.put(sourceKey, breakPoints);
        for (int i = this.list.size() - 1; i >= 0; --i) {
            Element x = (Element)this.list.get(i);
            boolean remove = true;
            try {
                x.runtime.setBreakPoints(sourceKey, (AbstractBreakPoints)breakPoints);
                remove = false;
            }
            catch (Exception ex) {
                logger.debug((Object)ex);
                logger.debug((Object)("remove debug runtime " + x.name));
            }
            if (!remove) continue;
            this.unlistDebug(x.runtime, i);
        }
    }

    public IDebugRuntime connectRemote(String address) throws Exception {
        IDebugRuntime runtime = DebugRemoteContext.createRemoteDebugEnv(this.getLocalDebugProvider(), address);
        this.enlistDebug(address, runtime);
        return runtime;
    }

    public static boolean isRpcSupported() {
        try {
            Class.forName("com.kingdee.bos.rpc.RPCEngine");
            return true;
        }
        catch (ClassNotFoundException _) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDebugRuntime connectRpcRemote(String url, int startPort, int endPort, String address) throws Exception {
        Class<?> rpcClass = Class.forName("com.kingdee.bos.rpc.RPCEngine");
        Method md = rpcClass.getMethod("createRemoteObject", String.class, String.class, Class.class);
        Class<?> modelClass = Class.forName("com.kingdee.bos.kscript.debug.remote.IDebugServerControllerModel");
        String modelClassName = "com.kingdee.bos.kscript.debug.remote.DebugServerController";
        IDebugServerController controller = (IDebugServerController)md.invoke(null, url, modelClassName, modelClass);
        controller.startDebugServer(startPort, endPort);
        try {
            if (address == null || address.length() == 0) {
                address = controller.getLocalAddress().getHostAddress() + ":" + controller.getLocalPort();
            } else if (address.indexOf(58) < 0) {
                address = address + ":" + controller.getLocalPort();
            }
            IDebugRuntime iDebugRuntime = this.connectRemote(address);
            return iDebugRuntime;
        }
        finally {
            controller.shutdownServer();
        }
    }

    public static boolean isRemoteInstance(Object instance) {
        return DebugRemoteContext.isStubObject(instance);
    }

    public static boolean isRemoteConnectionClosed(Object instance) {
        return DebugRemoteContext.isStubConnectionClosed(instance);
    }

    public class Element {
        public boolean localClose = false;
        public final String name;
        public final IDebugRuntime runtime;

        public Element(String name, IDebugRuntime runtime) {
            this.name = name;
            this.runtime = runtime;
        }

        public String getName() {
            if (this.name == null) {
                return "(local)";
            }
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public boolean isLocal() {
            return this.runtime == DebugManager.this.local;
        }
    }
}

