/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.ui.swt;

import com.kingdee.bos.dao.ormapping.KscriptObjectLoaderProvider;
import com.kingdee.bos.kscript.IObjectLoaderProvider;
import com.kingdee.bos.kscript.debug.BreakPoints;
import com.kingdee.bos.kscript.debug.DebugEnv;
import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.debug.IDebugProvider;
import com.kingdee.bos.kscript.debug.IDebugRuntime;
import com.kingdee.bos.kscript.debug.IValue;
import com.kingdee.bos.kscript.debug.ui.DebugManager;
import com.kingdee.bos.kscript.debug.ui.StringScriptProvider;
import com.kingdee.bos.kscript.debug.ui.swt.VarTreeViewerContentProvider;
import com.kingdee.bos.kscript.debug.ui.swt.VarTreeViewerLabelProvider;
import com.kingdee.bos.kscript.debug.ui.swt.VarTreeViewerModel;
import com.kingdee.bos.kscript.parser.Position;
import com.kingdee.bos.kscript.parser.Source;
import com.kingdee.bos.kscript.runtime.Interpreter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class DebugUISWT2
extends Dialog
implements IDebugProvider {
    private final BreakPoints breakPoints = new BreakPoints();
    private IDebugContext debugContext = null;
    public final DebugManager debugManager = new DebugManager();
    private TreeViewer treeViewer;
    private int curLine = 0;
    private ListViewer listViewer;
    private Source ksSource;

    public DebugManager getDebugManager() {
        return this.debugManager;
    }

    public IDebugContext getDebugContext() {
        return this.debugContext;
    }

    public void setDebugContext(IDebugContext debugContext) {
        this.debugContext = debugContext;
    }

    public DebugUISWT2(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(1040);
        this.breakPoints.setModified(true);
        this.getDebugManager().registerDebugSource(this.getSource().getKey());
    }

    public void setBreakPoints() {
        if (this.breakPoints.isModified()) {
            this.getDebugManager().setBreakPoints(this.getSource().getKey(), this.breakPoints);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.numColumns = 2;
        this.listViewer = new ListViewer(container, 2048);
        this.listViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new ViewerLabelProvider());
        this.initListViewer(this.listViewer);
        List list = this.listViewer.getList();
        list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                List list = (List)e.getSource();
                int line = list.getSelectionIndex() + 1;
                if (line > 0) {
                    DebugUISWT2.this.breakPoints.reverseLine(line);
                    DebugUISWT2.this.updateSourceLine(line);
                    DebugUISWT2.this.setBreakPoints();
                }
            }
        });
        list.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.treeViewer = new TreeViewer(container, 2048);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new VarTreeViewerLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new VarTreeViewerContentProvider());
        this.treeViewer.setInput(null);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeColumn treeColumn = new TreeColumn(tree, 0);
        treeColumn.setWidth(100);
        treeColumn.setText("name");
        treeColumn = new TreeColumn(tree, 0);
        treeColumn.setWidth(100);
        treeColumn.setText("type");
        treeColumn = new TreeColumn(tree, 0);
        treeColumn.setWidth(100);
        treeColumn.setText("value");
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        Button btnRun = new Button(container, 0);
        btnRun.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        btnRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugUISWT2.this.curLine = 0;
                new Thread(){

                    @Override
                    public void run() {
                        Interpreter r = new Interpreter();
                        if (r.getBizObjectProvider() == null) {
                            r.setBizObjectProvider((IObjectLoaderProvider)new KscriptObjectLoaderProvider());
                        }
                        try {
                            Object rtn = r.eval(DebugUISWT2.this.getSource().getText(), null);
                            System.out.println("rtn " + rtn);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }.start();
            }
        });
        btnRun.setText("run");
        new Label(container, 0);
        Button btnResume = new Button(container, 0);
        btnResume.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugUISWT2.this.getDebugContext().resume();
            }
        });
        btnResume.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        btnResume.setText("resume");
        new Label(container, 0);
        Button btnStop = new Button(container, 0);
        btnStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugUISWT2.this.getDebugContext().stop();
            }
        });
        btnStop.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        btnStop.setText("stop");
        new Label(container, 0);
        Button btnStepover = new Button(container, 0);
        btnStepover.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugUISWT2.this.getDebugContext().stepOver();
            }
        });
        btnStepover.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        btnStepover.setText("stepover");
        new Label(container, 0);
        Button btnStepinto = new Button(container, 0);
        btnStepinto.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugUISWT2.this.getDebugContext().stepInto();
            }
        });
        btnStepinto.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        btnStepinto.setText("stepinto");
        new Label(container, 0);
        Button btnStepout = new Button(container, 0);
        btnStepout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugUISWT2.this.getDebugContext().stepOut();
            }
        });
        btnStepout.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        btnStepout.setText("stepout");
        new Label(container, 0);
        return container;
    }

    public void updateSourceLine(final int line) {
        Source source = this.getSource();
        if (source != null && line > 0 && line <= source.getLineCount()) {
            final String str = this.getSourceLine(line);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DebugUISWT2.this.listViewer.getList().setItem(line - 1, str);
                }
            });
        }
    }

    private void initListViewer(ListViewer listViewer) {
        Source source = this.getSource();
        if (source != null) {
            listViewer.setInput((Object)source);
        }
    }

    private int getCurrentDebugLine() {
        try {
            IDebugContext debug = this.getDebugContext();
            if (debug == null) {
                return 0;
            }
            int state = debug.getState();
            if (state != 4 && state != 1) {
                return 0;
            }
            Position pos = debug.getCurrentPosition();
            if (!pos.isValidPosition()) {
                return 0;
            }
            if (!pos.source.equals((Object)this.getSource())) {
                return 0;
            }
            return pos.beginLine;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private String getSourceLine(int line) {
        StringBuffer sb = new StringBuffer();
        if (this.getCurrentDebugLine() == line) {
            sb.append(">");
        } else {
            sb.append(" ");
        }
        if (this.breakPoints.containsLine(line)) {
            sb.append("*");
        } else {
            sb.append(" ");
        }
        sb.append(line);
        while (sb.length() < 8) {
            sb.append(" ");
        }
        String s = this.getSource().getLine(line);
        if (s != null) {
            s = s.replaceAll("\t", "    ");
            sb.append(s);
        }
        return sb.toString();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(671, 532);
    }

    public Source getSource() {
        if (this.ksSource != null) {
            return this.ksSource;
        }
        try {
            this.ksSource = new StringScriptProvider().loadScript("int a=0;\na++;\na++;\na++;\nreturn a;").getSource();
        }
        catch (Exception ex) {
            this.ksSource = null;
        }
        return this.ksSource;
    }

    public static void main(String[] args) {
        DebugUISWT2 dialog = new DebugUISWT2(new Shell());
        DebugEnv env = (DebugEnv)DebugEnv.registerDebuger(dialog);
        dialog.getDebugManager().enlistDebug(null, (IDebugRuntime)env);
        dialog.open();
    }

    public void debugNotify(IDebugContext debug, int state, IValue value) {
        this.setDebugContext(debug);
        if (this.curLine > 0) {
            this.updateSourceLine(this.curLine);
        }
        this.curLine = this.getCurrentDebugLine();
        this.updateSourceLine(this.getCurrentDebugLine());
        if (debug.getState() == 4 || debug.getState() == 8 || debug.getState() == 1) {
            final IValue context = debug.getContext();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DebugUISWT2.this.treeViewer.setInput((Object)new VarTreeViewerModel("context", context));
                }
            });
        }
    }

    private static class ViewerLabelProvider
    extends LabelProvider {
        private ViewerLabelProvider() {
        }

        public Image getImage(Object element) {
            return super.getImage(element);
        }

        public String getText(Object element) {
            return super.getText(element);
        }
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Source source = (Source)inputElement;
            int len = source.getLineCount();
            Object[] rtn = new Object[len];
            for (int i = 0; i < len; ++i) {
                String str = DebugUISWT2.this.getSourceLine(i + 1);
                rtn[i] = str;
            }
            return rtn;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

