/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.ui.swt;

import com.kingdee.bos.kscript.debug.IDebugRuntime;
import com.kingdee.bos.kscript.debug.ui.DebugManager;
import com.kingdee.bos.kscript.debug.ui.swt.DebugUISWT;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RemoteConnectDialog
extends Dialog {
    private Text txtRpcUrl;
    private Text txtStartListenPort;
    private Text txtEndListenPort;
    private Text txtDebugServerAddr;
    private Button btnRpcControler;
    private DebugUISWT debugUI;
    private boolean isRpcConnect = false;
    private String rpcUrl = "";
    private String startListenPort = "";
    private String endListenPort = "";
    private String debugServerAddr = "";
    private IDebugRuntime remoteDebugRuntime;

    public IDebugRuntime getRemoteDebugRuntime() {
        return this.remoteDebugRuntime;
    }

    public RemoteConnectDialog(DebugUISWT debugUI) {
        super((IShellProvider)debugUI);
        this.debugUI = debugUI;
    }

    public void set(boolean isRpcConnect, String rpcUrl, String startListenPort, String endListenPort, String debugServerAddr) {
        this.isRpcConnect = isRpcConnect;
        this.rpcUrl = rpcUrl;
        this.startListenPort = startListenPort;
        this.endListenPort = endListenPort;
        this.debugServerAddr = debugServerAddr;
    }

    public boolean isRpcConnect() {
        return this.isRpcConnect;
    }

    public String getRpcUrl() {
        return this.rpcUrl;
    }

    public String getStartListenPort() {
        return this.startListenPort;
    }

    public String getEndListenPort() {
        return this.endListenPort;
    }

    public String getDebugServerAddr() {
        return this.debugServerAddr;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.numColumns = 2;
        this.btnRpcControler = new Button(container, 32);
        this.btnRpcControler.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.btnRpcControler.setText("RPC Controller");
        this.btnRpcControler.setSelection(this.isRpcConnect);
        new Label(container, 0);
        Label lblRpcUrl = new Label(container, 0);
        lblRpcUrl.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        lblRpcUrl.setText("RPC URL:");
        this.txtRpcUrl = new Text(container, 2048);
        this.txtRpcUrl.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.txtRpcUrl.setText(this.rpcUrl);
        Label lblStartListenPort = new Label(container, 0);
        lblStartListenPort.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        lblStartListenPort.setText("Start Listen Port:");
        this.txtStartListenPort = new Text(container, 2048);
        this.txtStartListenPort.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtStartListenPort.setText(this.startListenPort);
        Label lblEndListenPort = new Label(container, 0);
        lblEndListenPort.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        lblEndListenPort.setText("End Listen Port:");
        this.txtEndListenPort = new Text(container, 2048);
        this.txtEndListenPort.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtEndListenPort.setText(this.endListenPort);
        Label lblDebugserverAddress = new Label(container, 0);
        lblDebugserverAddress.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        lblDebugserverAddress.setText("DebugServer Address:");
        this.txtDebugServerAddr = new Text(container, 2048);
        this.txtDebugServerAddr.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtDebugServerAddr.setText(this.debugServerAddr);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        button.setText("Connect");
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(481, 257);
    }

    private boolean isNull(Text f) {
        String s = f.getText();
        return s == null || s.trim().length() == 0;
    }

    private String getText(Text f) {
        String s = f.getText();
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private int getInt(Text f) {
        if (this.isNull(f)) {
            return 0;
        }
        return Integer.parseInt(this.getText(f));
    }

    protected void okPressed() {
        try {
            this.remoteDebugRuntime = null;
            if (this.btnRpcControler.getSelection()) {
                if (this.isNull(this.txtRpcUrl)) {
                    this.showMessage("Rpc url is empty.");
                    return;
                }
                String url = this.getText(this.txtRpcUrl);
                int start = this.getInt(this.txtStartListenPort);
                int end = this.getInt(this.txtEndListenPort);
                String addr = this.getText(this.txtDebugServerAddr);
                this.remoteDebugRuntime = this.debugUI.getDebugManager().connectRpcRemote(url, start, end, addr);
            } else {
                if (this.isNull(this.txtDebugServerAddr)) {
                    this.showMessage("Address is empty");
                    return;
                }
                String addr = this.getText(this.txtDebugServerAddr);
                this.remoteDebugRuntime = this.debugUI.getDebugManager().connectRemote(addr);
            }
            this.showMessage("Remote Debug Server '" + DebugManager.getDebugRuntimeName(this.remoteDebugRuntime) + "' connected.");
            this.set(this.btnRpcControler.getSelection(), this.getText(this.txtRpcUrl), this.getText(this.txtStartListenPort), this.getText(this.txtEndListenPort), this.getText(this.txtDebugServerAddr));
            super.okPressed();
        }
        catch (Exception ex) {
            this.showMessage("Connect Error!");
        }
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Remote Connect", (String)message);
    }
}

