/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow;

import java.io.Serializable;

public class Result
implements Serializable {
    private Object resultData;
    private Throwable exception;
    private String msg;
    private int type;
    public static final int SUCCESS = 1;
    public static final int ERROR = 0;
    public static final int WARN = 2;
    private int code;

    public Result() {
    }

    public Result(int type, int code, String msg) {
        this.code = code;
        this.msg = msg;
        this.type = type;
    }

    public Result(int type, int code, String msg, Serializable data) {
        this.code = code;
        this.msg = msg;
        this.type = type;
        this.resultData = data;
    }

    public Result(int type, int code, String msg, Serializable data, Throwable e) {
        this.code = code;
        this.msg = msg;
        this.type = type;
        this.resultData = data;
        this.exception = e;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public Object getResultData() {
        return this.resultData;
    }

    public void setResultData(Object newData) {
        this.resultData = newData;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable e) {
        this.exception = e;
    }

    public static Result success() {
        return new Result(1, 1, "success");
    }

    public static Result success(String info) {
        return new Result(1, 1, info);
    }

    public static Result success(String info, Serializable data) {
        return new Result(1, 1, info, data);
    }

    public static Result error(String info) {
        return new Result(0, 0, info);
    }

    public static Result error(Throwable e) {
        return new Result(0, 0, e.getMessage(), null, e);
    }

    public static Result warn(String info) {
        return new Result(2, 2, info);
    }
}

