/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.SubmitAssignResult;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.BizUtils;
import com.kingdee.bos.workflow.exception.AssignmentAlreadyInEventQueueException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.util.LowTimer;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class BizClient {
    public static final String WFASSIGNMENT_CONTEXT_NAME = "WfAssignmentInfo";
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.biz.BizClient");
    private IEnactmentService engine = null;

    private BizClient() throws WfException {
        try {
            this.engine = EnactmentServiceFactory.createRemoteEnactService();
        }
        catch (BOSException e) {
            throw new WfException(e);
        }
    }

    public static BizClient newInstance() throws WfException {
        return new BizClient();
    }

    public static BizClient newInstance(String url) throws WfException {
        return BizClient.newInstance();
    }

    public Map checkAssignmentInfo(String[] boIds, IMetaDataPK uiObjPK, String action, String userId) throws WfException {
        Map assignments = new HashMap();
        if (boIds == null || boIds.length == 0) {
            return assignments;
        }
        String editUI = BizUtils.getEditUIClassByBillId(boIds[0]);
        if (editUI == null || editUI.length() == 0) {
            this.setOrigAssignments(boIds, assignments);
            return assignments;
        }
        assignments = this.engine.checkAssignmentInfo(boIds, uiObjPK, action, userId);
        return assignments;
    }

    public AssignmentInfo[] checkAssignmentInfos(String boid, String userId) throws WfException {
        return this.engine.checkAssignmentInfos(boid, userId);
    }

    public String[] checkBusinessObjectAssignActions(String boid, String userId) throws WfException {
        String[] selector = new String[]{"assignID", "bizOperation"};
        AssignmentInfo[] assigns = this.engine.checkAssignmentInfos(boid, userId, selector);
        if (assigns == null || assigns.length == 0) {
            return new String[0];
        }
        String[] actions = new String[assigns.length];
        for (int i = 0; i < assigns.length; ++i) {
            actions[i] = assigns[i].getBizOperation();
        }
        return actions;
    }

    public boolean checkAssignmentInfo(Map boMap, String userId, Map uiContext, IMetaDataPK uiObjPK, String action) throws WfException {
        AssignmentInfo assignment = null;
        if (uiContext != null && (assignment = (AssignmentInfo)uiContext.get(WFASSIGNMENT_CONTEXT_NAME)) != null) {
            return BizUtils.checkAssignmentInfo(assignment, action);
        }
        String bizObjId = null;
        for (Object obj : boMap.keySet()) {
            String item;
            String string = item = obj != null ? obj.toString() : "";
            if (bizObjId == null) {
                bizObjId = item;
                continue;
            }
            bizObjId = bizObjId + ", " + item;
        }
        AssignmentInfo[] assignmentInfos = null;
        try {
            assignmentInfos = this.engine.checkAssignmentInfo(bizObjId, userId, uiObjPK, action);
        }
        catch (AssignmentAlreadyInEventQueueException e) {
            return false;
        }
        catch (MatchAssignmentException e) {
            return false;
        }
        if (assignmentInfos != null && assignmentInfos.length > 0) {
            assignment = assignmentInfos[0];
        }
        if (assignment == null) {
            return true;
        }
        return BizUtils.checkAssignmentInfo(assignment, action);
    }

    public boolean submitAssignment(Map dataObjects, String userId, Map uiContext, IMetaDataPK uiObjPK, String action) throws WfException {
        LowTimer timer = new LowTimer();
        AssignmentInfo assignment = null;
        if (uiContext != null) {
            assignment = (AssignmentInfo)uiContext.get(WFASSIGNMENT_CONTEXT_NAME);
        }
        String packageName = "";
        String functionName = "";
        String operation = "";
        Map operations = null;
        if (assignment != null) {
            packageName = assignment.getBizPackage();
            functionName = assignment.getBizFunction();
            operation = assignment.getBizOperation();
        } else {
            try {
                operations = this.engine.getRemoteOperation(uiObjPK, action);
            }
            catch (BOSException ex) {
                log.error((Object)"cannot found operation infomation about the UI Object", (Throwable)ex);
                return false;
            }
            if (operations == null) {
                log.debug((Object)"cannot find any operation info about this UI Object!");
                return false;
            }
            for (Map.Entry entry : operations.entrySet()) {
                String key = (String)entry.getKey();
                OperationInfo operationInfo = (OperationInfo)entry.getValue();
                if (key.indexOf("-") != -1) {
                    key = key.substring(0, key.lastIndexOf("-"));
                }
                packageName = MetaDataUtils.getPackageName((String)key);
                functionName = MetaDataUtils.getClassName((String)key);
                operation = operationInfo.getName();
            }
        }
        SubmitAssignResult result = this.engine.submitAssignment(dataObjects, userId, packageName, functionName, operation, assignment, null);
        if (result.getStatus()) {
            uiContext.remove(WFASSIGNMENT_CONTEXT_NAME);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("submitAssignment cost : " + timer.msValue()));
        }
        return result.getStatus();
    }

    public void submitAssignment(Map assignments, String userId) throws WfException {
        if (assignments == null || assignments.size() == 0 || userId == null || userId.length() == 0) {
            return;
        }
    }

    public SubmitAssignResult submitAssignment(Map businessObjects, String userId, AssignmentInfo assignment) throws WfException {
        return null;
    }

    private void setOrigAssignments(String[] boIds, Map assignments) {
        int n = boIds.length;
        for (int i = 0; i < n; ++i) {
            assignments.put(boIds[i], null);
        }
    }
}

