/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.metas.BizProcMetaCollection;
import com.kingdee.bos.workflow.metas.BizProcMetaFactory;
import com.kingdee.bos.workflow.metas.BizProcMetaInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DeployedEventSet
implements Serializable {
    private static final long serialVersionUID = -2750646424904708445L;
    private Set set = new HashSet();
    private static Map instances = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeployedEventSet getInstance(Context ctx) throws BOSException {
        String key = ctx.getSolution() + "|" + ctx.getAIS();
        if (instances.containsKey(key)) {
            return (DeployedEventSet)instances.get(key);
        }
        Map map = instances;
        synchronized (map) {
            DeployedEventSet instance = new DeployedEventSet(ctx);
            instances.put(key, instance);
            return instance;
        }
    }

    public DeployedEventSet(Context ctx) throws BOSException {
        this.initData(ctx);
    }

    private void initData(Context ctx) throws BOSException {
        BizProcMetaCollection bizProcCol = BizProcMetaFactory.getLocalInstance(ctx).getCollection();
        int n = bizProcCol.size();
        for (int i = 0; i < n; ++i) {
            BizProcMetaInfo bizProcInfo = bizProcCol.get(i);
            String bizPackage = bizProcInfo.getBizPackage();
            String bizFunc = bizProcInfo.getBizFunc();
            String bizOper = bizProcInfo.getBizOperation();
            String key = bizPackage + "." + bizFunc + "-" + bizOper;
            if (this.set.contains(key)) continue;
            this.set.add(key);
        }
    }

    public boolean contains(String bizPackage, String bizFunc, String bizOper) {
        String key = bizPackage + "." + bizFunc + "-" + bizOper;
        return this.set.contains(key);
    }

    public boolean contains(String funcFullName, String bizOper) {
        String key = funcFullName + "-" + bizOper;
        return this.set.contains(key);
    }

    public boolean add(String bizPackage, String bizFunc, String bizOper) {
        String key = bizPackage + "." + bizFunc + "-" + bizOper;
        if (!this.set.contains(key)) {
            this.set.add(key);
            return true;
        }
        return false;
    }

    public boolean add(String funcFullName, String bizOper) {
        String key = funcFullName + "-" + bizOper;
        if (!this.set.contains(key)) {
            this.set.add(key);
            return true;
        }
        return false;
    }

    public Set getOperations() {
        return this.set;
    }
}

