/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ITaskServiceActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WSOperationDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class AbstractTaskServiceActivityDef
extends ActivityDef
implements ITaskServiceActivityDef {
    private static final long serialVersionUID = -2489713416424065095L;
    protected String applicationId = "";
    protected String partnerLinkName = "";
    protected ActualParameterCollection actualParameters = new ActualParameterCollection(this);

    public AbstractTaskServiceActivityDef() {
        this.setType(ActivityType.TASK_SERVICE);
    }

    public AbstractTaskServiceActivityDef(ProcessDef process) {
        super(process);
        this.setType(ActivityType.TASK_SERVICE);
    }

    public AbstractTaskServiceActivityDef(ProcessDef processDef, Element destElement) throws WfKpdlParseException {
        super(processDef, destElement);
        this.setType(ActivityType.TASK_SERVICE);
        this.innerParse(destElement);
    }

    @Override
    public ActualParameterCollection getActualParameters() {
        return this.actualParameters;
    }

    @Override
    public ApplicationDef getRelatedApplication() {
        return this.container().getApplicationDef(this.applicationId);
    }

    public void setRelatedApplication(ApplicationDef relatedApplication) throws WfException {
        this.container().getApplications().set(relatedApplication.getID(), relatedApplication);
        this.applicationId = relatedApplication.getID();
    }

    public ApplicationDef getRedoApplication() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element toElement() {
        Element element = super.toElement();
        element.setAttribute("ApplicationId", this.applicationId);
        element.setAttribute("PartnerLinkName", this.partnerLinkName);
        element.addContent((Content)this.actualParameters.toElement());
        return element;
    }

    @Override
    public IKpdlElement innerParse(Element destElement) throws WfKpdlParseException {
        super.innerParse(destElement);
        Element actualParametersElement = destElement.getChild("ActualParameters", DefinitionConstants.NS_INSTANCE_KPDL);
        if (actualParametersElement != null) {
            this.actualParameters = new ActualParameterCollection(this, actualParametersElement);
        }
        this.applicationId = XmlUtil.readStringAttr(destElement, "ApplicationId");
        this.partnerLinkName = XmlUtil.readStringAttr(destElement, "PartnerLinkName");
        return this;
    }

    public void setActualParameters(ActualParameterCollection collection) {
        this.actualParameters = collection;
    }

    public ActualParameterCollection getRedoActualParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProcessDef getProcessDef() {
        return (ProcessDef)this.getContainer();
    }

    @Override
    public String getPartnerLinkName() {
        return this.partnerLinkName;
    }

    public void setPartnerLinkName(String partnerLinkName) {
        this.partnerLinkName = partnerLinkName;
    }

    @Override
    public WSOperationDef getWSOperationDef() {
        return this.getRelatedApplication().getWSOperationDef();
    }

    public ActivityDef getActivityDef() {
        return this;
    }
}

