/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityHeaderDef;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.ExecutionObjectType;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.IExecuteObject;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.KpdlResourceUtils;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.define.diagram.ActivityNode;
import com.kingdee.bos.workflow.define.diagram.Diagram;
import com.kingdee.bos.workflow.define.diagram.NodeCollection;
import com.kingdee.bos.workflow.define.diagram.NodeMode;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.bos.workflow.wfdesigner.WfBizType;
import com.kingdee.util.Uuid;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class ActivityDef
extends AbstractKpdlElement
implements IExecuteObject {
    public static final String EXT_IS_APPENDED = "isAppended";
    private static final long serialVersionUID = 515951303884357262L;
    private static final String BOSTYPE = "WFACTDEF";
    private static final String typeBundle = ActivityDef.class.getName();
    protected ActivityHeaderDef activityHeader;
    protected String id = Uuid.create().toString() + "WFACTDEF";
    protected static final String ACTIVITY_NAME = KpdlResourceUtils.ACTIVITY_NAME.getName();
    protected ActivityType type;
    private String startTransactionBlock;
    protected TransitionCollection incomingTransitions;
    protected TransitionCollection outgoningTransitions;
    protected ActivityCollection postActivities;
    protected ActivityCollection previousActivities;
    protected ActivityCollection allPostActivities;
    protected ActivityCollection allPreviousActivities;
    protected ActivityNode relatedNode;
    protected WfBizType bizType;

    public abstract String getIconResource(String var1);

    public abstract String getIconResource();

    public final String getTypeName(Locale l) {
        String typeResource = this.getTypeResource();
        return ResourceBundle.getBundle(typeBundle, l).getString(typeResource);
    }

    protected abstract String getTypeResource();

    public void cleasOutgoningTransitions() {
        this.outgoningTransitions = null;
    }

    public WfBizType getBizType() {
        return this.bizType;
    }

    public void setBizType(WfBizType type) throws WfException {
        this.bizType = type;
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    protected ActivityDef() {
        try {
            this.setName(new Resource(ACTIVITY_NAME, this.id, "Activity"));
        }
        catch (WfException e) {
            log.error((Object)"init ActivityDef error", (Throwable)((Object)e));
        }
        this.activityHeader = new ActivityHeaderDef(this);
        this.relatedNode = null;
    }

    protected ActivityDef(ProcessDef process) {
        this();
        this.setContainer(process);
    }

    protected ActivityDef(ProcessDef containedProcessDef, Element destActivityDefElement) throws WfKpdlParseException {
        this(containedProcessDef);
        this.parse(destActivityDefElement);
    }

    protected final ProcessDef container() {
        return (ProcessDef)this.container;
    }

    @Override
    public ExecutionObjectType getExecuteObjectType() {
        return ExecutionObjectType.ACTIVITY;
    }

    protected final void parseActivityHeader(Element destActivityHeaderElement) throws WfKpdlParseException {
        this.activityHeader.parse(destActivityHeaderElement);
    }

    protected final Element toActivityHeaderElement() {
        return this.activityHeader.toElement();
    }

    public ActivityHeaderDef getActivityHeader() {
        return this.activityHeader == null ? new ActivityHeaderDef(this) : this.activityHeader;
    }

    public void setActivityHeader(ActivityHeaderDef def) {
        if (def == null) {
            throw new IllegalArgumentException();
        }
        this.activityHeader = def;
    }

    @Override
    public void setContainer(AbstractKpdlElement destContainer) {
        if (destContainer == null) {
            throw new IllegalArgumentException();
        }
        super.setContainer(destContainer);
        this.container = (ProcessDef)destContainer;
    }

    public int outDegree() throws WfException {
        if (this.container == null) {
            throw new WfException("Container is null");
        }
        Iterator iterator = this.container().getTransitions().iterator();
        int degree = 0;
        while (iterator.hasNext()) {
            TransitionDef transition = (TransitionDef)iterator.next();
            if (!transition.getFrom().getID().equals(this.id)) continue;
            ++degree;
        }
        return degree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransitionCollection getIncomingTransitions() throws WfException {
        if (this.container == null) {
            throw new WfException("Container is null");
        }
        if (!this.isReadOnly() || this.incomingTransitions == null) {
            ActivityDef activityDef = this;
            synchronized (activityDef) {
                if (this.incomingTransitions == null) {
                    this.incomingTransitions = new TransitionCollection(this.container());
                    if (this.container == null || this.container().getTransitions() == null) {
                        return this.incomingTransitions;
                    }
                    for (int i = 0; i < this.container().getTransitions().size(); ++i) {
                        TransitionDef transition = this.container().getTransitions().get(i);
                        if (transition == null || transition.getTo() == null || !transition.getTo().getID().equals(this.id) || this.incomingTransitions.containsKey(transition.getID())) continue;
                        this.incomingTransitions.add(transition.getID(), transition);
                    }
                }
            }
        }
        return this.incomingTransitions;
    }

    public int inDegree() throws WfException {
        if (this.getContainer() == null) {
            throw new WfException("Container is null!");
        }
        Iterator iterator = this.container().getTransitions().iterator();
        int degree = 0;
        while (iterator.hasNext()) {
            TransitionDef transition = (TransitionDef)iterator.next();
            if (!transition.getTo().getID().equals(this.id)) continue;
            ++degree;
        }
        return degree;
    }

    public synchronized TransitionCollection getOutgoingTransitions() throws WfException {
        if (this.getContainer() == null) {
            throw new WfException("Container is null!");
        }
        if (!this.isReadOnly() || this.outgoningTransitions == null) {
            if (this.container == null || this.container().getTransitions() == null) {
                return new TransitionCollection(this.container());
            }
            this.getOutgoningTransInternal();
        }
        return this.outgoningTransitions;
    }

    private synchronized void getOutgoningTransInternal() {
        if (this.outgoningTransitions == null) {
            this.outgoningTransitions = new TransitionCollection(this.container());
            for (int i = 0; i < this.container().getTransitions().size(); ++i) {
                TransitionDef transition = this.container().getTransitions().get(i);
                if (transition == null || transition.getFrom() == null || !transition.getFrom().getID().equals(this.id) || this.outgoningTransitions.containsKey(transition.getID())) continue;
                this.outgoningTransitions.add(transition.getID(), transition);
            }
        }
    }

    public TransitionCollection refreshOutgoingTransitions() throws WfException {
        if (this.getContainer() == null) {
            throw new WfException("Container is null!");
        }
        TransitionCollection transitions = new TransitionCollection(this.container());
        if (!this.isReadOnly()) {
            for (int i = 0; i < this.container().getTransitions().size(); ++i) {
                TransitionDef transition = this.container().getTransitions().get(i);
                if (transition == null || transition.getFrom() == null || !transition.getFrom().getID().equals(this.id) || transitions.containsKey(transition.getID())) continue;
                transitions.add(transition.getID(), transition);
            }
        }
        return transitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityCollection getPreviousActivities() throws WfException {
        if (!this.isReadOnly() || this.previousActivities == null) {
            ActivityDef activityDef = this;
            synchronized (activityDef) {
                if (this.previousActivities == null) {
                    TransitionCollection trans = this.getIncomingTransitions();
                    this.previousActivities = new ActivityCollection(this.container);
                    for (int i = 0; i < trans.size(); ++i) {
                        TransitionDef transition = trans.get(i);
                        if (transition == null || transition.getFrom() == null || transition.getFrom().getID().equals(this.getID())) continue;
                        this.previousActivities.set(transition.getFrom().getID(), transition.getFrom());
                    }
                }
            }
        }
        return this.previousActivities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityCollection getAllPreviousActivities() throws WfException {
        if (this.container == null) {
            throw new WfException("activity container null!");
        }
        if (!this.isReadOnly() || this.allPreviousActivities == null) {
            ActivityDef activityDef = this;
            synchronized (activityDef) {
                if (this.allPreviousActivities == null) {
                    this.allPreviousActivities = (ActivityCollection)this.getPreviousActivities().clone();
                    for (int i = 0; i < this.allPreviousActivities.size(); ++i) {
                        if (this.allPreviousActivities.get(i).getID().equals(this.getID()) || this.allPreviousActivities.get(i) instanceof StartActivityDef) continue;
                        ActivityCollection destPreActivities = this.allPreviousActivities.get(i).getAllPreviousActivities();
                        for (int j = 0; j < destPreActivities.size(); ++j) {
                            if (destPreActivities.get(j) == null || destPreActivities.get(j).getID() == null || this.allPreviousActivities.containsKey(destPreActivities.get(j).getID()) || destPreActivities.get(j).getID().equals(this.getID())) continue;
                            this.allPreviousActivities.set(destPreActivities.get(j).getID(), destPreActivities.get(j));
                        }
                    }
                }
            }
        }
        return this.allPreviousActivities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityCollection getAllPostActivities() throws WfException {
        if (!this.isReadOnly() || this.allPostActivities == null) {
            ActivityDef activityDef = this;
            synchronized (activityDef) {
                if (this.allPostActivities == null) {
                    this.allPostActivities = (ActivityCollection)this.getPostActivities().clone();
                    for (int i = 0; i < this.allPostActivities.size(); ++i) {
                        if (this.allPostActivities.get(i).getID().equals(this.getID()) || this.allPostActivities.get(i) instanceof EndActivityDef) continue;
                        ActivityCollection destPostActivities = this.allPostActivities.get(i).getAllPostActivities();
                        for (int j = 0; j < destPostActivities.size(); ++j) {
                            if (destPostActivities.get(j) == null || destPostActivities.get(j).getID() == null || this.allPostActivities.containsKey(destPostActivities.get(j).getID()) || destPostActivities.get(j).getID().equals(this.getID())) continue;
                            this.allPostActivities.set(destPostActivities.get(j).getID(), destPostActivities.get(j));
                        }
                    }
                }
            }
        }
        return this.allPostActivities;
    }

    public String getName() {
        return this.getName(this.getLocale());
    }

    public String getName(Locale locale) {
        if (this.getNameResource() == null) {
            return null;
        }
        return this.getNameResource().getValue(locale);
    }

    public String getStartTransactionBlock() {
        return this.startTransactionBlock;
    }

    public void setStartTransactionBlock(String value) {
        this.startTransactionBlock = value;
    }

    public Resource getNameResource() {
        return this.resources.get(ACTIVITY_NAME + this.id);
    }

    public void setName(String string) throws WfException {
        this.setName(this.getLocale(), string);
    }

    public void setName(Locale locale, String string) throws WfException {
        if (this.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.getNameResource() == null) {
            this.setName(new Resource(ACTIVITY_NAME, this.id, locale, string));
        } else {
            this.getNameResource().setValue(locale, string);
        }
    }

    public void setName(Resource destName) throws WfException {
        if (this.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(ACTIVITY_NAME + this.id, destName);
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setID(String destId) {
        if (destId == null || destId.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.resources.updateResourceId(this.getNameResource(), destId);
        this.resources.updateResourceId(this.getActivityHeader().getDescriptionResource(), destId);
        this.id = destId;
    }

    public ActivityType getType() {
        return this.type;
    }

    public void setType(ActivityType destType) {
        this.type = destType;
    }

    public synchronized ActivityCollection getPostActivities() throws WfException {
        if (this.postActivities == null) {
            this.postActivities = new ActivityCollection(this.container);
            TransitionDef transitionDef = null;
            if (this.getOutgoingTransitions() != null) {
                Iterator iterator = this.getOutgoingTransitions().iterator();
                while (iterator.hasNext()) {
                    transitionDef = (TransitionDef)iterator.next();
                    if (transitionDef == null || transitionDef.getTo() == null || transitionDef.getTo().getID().equals(this.getID())) continue;
                    this.postActivities.set(transitionDef.getTo().getID(), transitionDef.getTo());
                }
            }
        }
        return this.postActivities;
    }

    public int check() {
        return 0;
    }

    public String toString() {
        StringBuffer activityDefStr = new StringBuffer();
        activityDefStr.append(super.toString());
        activityDefStr.append(":[");
        activityDefStr.append("id=").append(this.id).append(";");
        activityDefStr.append("name=").append(this.getNameResource()).append(";");
        activityDefStr.append(this.activityHeader.toString());
        activityDefStr.append("]");
        return activityDefStr.toString();
    }

    @Override
    public Element toElement() {
        Element resourcesElement;
        Element activityHeaderElement;
        Element activityElement = new Element("Activity", DefinitionConstants.NS_INSTANCE_KPDL);
        activityElement.setAttribute("Id", this.id);
        activityElement.setAttribute("Name", ACTIVITY_NAME);
        if (this.bizType != null) {
            Element bizTypeElement = new Element("BizType", DefinitionConstants.NS_INSTANCE_KPDL);
            bizTypeElement.setAttribute("id", this.bizType.getId().toString());
            bizTypeElement.setAttribute("name", this.bizType.getName());
            bizTypeElement.setAttribute("number", this.bizType.getNumber());
            activityElement.addContent((Content)bizTypeElement);
        }
        if ((activityHeaderElement = this.toActivityHeaderElement()) != null) {
            activityElement.addContent((Content)activityHeaderElement);
        }
        if ((resourcesElement = this.resources.toElement()) != null) {
            activityElement.addContent((Content)resourcesElement);
        }
        if (this.startTransactionBlock != null) {
            activityElement.setAttribute("StartTransaction", this.startTransactionBlock);
        }
        return activityElement;
    }

    public ActivityNode getRelatedNode() throws WfException {
        if (this.getContainer() == null) {
            throw new WfException("Container is null!");
        }
        Diagram diagram = this.container().getDiagram();
        if (this.relatedNode == null && this.container != null && diagram != null && diagram.getNodes() != null) {
            NodeCollection nodes = diagram.getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                ActivityNode node;
                if (!nodes.get(i).getMode().equals((Object)NodeMode.ACTIVITYNODE) || (node = (ActivityNode)nodes.get(i)).getRefActivity() == null || !node.getRefActivity().getID().equals(this.id)) continue;
                this.relatedNode = node;
            }
        }
        return this.relatedNode;
    }

    @Override
    protected IKpdlElement innerParse(Element destActivityDefElement) throws WfKpdlParseException {
        Element resourcesElement;
        Element bizTypeElement;
        if (destActivityDefElement == null) {
            throw new IllegalArgumentException();
        }
        this.id = XmlUtil.readStringAttr(destActivityDefElement, "Id");
        Element activityHeaderElement = destActivityDefElement.getChild("ActivityHeader", DefinitionConstants.NS_INSTANCE_KPDL);
        if (activityHeaderElement != null) {
            this.parseActivityHeader(activityHeaderElement);
        }
        if ((bizTypeElement = destActivityDefElement.getChild("BizType", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.bizType = new WfBizType();
            this.bizType.setId(bizTypeElement.getAttributeValue("id"));
            this.bizType.setName(bizTypeElement.getAttributeValue("name"));
            this.bizType.setNumber(bizTypeElement.getAttributeValue("number"));
        }
        if ((resourcesElement = destActivityDefElement.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.resources = new ResourceCollection(this, resourcesElement);
        }
        return this;
    }

    public void initialApplication() throws WfException {
    }

    public boolean isAppended() {
        ExtendedAttributeDef ead = this.getActivityHeader().getExtendedAttributes().get(EXT_IS_APPENDED);
        if (ead == null) {
            return false;
        }
        return "true".equals(ead.getValue());
    }

    public String getActDigest() {
        return this.getActDigest(new Locale("l2"));
    }

    public String getActDigest(Locale l) {
        StringBuffer sb = new StringBuffer();
        if (l.equals(new Locale("l1"))) {
            sb.append("enter model\uff1a").append((Object)this.activityHeader.getJoinType());
            sb.append("\r\n export model\uff1a").append((Object)this.activityHeader.getSplitType());
            sb.append("\r\n Extended Attributes\uff1a");
        } else if (l.equals(new Locale("l2"))) {
            sb.append("\u5165\u53e3\u6a21\u5f0f\uff1a").append((Object)this.activityHeader.getJoinType());
            sb.append("\r\n\u51fa\u53e3\u6a21\u5f0f\uff1a").append((Object)this.activityHeader.getSplitType());
            sb.append("\r\n\u6269\u5c55\u5c5e\u6027\uff1a");
        } else {
            sb.append("\u5165\u53e3\u6a21\u5f0f\uff1a").append((Object)this.activityHeader.getJoinType());
            sb.append("\r\n\u51fa\u53e3\u6a21\u5f0f\uff1a").append((Object)this.activityHeader.getSplitType());
            sb.append("\r\n\u64f4\u5c55\u5c6c\u6027\uff1a");
        }
        ExtendedAttributeCollection eac = this.activityHeader.getExtendedAttributes();
        for (int i = 0; i < eac.size(); ++i) {
            ExtendedAttributeDef ead = (ExtendedAttributeDef)eac.getObject(i);
            sb.append(ead.getName()).append("=").append(ead.getValue()).append(";");
        }
        return sb.toString();
    }

    public ActivityDef deepClone(ActivityDef info) {
        info = (ActivityDef)super.deepClone(info);
        ActivityDef dc = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(info);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream bis = new ObjectInputStream(bais);
            dc = (ActivityDef)bis.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return dc;
    }
}

