/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.AutomationMode;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.JoinType;
import com.kingdee.bos.workflow.define.KpdlResourceUtils;
import com.kingdee.bos.workflow.define.LimitDef;
import com.kingdee.bos.workflow.define.PostConditionDef;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScriptDef;
import com.kingdee.bos.workflow.define.SplitType;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.define.diagram.Coordinate;
import com.kingdee.bos.workflow.util.XmlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public class ActivityHeaderDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -9096088198735715015L;
    private boolean isRollback = false;
    private static final String DESCRIPTION = KpdlResourceUtils.ACTIVITYHEADER_DESCRIPTION.getName();
    private String icon;
    private String document;
    private SplitType split;
    private JoinType join;
    private AutomationMode startMode;
    private AutomationMode finishMode;
    private int priority;
    private Coordinate coordinate;
    private LimitDef limit;
    private PostConditionDef postCondition;
    private ScriptDef postScript;
    private List transitionRefs;
    private ScheduleDef scheduale;
    private ExtendedAttributeCollection extendedAttributes;

    protected final ActivityDef container() {
        return (ActivityDef)this.container;
    }

    public String getDocument() {
        return this.document;
    }

    public void setDocument(String destDocument) {
        if (destDocument == null) {
            throw new IllegalArgumentException();
        }
        this.document = destDocument;
    }

    public String getDescription() {
        if (this.container == null || this.container.getContainer() == null) {
            return null;
        }
        return this.getDescription(this.container.getContainer().getLocale());
    }

    public Resource getDescriptionResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(DESCRIPTION + this.container().id);
    }

    public String getDescription(Locale locale) {
        if (this.getDescriptionResource() == null) {
            return null;
        }
        return this.getDescriptionResource().getValue(locale);
    }

    public void setDescription(String string) throws WfException {
        this.setDescription(this.container.getContainer().getLocale(), string);
    }

    public void setDescription(Locale locale, String string) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.getDescriptionResource() == null) {
            this.setDescription(new Resource(DESCRIPTION, this.container().id, locale, string));
        } else {
            this.getDescriptionResource().setValue(locale, string);
        }
    }

    public void setDescription(Resource destDescription) throws WfException {
        if (this.container.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(DESCRIPTION + this.container().id, destDescription);
    }

    public AutomationMode getStartMode() {
        return this.startMode;
    }

    public void setStartMode(AutomationMode startMode) {
        this.startMode = startMode;
    }

    public AutomationMode getFinishMode() {
        return this.finishMode;
    }

    public void setFinishMode(AutomationMode finishMode) {
        this.finishMode = finishMode;
    }

    public SplitType getSplitType() {
        return this.split;
    }

    public void setSplitType(SplitType splitType) {
        this.split = splitType;
    }

    public JoinType getJoinType() {
        return this.join;
    }

    public void setJoinType(JoinType joinType) {
        this.join = joinType;
    }

    public List getTransitionRefs() {
        return this.transitionRefs;
    }

    public void setTransitionRefs(List transitions) {
        this.transitionRefs = transitions;
    }

    public void addTransitionRef(String id) {
        this.transitionRefs.add(id);
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String destIcon) {
        if (destIcon == null || destIcon.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.icon = destIcon;
    }

    public int getpriority() {
        return this.priority;
    }

    public void setpriority(int destPriority) {
        this.priority = destPriority;
    }

    public LimitDef getLimit() {
        return this.limit;
    }

    public void setLimit(LimitDef destLimit) {
        if (destLimit == null) {
            throw new IllegalArgumentException();
        }
        this.limit = destLimit;
    }

    public ScheduleDef getScheduale() {
        return this.scheduale;
    }

    public void setScheduale(ScheduleDef def) {
        this.scheduale = def;
    }

    public boolean isRollback() {
        return this.isRollback;
    }

    public void setRollback(boolean b) {
        this.isRollback = b;
    }

    public PostConditionDef getPostCondition() {
        return this.postCondition;
    }

    public void setPostCondition(PostConditionDef destPostCondition) {
        if (destPostCondition == null) {
            throw new IllegalArgumentException();
        }
        this.postCondition = destPostCondition;
    }

    public ScriptDef getPostScript() {
        return this.postScript;
    }

    public void setPostScript(ScriptDef destPostScript) {
        this.postScript = destPostScript;
    }

    public ExtendedAttributeCollection getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(ExtendedAttributeCollection destExtendedAttributes) {
        if (destExtendedAttributes == null) {
            throw new IllegalArgumentException();
        }
        this.extendedAttributes = destExtendedAttributes;
    }

    public ActivityHeaderDef(ActivityDef activity) {
        this.setContainer(activity);
        if (this.container != null && this.container.getContainer() != null && this.getDescriptionResource() == null) {
            try {
                this.setDescription("");
            }
            catch (WfException e) {
                log.error((Object)"Init ActivityHeaderDef error", (Throwable)((Object)e));
            }
        }
        this.icon = "";
        this.document = "";
        this.split = SplitType.XOR;
        this.join = JoinType.XOR;
        this.startMode = AutomationMode.AUTOMATIC;
        this.finishMode = AutomationMode.AUTOMATIC;
        this.priority = 0;
        this.coordinate = new Coordinate();
        this.limit = new LimitDef();
        this.postCondition = new PostConditionDef();
        this.postScript = new ScriptDef();
        this.transitionRefs = new ArrayList();
        this.scheduale = this.container != null ? new ScheduleDef(this.container.container) : new ScheduleDef(null);
        this.extendedAttributes = new ExtendedAttributeCollection();
    }

    @Override
    public Element toElement() {
        Element activityHeaderElement = new Element("ActivityHeader", DefinitionConstants.NS_INSTANCE_KPDL);
        Element descriptionElement = new Element("Description", DefinitionConstants.NS_INSTANCE_KPDL);
        descriptionElement.setText(DESCRIPTION);
        activityHeaderElement.addContent((Content)descriptionElement);
        Element iconElement = new Element("Icon", DefinitionConstants.NS_INSTANCE_KPDL);
        iconElement.setText(this.icon);
        activityHeaderElement.addContent((Content)iconElement);
        Element documentationElement = new Element("Documentation", DefinitionConstants.NS_INSTANCE_KPDL);
        documentationElement.setText(this.document);
        activityHeaderElement.addContent((Content)documentationElement);
        Element joinElement = new Element("Join", DefinitionConstants.NS_INSTANCE_KPDL);
        joinElement.setAttribute("Type", this.join.getName());
        activityHeaderElement.addContent((Content)joinElement);
        Element splitElement = new Element("Split", DefinitionConstants.NS_INSTANCE_KPDL);
        splitElement.setAttribute("Type", this.split.getName());
        activityHeaderElement.addContent((Content)splitElement);
        if (this.split == SplitType.XOR) {
            Element transitionRefsElement = this.toTransitionRefsElement();
            if (transitionRefsElement != null) {
                activityHeaderElement.addContent((Content)transitionRefsElement);
            }
        } else {
            activityHeaderElement.addContent((Content)new Element("TransitionRefs", DefinitionConstants.NS_INSTANCE_KPDL));
        }
        Element startModeElement = new Element("StartMode", DefinitionConstants.NS_INSTANCE_KPDL);
        startModeElement.setText(this.startMode.getName());
        activityHeaderElement.addContent((Content)startModeElement);
        Element finishModeElement = new Element("FinishMode", DefinitionConstants.NS_INSTANCE_KPDL);
        finishModeElement.setText(this.finishMode.getName());
        activityHeaderElement.addContent((Content)finishModeElement);
        Element priorityElement = new Element("Priority", DefinitionConstants.NS_INSTANCE_KPDL);
        priorityElement.setText(String.valueOf(this.priority));
        activityHeaderElement.addContent((Content)priorityElement);
        if (this.limit != null) {
            activityHeaderElement.addContent((Content)this.limit.toElement());
        }
        if (this.postCondition != null) {
            activityHeaderElement.addContent((Content)this.postCondition.toElement());
        }
        if (this.postScript != null) {
            Element tempPostScriptElement = new Element("PostScript", DefinitionConstants.NS_INSTANCE_KPDL);
            tempPostScriptElement.addContent((Content)this.postScript.toElement());
            activityHeaderElement.addContent((Content)tempPostScriptElement);
        }
        if (this.coordinate != null) {
            activityHeaderElement.addContent((Content)this.coordinate.toElement());
        }
        if (this.scheduale != null) {
            activityHeaderElement.addContent((Content)this.scheduale.toElement());
        }
        if (this.extendedAttributes != null && this.extendedAttributes.size() > 0) {
            activityHeaderElement.addContent((Content)this.extendedAttributes.toElement());
        } else {
            activityHeaderElement.addContent((Content)new Element("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL));
        }
        activityHeaderElement.setAttribute("IsRollback", String.valueOf(this.isRollback));
        if (this.resources != null) {
            activityHeaderElement.addContent((Content)this.resources.toElement());
        }
        return activityHeaderElement;
    }

    private void parseTransitionRefs(Element destTransitionRefsElement) {
        if (destTransitionRefsElement == null) {
            throw new IllegalArgumentException();
        }
        List transitionRefElementList = destTransitionRefsElement.getChildren("TransitionRef", DefinitionConstants.NS_INSTANCE_KPDL);
        if (transitionRefElementList != null) {
            Element transitionRefElement = null;
            for (int i = 0; i < transitionRefElementList.size(); ++i) {
                transitionRefElement = (Element)transitionRefElementList.get(i);
                this.transitionRefs.add(transitionRefElement.getAttributeValue("Id"));
            }
            assert (this.transitionRefs instanceof ArrayList);
            ((ArrayList)this.transitionRefs).trimToSize();
        }
    }

    private Element toTransitionRefsElement() {
        Element transitionRefsElement = new Element("TransitionRefs", DefinitionConstants.NS_INSTANCE_KPDL);
        if (this.transitionRefs != null && this.transitionRefs.size() > 0) {
            Iterator transitionRefsIterator = this.transitionRefs.iterator();
            while (transitionRefsIterator.hasNext()) {
                Element tempTransitionRefElement = new Element("TransitionRef", DefinitionConstants.NS_INSTANCE_KPDL);
                tempTransitionRefElement.setAttribute("Id", (String)transitionRefsIterator.next());
                transitionRefsElement.addContent((Content)tempTransitionRefElement);
            }
        }
        return transitionRefsElement;
    }

    public String toString() {
        String activityDefStr = "";
        activityDefStr = activityDefStr + "description=" + DESCRIPTION + ";";
        activityDefStr = activityDefStr + "icon=" + this.icon + ";";
        activityDefStr = activityDefStr + "document=" + this.document + ";";
        activityDefStr = activityDefStr + "split=" + this.split.getName() + ";";
        activityDefStr = activityDefStr + "join=" + this.join.getName() + ";";
        activityDefStr = activityDefStr + "startMode=" + this.startMode.getName() + ";";
        activityDefStr = activityDefStr + "finishMode=" + this.finishMode.getName() + ";";
        activityDefStr = activityDefStr + "priority=" + this.priority + ";";
        return activityDefStr;
    }

    @Override
    public String getID() {
        return this.container.getID();
    }

    @Override
    public void setContainer(AbstractKpdlElement element) {
        super.setContainer(element);
        this.container = (ActivityDef)element;
    }

    @Override
    public String bosType() {
        return null;
    }

    @Override
    protected IKpdlElement innerParse(Element destActivityHeaderElement) throws WfKpdlParseException {
        Element resourcesElement;
        Element extendedAttrListElem;
        Element schedualeElement;
        Element coordinateElement;
        Element scriptElement;
        Element postScriptElement;
        Element postConditionElement;
        Element transitionRefsElement;
        if (destActivityHeaderElement == null) {
            throw new IllegalArgumentException();
        }
        this.isRollback = Boolean.valueOf(destActivityHeaderElement.getAttributeValue("IsRollback"));
        this.icon = XmlUtil.readString(destActivityHeaderElement, "Icon", DefinitionConstants.NS_INSTANCE_KPDL);
        this.document = XmlUtil.readString(destActivityHeaderElement, "Documentation", DefinitionConstants.NS_INSTANCE_KPDL);
        String joinTypeStr = XmlUtil.readStringSubAttr(destActivityHeaderElement, "Join", "Type", DefinitionConstants.NS_INSTANCE_KPDL);
        this.join = JoinType.getEnum(joinTypeStr);
        String splitTypeStr = XmlUtil.readStringSubAttr(destActivityHeaderElement, "Split", "Type", DefinitionConstants.NS_INSTANCE_KPDL);
        this.split = SplitType.getEnum(splitTypeStr);
        if (this.split == SplitType.XOR && (transitionRefsElement = destActivityHeaderElement.getChild("TransitionRefs", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.parseTransitionRefs(transitionRefsElement);
        }
        String startModeStr = XmlUtil.readString(destActivityHeaderElement, "StartMode", DefinitionConstants.NS_INSTANCE_KPDL);
        this.startMode = AutomationMode.getEnum(startModeStr);
        String finishModeStr = XmlUtil.readString(destActivityHeaderElement, "FinishMode", DefinitionConstants.NS_INSTANCE_KPDL);
        this.finishMode = AutomationMode.getEnum(finishModeStr);
        this.priority = XmlUtil.readInt(destActivityHeaderElement, "Priority", DefinitionConstants.NS_INSTANCE_KPDL);
        Element limitElement = destActivityHeaderElement.getChild("Limit", DefinitionConstants.NS_INSTANCE_KPDL);
        if (limitElement != null) {
            this.limit = new LimitDef(limitElement);
        }
        if ((postConditionElement = destActivityHeaderElement.getChild("PostCondition", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.postCondition = new PostConditionDef(postConditionElement);
        }
        if ((postScriptElement = destActivityHeaderElement.getChild("PostScript", DefinitionConstants.NS_INSTANCE_KPDL)) != null && (scriptElement = postScriptElement.getChild("Script", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.postScript = new ScriptDef(scriptElement);
        }
        if ((coordinateElement = destActivityHeaderElement.getChild("Coordinate", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.coordinate = new Coordinate(coordinateElement);
        }
        if ((schedualeElement = destActivityHeaderElement.getChild("Scheduale", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.scheduale = new ScheduleDef(this.container.container, schedualeElement);
        }
        if ((extendedAttrListElem = destActivityHeaderElement.getChild("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.extendedAttributes = new ExtendedAttributeCollection(extendedAttrListElem);
        }
        if ((resourcesElement = destActivityHeaderElement.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.resources = new ResourceCollection(this, resourcesElement);
        }
        return this;
    }
}

