/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.ApplicationType;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExternalClassDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.JavaMethodDef;
import com.kingdee.bos.workflow.define.KpdlResourceUtils;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.ScriptDef;
import com.kingdee.bos.workflow.define.WSOperationDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.Uuid;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public class ApplicationDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -2584083622589588546L;
    private static final String BOSTYPE = "WFAPPDEF";
    private static final String DESCRIPTION = KpdlResourceUtils.APPLICATION_DESCRIPTION.getName();
    private FormalParameterCollection formalParameters;
    private ExtendedAttributeCollection extendedAttributes;
    private String id;
    private static final String NAME = KpdlResourceUtils.APPLICATION_NAME.getName();
    private String content;
    private ApplicationType applicationType;
    private FunctionDef function;
    private WSOperationDef wsOperationDef;
    private ScriptDef script;
    private ExternalClassDef externalClass;
    private JavaMethodDef methodDef;

    public ApplicationDef(ProcessDef container) {
        block5: {
            this.setContainer(container);
            this.formalParameters = new FormalParameterCollection(container);
            this.extendedAttributes = new ExtendedAttributeCollection();
            this.id = Uuid.create().toString() + BOSTYPE;
            this.applicationType = ApplicationType.MANPOWER;
            if (this.container != null) {
                try {
                    if (this.getDescriptionResource() == null) {
                        this.setDescription(new Resource(DESCRIPTION, this.id));
                    }
                    if (this.getNameResource() == null) {
                        this.setName(new Resource(NAME, this.id, "Application"));
                    }
                }
                catch (WfException e) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)"ApplicationDef.new() error", (Throwable)((Object)e));
                }
            }
        }
    }

    public ApplicationDef(ProcessDef container, Element destApplicationDefElement) throws WfKpdlParseException {
        this(container);
        this.parse(destApplicationDefElement);
    }

    public ApplicationDef(ProcessDef process, String name, String id, ApplicationType type, String desc, String content) {
        this(process);
        try {
            this.setName(name);
            this.setDescription(desc);
        }
        catch (WfException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
        }
        this.id = id;
        this.applicationType = type;
    }

    public String getDescription() {
        return this.getDescription(this.container.getLocale());
    }

    public Resource getDescriptionResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(DESCRIPTION + this.id);
    }

    public String getDescription(Locale locale) {
        if (this.getDescriptionResource() == null) {
            return null;
        }
        return this.getDescriptionResource().getValue(locale);
    }

    public void setDescription(String destDescription) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.setDescription(this.container.getLocale(), destDescription);
    }

    public void setDescription(Locale locale, String destDescription) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destDescription == null) {
            throw new IllegalArgumentException();
        }
        if (this.getDescriptionResource() == null) {
            this.setDescription(new Resource(DESCRIPTION, this.id, locale, destDescription));
        } else {
            this.getDescriptionResource().setValue(locale, destDescription);
        }
    }

    public void setDescription(Resource destDescription) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(DESCRIPTION + this.id, destDescription);
    }

    public FormalParameterCollection getFormalParameters() {
        return this.formalParameters;
    }

    public void setFormalParameters(FormalParameterCollection destFormalParameters) {
        this.formalParameters = destFormalParameters;
    }

    public ExtendedAttributeCollection getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(ExtendedAttributeCollection destExtendedAttributes) {
        this.extendedAttributes = destExtendedAttributes;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setID(String destId) {
        this.resources.updateResourceId(this.getDescriptionResource(), destId);
        this.resources.updateResourceId(this.getNameResource(), destId);
        this.id = destId;
    }

    public String getName() {
        return this.getName(this.container.getLocale());
    }

    public Resource getNameResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(NAME + this.id);
    }

    public String getName(Locale locale) {
        if (this.getNameResource() == null) {
            return null;
        }
        return this.getNameResource().getValue(locale);
    }

    public void setName(String destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.setName(this.container.getLocale(), destName);
    }

    public void setName(Locale locale, String destName) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destName == null) {
            throw new IllegalArgumentException();
        }
        if (this.getNameResource() == null) {
            this.setName(new Resource(NAME, this.id, locale, destName));
        } else {
            this.getNameResource().setValue(locale, destName);
        }
    }

    public void setName(Resource destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(NAME + this.id, destName);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String destContent) {
        this.content = destContent;
    }

    public ApplicationType getType() {
        return this.applicationType;
    }

    public void setType(ApplicationType type) {
        this.applicationType = type;
    }

    public ExternalClassDef getExternalClass() {
        return this.externalClass;
    }

    public FunctionDef getFunction() {
        return this.function;
    }

    public ScriptDef getScript() {
        return this.script;
    }

    public void setExternalClass(ExternalClassDef def) {
        this.externalClass = def;
    }

    public void setFunction(FunctionDef def) {
        this.function = def;
    }

    public void setScript(ScriptDef def) {
        this.script = def;
    }

    public int check() {
        return 0;
    }

    @Override
    public Element toElement() {
        Element applicationElement = new Element("Application", DefinitionConstants.NS_INSTANCE_KPDL);
        applicationElement.setAttribute("Id", this.id);
        applicationElement.setAttribute("Name", NAME);
        applicationElement.setAttribute("ApplicationType", this.applicationType.getName());
        Element descriptionElement = new Element("Description", DefinitionConstants.NS_INSTANCE_KPDL);
        descriptionElement.setText(DESCRIPTION);
        applicationElement.addContent((Content)descriptionElement);
        if (this.formalParameters != null && this.formalParameters.size() > 0) {
            applicationElement.addContent((Content)this.formalParameters.toElement());
        }
        if (this.extendedAttributes != null && this.extendedAttributes.size() > 0) {
            applicationElement.addContent((Content)this.extendedAttributes.toElement());
        } else {
            applicationElement.addContent((Content)new Element("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL));
        }
        if (this.function != null) {
            applicationElement.addContent((Content)this.function.toElement());
        }
        if (this.script != null) {
            applicationElement.addContent((Content)this.script.toElement());
        }
        if (this.externalClass != null) {
            applicationElement.addContent((Content)this.externalClass.toElement());
        }
        if (this.wsOperationDef != null) {
            applicationElement.addContent((Content)this.wsOperationDef.toElement());
        }
        if (this.resources != null) {
            applicationElement.addContent((Content)this.resources.toElement());
        }
        if (this.methodDef != null) {
            applicationElement.addContent((Content)this.methodDef.toElement());
        }
        return applicationElement;
    }

    @Override
    public void setContainer(AbstractKpdlElement element) {
        super.setContainer(element);
        this.container = (ProcessDef)element;
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    @Override
    protected IKpdlElement innerParse(Element destApplicationDefElement) throws WfKpdlParseException {
        Element resourcesElement;
        Element elementWSOperation;
        Element externalClassAttributesElement;
        Element scriptAttributesElement;
        Element methodAttributesElement;
        Element functionAttributesElement;
        Element extendedAttributesElement;
        if (destApplicationDefElement == null) {
            throw new IllegalArgumentException();
        }
        this.id = XmlUtil.readStringAttr(destApplicationDefElement, "Id");
        this.applicationType = ApplicationType.getEnum(destApplicationDefElement.getAttributeValue("ApplicationType"));
        Element formalParametersElement = destApplicationDefElement.getChild("FormalParameters", DefinitionConstants.NS_INSTANCE_KPDL);
        if (formalParametersElement != null) {
            this.formalParameters = new FormalParameterCollection(formalParametersElement, (ProcessDef)this.container);
        }
        if ((extendedAttributesElement = destApplicationDefElement.getChild("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.extendedAttributes = new ExtendedAttributeCollection(extendedAttributesElement);
        }
        if ((functionAttributesElement = destApplicationDefElement.getChild("Function", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.function = new FunctionDef(functionAttributesElement);
        }
        if ((methodAttributesElement = destApplicationDefElement.getChild("JavaMethod", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.methodDef = new JavaMethodDef(methodAttributesElement);
        }
        if ((scriptAttributesElement = destApplicationDefElement.getChild("Script", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.script = new ScriptDef(scriptAttributesElement);
        }
        if ((externalClassAttributesElement = destApplicationDefElement.getChild("ExternalClass", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.externalClass = new ExternalClassDef(externalClassAttributesElement);
        }
        if ((elementWSOperation = destApplicationDefElement.getChild("WSOperation", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.wsOperationDef = new WSOperationDef(this, elementWSOperation);
        }
        if ((resourcesElement = destApplicationDefElement.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.resources = new ResourceCollection(this, resourcesElement);
        }
        return this;
    }

    public WSOperationDef getWSOperationDef() {
        return this.wsOperationDef;
    }

    public void setWSOperationDef(WSOperationDef wsOperationDef) {
        this.wsOperationDef = wsOperationDef;
    }

    public JavaMethodDef getJavaMethod() {
        return this.methodDef;
    }

    public void setJavaMethod(JavaMethodDef methodDef) {
        this.methodDef = methodDef;
    }

    public String generateId() {
        return Uuid.create().toString() + BOSTYPE;
    }
}

