/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.KpdlResourceUtils;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public class AssignmentMessage
extends AbstractKpdlElement {
    private static final long serialVersionUID = 2157773069151680229L;
    private static final String BOSTYPE = "WFAMGDEF";
    private String title;
    private String body;
    private String id;
    private String extendParam;
    private String category;
    private boolean isSendMail;
    private boolean isMailSameAsMessage;
    private String mailTitle;
    private String mailBody;
    private boolean isGenerateBySystem;
    private String sourceKey;
    private String billIdKey;
    private String billState;
    private boolean showWfImg;

    public AssignmentMessage(AbstractKpdlElement container) {
        block3: {
            this.title = KpdlResourceUtils.ASSIGNMENTMESSAGE_TITLE.getName();
            this.body = KpdlResourceUtils.ASSIGNMENTMESSAGE_BODY.getName();
            this.extendParam = KpdlResourceUtils.ASSIGNMENTMESSAGE_EXTENDPARAM.getName();
            this.category = "";
            this.mailTitle = KpdlResourceUtils.EMAIL_TITLE.getName();
            this.mailBody = KpdlResourceUtils.EMAIL_BODY.getName();
            this.isGenerateBySystem = false;
            this.sourceKey = null;
            this.container = container;
            this.id = Uuid.create().toString() + BOSTYPE;
            this.isSendMail = false;
            this.isMailSameAsMessage = true;
            this.isGenerateBySystem = false;
            this.category = "";
            if (this.container != null) {
                try {
                    this.setTitle(new Resource(this.title, this.id, ""));
                    this.setBody(new Resource(this.body, this.id, ""));
                    this.setMailTitle(new Resource(this.mailTitle, this.id, ""));
                    this.setMailBody(new Resource(this.mailBody, this.id, ""));
                    this.setExtendParam(new Resource(this.extendParam, this.id, ""));
                }
                catch (WfException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"ActivityMessage.construct setTitle error", (Throwable)((Object)e));
                }
            }
        }
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public boolean isMailSameAsMessage() {
        return this.isMailSameAsMessage;
    }

    public void setMailSameAsMessage(boolean isMailSameAsMessage) {
        this.isMailSameAsMessage = isMailSameAsMessage;
    }

    public AssignmentMessage(AbstractKpdlElement container, String destTitle, String destBody) {
        this(container);
        this.title = destTitle;
        this.body = destBody;
        this.isSendMail = false;
        this.isMailSameAsMessage = true;
        this.isGenerateBySystem = false;
    }

    public AssignmentMessage(AbstractKpdlElement container, Element messageElement) throws WfKpdlParseException {
        this(container);
        this.parse(messageElement);
    }

    public String getTitle() {
        Locale l = null;
        if (this.container != null) {
            l = this.container.getLocale();
        }
        if (l == null) {
            l = new Locale("l2");
        }
        return this.getTitle(l);
    }

    public String getTitle(Locale locale) {
        if (this.getTitleResource() == null) {
            return null;
        }
        return this.getTitleResource().getValue(locale);
    }

    public Resource getTitleResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(this.title + this.id);
    }

    public String getExtendParam() {
        Locale l = null;
        if (this.container != null) {
            l = this.container.getLocale();
        }
        if (l == null) {
            l = new Locale("l2");
        }
        return this.getExtendParam(l);
    }

    public String getExtendParam(Locale locale) {
        if (this.getExtParamResource() == null) {
            return null;
        }
        return this.getExtParamResource().getValue(locale);
    }

    public Resource getExtParamResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(this.extendParam + this.id);
    }

    public void setExtendParam(String string) throws WfException {
        this.setExtendParam(this.container.getLocale(), string);
    }

    public void setExtendParam(Resource destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(this.extendParam + this.id, destName);
    }

    public void setExtendParam(Locale locale, String string) throws WfException {
        if (this.container == null) {
            throw new WfException("Container is null");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (string == null) {
            string = "";
        }
        if (this.extendParam == null) {
            this.extendParam = KpdlResourceUtils.ASSIGNMENTMESSAGE_EXTENDPARAM.getName();
        }
        if (this.getExtParamResource() == null) {
            this.setExtendParam(new Resource(this.extendParam, this.id, locale, string));
        } else {
            this.getExtParamResource().setValue(locale, string);
        }
    }

    public void setTitle(String string) throws WfException {
        this.setTitle(this.container.getLocale(), string);
    }

    public void setTitle(Locale locale, String string) throws WfException {
        if (this.container == null) {
            throw new WfException("Container is null");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (string == null) {
            string = "";
        }
        if (this.getTitleResource() == null) {
            this.setTitle(new Resource(this.title, this.id, locale, string));
        } else {
            this.getTitleResource().setValue(locale, string);
        }
    }

    public void setTitle(Resource destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(this.title + this.id, destName);
    }

    public String getBody() {
        Locale l = null;
        if (this.container != null) {
            l = this.container.getLocale();
        }
        if (l == null) {
            l = new Locale("l2");
        }
        return this.getBody(l);
    }

    public String getBody(Locale locale) {
        if (this.getBodyResource() == null) {
            return null;
        }
        return this.getBodyResource().getValue(locale);
    }

    public Resource getBodyResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(this.body + this.id);
    }

    public void setBody(String string) throws WfException {
        this.setBody(this.container.getLocale(), string);
    }

    public void setBody(Locale locale, String string) throws WfException {
        if (this.container == null) {
            throw new WfException("Container is null");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (string == null) {
            string = "";
        }
        if (this.getBodyResource() == null) {
            this.setBody(new Resource(this.body, this.id, locale, string));
        } else {
            this.getBodyResource().setValue(locale, string);
        }
    }

    public void setBody(Resource destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(this.body + this.id, destName);
    }

    @Override
    public Element toElement() {
        Element messageElement = new Element("AssignmentMessage", DefinitionConstants.NS_INSTANCE_KPDL);
        if (this.id != null) {
            messageElement.setAttribute("Id", this.id);
        }
        if (this.sourceKey != null) {
            messageElement.setAttribute("SourceKey", this.sourceKey);
        }
        if (this.title != null) {
            messageElement.setAttribute("Title", this.title);
        }
        if (this.body != null) {
            messageElement.setAttribute("Body", this.body);
        }
        if (this.mailTitle != null) {
            messageElement.setAttribute("MailTitle", this.mailTitle);
        }
        if (this.mailBody != null) {
            messageElement.setAttribute("MailBody", this.mailBody);
        }
        if (this.resources != null) {
            messageElement.addContent((Content)this.resources.toElement());
        }
        messageElement.setAttribute("isSendMail", String.valueOf(this.isSendMail));
        messageElement.setAttribute("isMailSameAsMessage", String.valueOf(this.isMailSameAsMessage));
        if (this.billIdKey != null) {
            messageElement.setAttribute("billId", this.billIdKey);
            if (this.billState != null) {
                messageElement.setAttribute("billState", this.billState);
            }
        }
        messageElement.setAttribute("showWfImg", String.valueOf(this.showWfImg));
        messageElement.setAttribute("isGenerateBySystem", String.valueOf(this.isGenerateBySystem));
        if (this.category != null) {
            messageElement.setAttribute("category", this.category);
        }
        return messageElement;
    }

    public String getMailTitle() {
        return this.getMailTitle(this.container.getLocale());
    }

    public String getMailTitle(Locale locale) {
        if (this.getMailTitleResource() == null) {
            return null;
        }
        return this.getMailTitleResource().getValue(locale);
    }

    public Resource getMailTitleResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(this.mailTitle + this.id);
    }

    public void setMailTitle(String string) throws WfException {
        this.setMailTitle(this.container.getLocale(), string);
    }

    public void setMailTitle(Locale locale, String string) throws WfException {
        if (this.container == null) {
            throw new WfException("Container is null");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (string == null) {
            string = "";
        }
        if (this.getMailTitleResource() == null) {
            if (StringUtils.isEmpty((String)this.mailTitle)) {
                this.mailTitle = KpdlResourceUtils.EMAIL_TITLE.getName();
            }
            this.setMailTitle(new Resource(this.mailTitle, this.id, locale, string));
        } else {
            this.getMailTitleResource().setValue(locale, string);
        }
    }

    public void setMailTitle(Resource destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(this.mailTitle + this.id, destName);
    }

    public String getMailBody() {
        return this.getMailBody(this.container.getLocale());
    }

    public String getMailBody(Locale locale) {
        if (this.getMailBodyResource() == null) {
            return null;
        }
        return this.getMailBodyResource().getValue(locale);
    }

    public Resource getMailBodyResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(this.mailBody + this.id);
    }

    public void setMailBody(String string) throws WfException {
        this.setMailBody(this.container.getLocale(), string);
    }

    public void setMailBody(Locale locale, String string) throws WfException {
        if (this.container == null) {
            throw new WfException("Container is null");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (string == null) {
            string = "";
        }
        if (this.getMailBodyResource() == null) {
            if (StringUtils.isEmpty((String)this.mailBody)) {
                this.mailBody = KpdlResourceUtils.EMAIL_BODY.getName();
            }
            this.setMailBody(new Resource(this.mailBody, this.id, locale, string));
        } else {
            this.getMailBodyResource().setValue(locale, string);
        }
    }

    public void setMailBody(Resource destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(this.mailBody + this.id, destName);
    }

    public String toString() {
        return this.id + " " + this.getTitleResource().toString() + " /n" + this.getBodyResource().toString();
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.resources.updateResourceId(this.getBodyResource(), string);
        this.resources.updateResourceId(this.getTitleResource(), string);
        this.resources.updateResourceId(this.getExtParamResource(), string);
        this.id = string;
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    @Override
    protected IKpdlElement innerParse(Element messageElement) throws WfKpdlParseException {
        Element resourcesElement;
        if (messageElement.getAttributes() != null && messageElement.getAttributes().size() > 0) {
            this.id = XmlUtil.readStringAttr(messageElement, "Id");
            this.sourceKey = XmlUtil.readStringAttr(messageElement, "SourceKey");
            this.title = XmlUtil.readStringAttr(messageElement, "Title");
            this.body = XmlUtil.readStringAttr(messageElement, "Body");
            this.mailTitle = XmlUtil.readStringAttr(messageElement, "MailTitle");
            this.mailBody = XmlUtil.readStringAttr(messageElement, "MailBody");
            this.billIdKey = XmlUtil.readStringAttr(messageElement, "billId");
            this.billState = XmlUtil.readStringAttr(messageElement, "billState");
            String isSendMail = XmlUtil.readStringAttr(messageElement, "isSendMail");
            String isMailSameAsMessage = XmlUtil.readStringAttr(messageElement, "isMailSameAsMessage");
            this.isSendMail = "true".equalsIgnoreCase(isSendMail);
            this.isMailSameAsMessage = StringUtils.isEmpty((String)isMailSameAsMessage) ? true : "true".equalsIgnoreCase(isMailSameAsMessage);
            this.showWfImg = "true".equalsIgnoreCase(XmlUtil.readStringAttr(messageElement, "showWfImg"));
            String isGenerateBySystem = XmlUtil.readStringAttr(messageElement, "isGenerateBySystem");
            this.isGenerateBySystem = "true".equalsIgnoreCase(isGenerateBySystem);
            this.category = XmlUtil.readStringAttr(messageElement, "category");
        }
        if ((resourcesElement = messageElement.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.resources = new ResourceCollection(this, resourcesElement);
        }
        if (StringUtils.isEmpty((String)this.getBody()) && StringUtils.isEmpty((String)this.getTitle())) {
            this.isGenerateBySystem = true;
        }
        this.getExtendParam();
        return this;
    }

    public boolean isSendMail() {
        return this.isSendMail;
    }

    public void setSendMail(boolean isSendMail) {
        this.isSendMail = isSendMail;
    }

    public void setSourceKey(String key) {
        this.sourceKey = key;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public String getBillIdKey() {
        return this.billIdKey;
    }

    public void setBillIdKey(String billIdKey) {
        this.billIdKey = billIdKey;
    }

    public String getBillState() {
        return this.billState;
    }

    public void setBillState(String billState) {
        this.billState = billState;
    }

    public boolean isShowWfImg() {
        return this.showWfImg;
    }

    public void setShowWfImg(boolean showWfImg) {
        this.showWfImg = showWfImg;
    }

    public boolean isGenerateBySystem() {
        return this.isGenerateBySystem;
    }

    public void setGenerateBySystem(boolean isGenerateBySystem) {
        this.isGenerateBySystem = isGenerateBySystem;
    }
}

