/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.Uuid;
import org.jdom2.Content;
import org.jdom2.Element;

public class AutoApproveDef
extends AbstractKpdlElement {
    private static final String BOSTYPE = "WFAPPROVEDEF";
    private String id;
    private String approveAttitude;
    private String approveResult;
    private String decisionContent;
    private String decisionNumber;

    public AutoApproveDef() {
        this.approveAttitude = "";
        this.approveResult = "";
        this.decisionContent = "";
        this.decisionNumber = "";
        this.id = Uuid.create().toString() + BOSTYPE;
    }

    public AutoApproveDef(AbstractKpdlElement container) {
        this.id = Uuid.create().toString() + BOSTYPE;
        this.setContainer(container);
    }

    public AutoApproveDef(Element destScriptElement) throws WfKpdlParseException {
        this();
        this.parse(destScriptElement);
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String getApproveAttitude() {
        return this.approveAttitude;
    }

    public void setApproveAttitude(String approveAttitude) {
        this.approveAttitude = approveAttitude;
    }

    public String getApproveResult() {
        return this.approveResult;
    }

    public void setApproveResult(String approveResult) {
        this.approveResult = approveResult;
    }

    public String getDecisionContent() {
        return this.decisionContent;
    }

    public void setDecisionContent(String decisionContent) {
        this.decisionContent = decisionContent;
    }

    public String getDecisionNumber() {
        return this.decisionNumber;
    }

    public void setDecisionNumber(String decisionNumber) {
        this.decisionNumber = decisionNumber;
    }

    @Override
    public Element toElement() {
        Element autoApproveElement = new Element("autoApprove", DefinitionConstants.NS_INSTANCE_KPDL);
        autoApproveElement.setAttribute("Id", this.id != null ? this.id : "");
        autoApproveElement.setAttribute("approveResult", this.approveResult != null ? this.approveResult : "");
        autoApproveElement.setAttribute("decisionNumber", this.decisionNumber != null ? this.decisionNumber : "");
        autoApproveElement.setAttribute("decisionContent", this.decisionContent != null ? this.decisionContent : "");
        Element approveAttitudeElement = new Element("approveAttitude", DefinitionConstants.NS_INSTANCE_KPDL);
        autoApproveElement.addContent((Content)approveAttitudeElement);
        approveAttitudeElement.addContent(this.approveAttitude != null ? this.approveAttitude : "");
        return autoApproveElement;
    }

    @Override
    protected IKpdlElement innerParse(Element destElement) throws WfKpdlParseException {
        if (destElement == null) {
            throw new IllegalArgumentException();
        }
        this.id = XmlUtil.readStringAttr(destElement, "Id");
        this.approveResult = XmlUtil.readStringAttr(destElement, "approveResult");
        this.decisionNumber = XmlUtil.readStringAttr(destElement, "decisionNumber");
        this.decisionContent = XmlUtil.readStringAttr(destElement, "decisionContent");
        Element approveAttitudeElement = destElement.getChild("approveAttitude", DefinitionConstants.NS_INSTANCE_KPDL);
        if (approveAttitudeElement != null) {
            this.approveAttitude = XmlUtil.readText(approveAttitudeElement);
        }
        return this;
    }
}

