/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.CorrelationPropertyAliasDef;
import com.kingdee.bos.workflow.define.CorrelationSetDef;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.Uuid;
import org.jdom2.Content;
import org.jdom2.Element;

public class CorrelationPropertyDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -7850419967348554772L;
    public static final String BOS_TYPE = "CPROPDEF";
    private String id;
    private String name;
    private CorrelationPropertyAliasDef propertyAliasDef;

    public CorrelationPropertyDef(CorrelationSetDef correlationSetDef) {
        this.container = correlationSetDef;
        this.id = Uuid.create() + BOS_TYPE;
    }

    public CorrelationPropertyDef(CorrelationSetDef correlationSetDef, Element destElement) throws WfKpdlParseException {
        this.container = correlationSetDef;
        this.parse(destElement);
    }

    @Override
    protected IKpdlElement innerParse(Element destElement) throws WfKpdlParseException {
        this.id = XmlUtil.readStringAttr(destElement, "Id");
        this.name = XmlUtil.readStringAttr(destElement, "Name");
        Element element = destElement.getChild("CorrelationPropertyAlias", DefinitionConstants.NS_INSTANCE_KPDL);
        if (element != null) {
            this.propertyAliasDef = new CorrelationPropertyAliasDef(this, element);
        }
        return this;
    }

    @Override
    public Element toElement() {
        Element propertyElement = new Element("CorrelationProperty", DefinitionConstants.NS_INSTANCE_KPDL);
        propertyElement.setAttribute("Id", this.id);
        propertyElement.setAttribute("Name", this.name);
        if (this.propertyAliasDef != null) {
            propertyElement.addContent((Content)this.propertyAliasDef.toElement());
        }
        return propertyElement;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String bosType() {
        return BOS_TYPE;
    }

    public CorrelationPropertyAliasDef getCorrelationPropertyAliasDef() {
        return this.propertyAliasDef;
    }

    public void setCorrelationPropertyAliasDef(CorrelationPropertyAliasDef propertyAliasDef) {
        this.propertyAliasDef = propertyAliasDef;
    }
}

