/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.CorrelationPattern;
import com.kingdee.bos.workflow.define.CorrelationPropertyCollection;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import org.jdom2.Content;
import org.jdom2.Element;

public class CorrelationSetDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -254627337632097022L;
    private static final String BOSTYPE = "COSETDEF";
    private String id;
    private String name;
    private CorrelationPattern pattern;
    private String wsOperationName;
    private CorrelationPropertyCollection correlationProperties;

    public CorrelationSetDef(ProcessDef processDef) {
        this.container = processDef;
        this.id = Uuid.create() + BOSTYPE;
        this.correlationProperties = new CorrelationPropertyCollection(this);
    }

    public CorrelationSetDef(ProcessDef processDef, Element destElement) throws WfKpdlParseException {
        this.container = processDef;
        this.correlationProperties = new CorrelationPropertyCollection(this);
        this.parse(destElement);
    }

    @Override
    protected IKpdlElement innerParse(Element destElement) throws WfKpdlParseException {
        this.id = XmlUtil.readStringAttr(destElement, "Id");
        this.name = XmlUtil.readStringAttr(destElement, "Name");
        String patternStr = destElement.getAttributeValue("Pattern");
        this.pattern = CorrelationPattern.getEnum(patternStr);
        this.wsOperationName = XmlUtil.readStringAttr(destElement, "WSOperationName");
        Element element = destElement.getChild("CorrelationProperties", DefinitionConstants.NS_INSTANCE_KPDL);
        if (element != null) {
            this.correlationProperties = new CorrelationPropertyCollection(this, element);
        }
        return this;
    }

    @Override
    public Element toElement() {
        Element correlationSetElement = new Element("CorrelationSet", DefinitionConstants.NS_INSTANCE_KPDL);
        correlationSetElement.setAttribute("Id", this.id);
        correlationSetElement.setAttribute("Name", this.name);
        correlationSetElement.setAttribute("Pattern", this.pattern.getName());
        if (!StringUtils.isEmpty((String)this.wsOperationName)) {
            correlationSetElement.setAttribute("WSOperationName", this.wsOperationName);
        }
        correlationSetElement.addContent((Content)this.correlationProperties.toElement());
        return correlationSetElement;
    }

    public CorrelationPropertyCollection getCorrelationProperties() {
        return this.correlationProperties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CorrelationPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(CorrelationPattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String getWSOperationName() {
        return this.wsOperationName;
    }

    public void setWSOperationName(String wsOperationName) {
        this.wsOperationName = wsOperationName;
    }
}

