/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElementCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class DataFieldCollection
extends AbstractKpdlElementCollection {
    private static final long serialVersionUID = 3879871462573386462L;

    public DataFieldCollection(ProcessDef process) {
        this.container = process;
    }

    public DataFieldCollection(ProcessDef destContainedProcessDef, Element destDataFieldListElement) throws WfKpdlParseException {
        this(destContainedProcessDef);
        this.parse(destDataFieldListElement);
        this.trimToSize();
    }

    public DataFieldDef getByName(String name) {
        DataFieldDef df = null;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getName().equals(name)) continue;
            df = this.get(i);
        }
        return df;
    }

    public DataFieldDef get(String key) {
        return (DataFieldDef)this.getObject(key);
    }

    public DataFieldDef get(int i) {
        return (DataFieldDef)this.getObject(i);
    }

    public boolean add(String key, DataFieldDef value) {
        return this.addObject(key, (Object)value);
    }

    public DataFieldDef set(String key, DataFieldDef value) {
        return (DataFieldDef)this.setObject(key, (Object)value);
    }

    @Override
    public Object remove(String key) {
        return this.removeObjectByKey(key);
    }

    @Override
    public Element toElement() {
        Element dataFieldsElement = new Element("DataFields", DefinitionConstants.NS_INSTANCE_KPDL);
        if (this.size() > 0) {
            Iterator dataFieldsIterator = this.iterator();
            while (dataFieldsIterator.hasNext()) {
                dataFieldsElement.addContent((Content)((DataFieldDef)dataFieldsIterator.next()).toElement());
            }
        }
        return dataFieldsElement;
    }

    @Override
    public IKpdlElement parse(Element destDataFieldListElement) throws WfKpdlParseException {
        if (destDataFieldListElement == null) {
            throw new IllegalArgumentException();
        }
        List tempElementList = destDataFieldListElement.getChildren("DataField", DefinitionConstants.NS_INSTANCE_KPDL);
        Element tempElement = null;
        DataFieldDef tempDataFieldDef = null;
        for (int i = 0; i < tempElementList.size(); ++i) {
            tempElement = (Element)tempElementList.get(i);
            tempDataFieldDef = new DataFieldDef(tempElement, (ProcessDef)this.container);
            this.add(tempDataFieldDef.getID(), tempDataFieldDef);
        }
        return this;
    }
}

