/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.EventPolicyDef;
import com.kingdee.bos.workflow.define.ExecutionMode;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class DeadlineDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -8617339971034316591L;
    public static final String ConservationDay = "ConservationDay";
    public static final String WorkingDay = "WorkingDay";
    private String orgId = "";
    private String orgName = "";
    private String timeMode = "ConservationDay";
    private String deadlineCondition;
    private EventPolicyDef eventPolicy;
    private ExecutionMode execution;

    public DeadlineDef(AbstractKpdlElement container) {
        this.container = container;
        this.deadlineCondition = "";
        this.eventPolicy = new EventPolicyDef();
        this.execution = ExecutionMode.ASYNCHR;
    }

    public DeadlineDef() {
        this.deadlineCondition = "";
        this.eventPolicy = new EventPolicyDef();
        this.execution = ExecutionMode.ASYNCHR;
    }

    public DeadlineDef(AbstractKpdlElement container, Element destDeadlineElement) throws WfKpdlParseException {
        this(container);
        this.parse(destDeadlineElement);
    }

    public DeadlineDef(Element destDeadlineElement) throws WfKpdlParseException {
        this();
        this.parse(destDeadlineElement);
    }

    public String getDeadlineCondition() {
        return this.deadlineCondition;
    }

    public void setDeadlineCondition(String destDeadlineCondition) {
        this.deadlineCondition = destDeadlineCondition;
    }

    public EventPolicyDef getEventPolicy() {
        return this.eventPolicy;
    }

    public void setEventPolicy(EventPolicyDef def) {
        this.eventPolicy = def;
    }

    public ExecutionMode getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionMode destExecution) {
        this.execution = destExecution;
    }

    public int check() {
        return 0;
    }

    @Override
    public Element toElement() {
        Element deadlineElement = new Element("Deadline", DefinitionConstants.NS_INSTANCE_KPDL);
        deadlineElement.setAttribute("Execution", this.execution.getName());
        Element deadlineConditionElement = new Element("DeadlineCondition", DefinitionConstants.NS_INSTANCE_KPDL);
        deadlineConditionElement.setText(this.deadlineCondition);
        deadlineElement.addContent((Content)deadlineConditionElement);
        Element deadlineTimeTypeElement = new Element("DeadlineTimeType", DefinitionConstants.NS_INSTANCE_KPDL);
        deadlineTimeTypeElement.setAttribute("timeMode", "" + this.timeMode);
        deadlineTimeTypeElement.setAttribute("orgId", this.orgId == null ? "" : this.orgId);
        deadlineTimeTypeElement.setAttribute("orgName", this.orgName == null ? "" : this.orgName);
        deadlineElement.addContent((Content)deadlineTimeTypeElement);
        deadlineElement.addContent((Content)this.eventPolicy.toElement());
        return deadlineElement;
    }

    @Override
    public String getID() {
        throw new RuntimeException("NotSupport");
    }

    @Override
    public String bosType() {
        return null;
    }

    @Override
    protected IKpdlElement innerParse(Element destDeadlineElement) throws WfKpdlParseException {
        Element eventPolicyElement;
        Element deadlineTimeTypeElement;
        Element deadlineConditionElement;
        if (destDeadlineElement == null) {
            throw new IllegalArgumentException();
        }
        String tempExecution = destDeadlineElement.getAttributeValue("Execution");
        if (tempExecution != null && tempExecution.length() > 0) {
            this.execution = ExecutionMode.getEnum(destDeadlineElement.getAttributeValue("Execution"));
        }
        if ((deadlineConditionElement = destDeadlineElement.getChild("DeadlineCondition", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.deadlineCondition = XmlUtil.readText(deadlineConditionElement);
        }
        if ((deadlineTimeTypeElement = destDeadlineElement.getChild("DeadlineTimeType", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.timeMode = XmlUtil.readStringAttr(deadlineTimeTypeElement, "timeMode");
            this.orgId = XmlUtil.readStringAttr(deadlineTimeTypeElement, "orgId");
            this.orgName = XmlUtil.readStringAttr(deadlineTimeTypeElement, "orgName");
        }
        if ((eventPolicyElement = destDeadlineElement.getChild("EventPolicy", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.eventPolicy = new EventPolicyDef(this.container, eventPolicyElement);
        }
        return this;
    }

    public String getTimeMode() {
        return this.timeMode;
    }

    public void setTimeMode(String timeMode) {
        this.timeMode = timeMode;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
}

