/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ApplicationType;
import com.kingdee.bos.workflow.define.FunctionScriptType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.ToolType;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class FunctionActivityDef
extends ToolActivityDef {
    private static final long serialVersionUID = -3906987753602990709L;
    public static final String ELEMENT_NAME = "FunctionTool";
    public static final String FUNCTION_KEY = "scriptFunction";
    public static final String FUNCTION_NAME = "name";
    private String script = "";
    private FunctionScriptType scriptType = FunctionScriptType.KSCRIPT;
    private String scriptFunctionid = null;

    public String getScriptFunctionid() {
        return this.scriptFunctionid;
    }

    public void setScriptFunctionid(String scriptFunctionid) {
        this.scriptFunctionid = scriptFunctionid;
    }

    public FunctionActivityDef(ProcessDef container) {
        super(container);
        try {
            this.setName("FunctionActivity");
        }
        catch (WfException e) {
            log.error((Object)e.getMessage());
        }
    }

    public FunctionActivityDef(ProcessDef container, Element destToolActivityDefElement) throws WfKpdlParseException {
        super(container, destToolActivityDefElement);
        Element functEl = destToolActivityDefElement.getChild("function");
        if (functEl != null) {
            String scriptFunctionid;
            String script;
            FunctionScriptType type = FunctionScriptType.getType(functEl.getAttributeValue("type"));
            if (type != null) {
                this.scriptType = type;
            }
            if ((script = functEl.getText()) != null) {
                this.script = script;
            }
            if ((scriptFunctionid = functEl.getAttributeValue("scriptFunctionid")) != null) {
                this.scriptFunctionid = scriptFunctionid;
            }
        }
    }

    @Override
    public void setRedoApplication(ApplicationDef destRedoApplication) throws WfException {
        if (!ApplicationType.FUNCTION.equals((Object)destRedoApplication.getType())) {
            throw new WfException("ApplicationType not function");
        }
        super.setRedoApplication(destRedoApplication);
    }

    @Override
    public void setRelatedApplication(ApplicationDef destRelatedApplication) throws WfException {
        if (!ApplicationType.FUNCTION.equals((Object)destRelatedApplication.getType())) {
            throw new WfException("ApplicationType not function");
        }
        super.setRelatedApplication(destRelatedApplication);
    }

    @Override
    protected void setToolType(ToolType type) {
        this.toolType = ToolType.APPLICATION;
    }

    @Override
    public Element toElement() {
        Element ecElement = super.toElement();
        if (ecElement != null) {
            ecElement.setName(ELEMENT_NAME);
            Element el = new Element("function");
            el.setAttribute("type", this.scriptType.getName());
            if (!StringUtils.isEmpty((String)this.scriptFunctionid)) {
                el.setAttribute("scriptFunctionid", this.scriptFunctionid);
                this.script = "";
            }
            el.addContent((Content)new CDATA(this.script));
            ecElement.addContent((Content)el);
        }
        return ecElement;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public FunctionScriptType getScriptType() {
        return this.scriptType;
    }

    public void setScriptType(FunctionScriptType scriptType) {
        this.scriptType = scriptType;
    }

    public FunctionActivityDef deepClone(FunctionActivityDef info) {
        info = (FunctionActivityDef)super.deepClone(info);
        FunctionActivityDef dc = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(info);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream bis = new ObjectInputStream(bais);
            dc = (FunctionActivityDef)bis.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return dc;
    }
}

