/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.FunctionType;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import org.jdom2.Element;

public class FunctionDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -6215360711720771214L;
    private String packageName = "";
    private String name = "";
    private String operation = "";
    private FunctionType type = FunctionType.UI;
    private String uiObjectName = "";
    private String uiState = "";
    private String uiAction;

    public String getName() {
        return this.name;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public FunctionType getType() {
        return this.type;
    }

    public String getUiObjectName() {
        return this.uiObjectName;
    }

    public String getUiState() {
        return this.uiState;
    }

    public void setType(FunctionType type) {
        this.type = type;
    }

    public void setUiObjectName(String string) {
        this.uiObjectName = string;
    }

    public void setUiState(String string) {
        this.uiState = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOperation(String string) {
        this.operation = string;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getUiAction() {
        return this.uiAction;
    }

    public void setUiAction(String string) {
        this.uiAction = string;
    }

    public FunctionDef() {
    }

    public FunctionDef(Element destFunctionElement) throws WfKpdlParseException {
        this();
        this.parse(destFunctionElement);
    }

    @Override
    public Element toElement() {
        Element functionElement = new Element("Function", DefinitionConstants.NS_INSTANCE_KPDL);
        functionElement.setAttribute("Name", StringUtils.cnulls((String)this.name));
        functionElement.setAttribute("PackageName", StringUtils.cnulls((String)this.packageName));
        functionElement.setAttribute("Operation", StringUtils.cnulls((String)this.operation));
        functionElement.setAttribute("Type", this.type.getName());
        functionElement.setAttribute("UiObjectName", StringUtils.cnulls((String)this.uiObjectName));
        functionElement.setAttribute("UiState", StringUtils.cnulls((String)this.uiState));
        functionElement.setAttribute("UiAction", StringUtils.cnulls((String)this.uiAction));
        return functionElement;
    }

    @Override
    public String getID() {
        throw new RuntimeException("NotSupport");
    }

    @Override
    public String bosType() {
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Function:");
        sb.append(this.name + ";");
        sb.append(this.operation + ";");
        sb.append(this.packageName + ";");
        sb.append((Object)((Object)this.type) + ";");
        sb.append(this.uiAction + ";");
        sb.append(this.uiObjectName + ";");
        sb.append(this.uiState + ";");
        return sb.toString();
    }

    @Override
    protected IKpdlElement innerParse(Element destFunctionElement) throws WfKpdlParseException {
        if (destFunctionElement == null) {
            throw new IllegalArgumentException();
        }
        this.packageName = XmlUtil.readStringAttr(destFunctionElement, "PackageName");
        this.name = XmlUtil.readStringAttr(destFunctionElement, "Name");
        this.operation = XmlUtil.readStringAttr(destFunctionElement, "Operation");
        this.type = FunctionType.getEnum(destFunctionElement.getAttributeValue("Type"));
        this.uiObjectName = XmlUtil.readStringAttr(destFunctionElement, "UiObjectName");
        this.uiState = XmlUtil.readStringAttr(destFunctionElement, "UiState");
        this.uiAction = XmlUtil.readStringAttr(destFunctionElement, "UiAction");
        return this;
    }
}

