/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ImportDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -7489032148721886935L;
    public static final String BOS_TYPE = "IMPORDEF";
    private String id;
    private String importType;
    private String location;
    private String namespace;
    private String namespacePrefix;

    public ImportDef(ProcessDef processDef) {
        this.container = processDef;
        this.id = Uuid.create() + BOS_TYPE;
    }

    public ImportDef(ProcessDef processDef, Element destElement) throws WfKpdlParseException {
        this.container = processDef;
        this.parse(destElement);
    }

    @Override
    public String bosType() {
        return BOS_TYPE;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    protected IKpdlElement innerParse(Element destElement) throws WfKpdlParseException {
        this.id = XmlUtil.readStringAttr(destElement, "Id");
        this.importType = XmlUtil.readStringAttr(destElement, "ImportType");
        this.location = XmlUtil.readStringAttr(destElement, "Location");
        this.namespace = XmlUtil.readStringAttr(destElement, "Namespace");
        Element root = destElement.getParentElement().getParentElement();
        List namespaces = root.getAdditionalNamespaces();
        int size = namespaces.size();
        for (int i = 0; i < size; ++i) {
            Namespace tmp = (Namespace)namespaces.get(i);
            if (!this.namespace.equals(tmp.getURI())) continue;
            this.namespacePrefix = tmp.getPrefix();
            break;
        }
        return this;
    }

    @Override
    public Element toElement() {
        Element importElement = new Element("Import", DefinitionConstants.NS_INSTANCE_KPDL);
        importElement.setAttribute("Id", this.id);
        importElement.setAttribute("ImportType", this.importType);
        importElement.setAttribute("Location", this.location);
        importElement.setAttribute("Namespace", this.namespace);
        return importElement;
    }

    public String getImportType() {
        return this.importType;
    }

    public void setImportType(String importType) {
        this.importType = importType;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public boolean isWSDL() {
        return "http://schemas.xmlsoap.org/wsdl/".equals(this.importType);
    }

    public boolean isSchema() {
        return "http://www.w3.org/2001/XMLSchema".equals(this.importType);
    }

    public boolean isProcessWSDL() {
        ProcessDef processDef;
        String interfaceName;
        if (this.isWSDL() && !StringUtils.isEmpty((String)(interfaceName = (processDef = (ProcessDef)this.getContainer()).getProcessHeader().getInterfaceName()))) {
            return interfaceName.equals(this.namespacePrefix);
        }
        return false;
    }
}

