/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElementCollection;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ImportDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class ImportDefCollection
extends AbstractKpdlElementCollection {
    private static final long serialVersionUID = 8625179459467774492L;

    public ImportDefCollection(ProcessDef processDef) {
        this.container = processDef;
    }

    public ImportDefCollection(ProcessDef processDef, Element root) throws WfKpdlParseException {
        this(processDef);
        this.parse(root);
        this.trimToSize();
    }

    @Override
    public IKpdlElement parse(Element root) throws WfKpdlParseException {
        List elementList = root.getChildren("Import", DefinitionConstants.NS_INSTANCE_KPDL);
        for (int i = 0; i < elementList.size(); ++i) {
            Element element = (Element)elementList.get(i);
            ImportDef importDef = new ImportDef((ProcessDef)this.container, element);
            this.addImportDef(importDef);
        }
        return this;
    }

    @Override
    public Element toElement() {
        Element importsElement = new Element("Imports", DefinitionConstants.NS_INSTANCE_KPDL);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ImportDef ImportDef2 = (ImportDef)iterator.next();
            importsElement.addContent((Content)ImportDef2.toElement());
        }
        return importsElement;
    }

    public void addImportDef(ImportDef importDef) {
        this.addObject(importDef.getID(), (Object)importDef);
    }

    public ImportDef getImportDef(int index) {
        return (ImportDef)this.getObject(index);
    }

    public ImportDef getImportDefByPrefix(String namespacePrefix) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ImportDef importDef = this.getImportDef(i);
            if (!namespacePrefix.equals(importDef.getNamespacePrefix())) continue;
            return importDef;
        }
        return null;
    }

    public ImportDef getImportDefByNamespace(String namespace) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ImportDef importDef = this.getImportDef(i);
            if (!namespace.equals(importDef.getNamespace())) continue;
            return importDef;
        }
        return null;
    }

    public ImportDef getProcessImportDef() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ImportDef importDef = this.getImportDef(i);
            if (!importDef.isProcessWSDL()) continue;
            return importDef;
        }
        return null;
    }
}

