/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.KpdlResourceUtils;
import com.kingdee.bos.workflow.define.OrgTypeDef;
import com.kingdee.bos.workflow.define.ParticipantInvolveType;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ReferenceHumanType;
import com.kingdee.bos.workflow.define.RelationType;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.upgrade.IUpgradeManager;
import com.kingdee.bos.workflow.upgrade.IWfUpgrader;
import com.kingdee.bos.workflow.upgrade.UpgradeException;
import com.kingdee.bos.workflow.upgrade.UpgradeManagerFactory;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class ParticipantDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -3489036771229508548L;
    private static final String BOSTYPE = "WFPATDEF";
    public static final String UNIQUEID_KEY = "uniqueID";
    private String id;
    private String name;
    private OrgTypeDef orgType;
    private String description;
    private ParticipantType participantType;
    private ExtendedAttributeCollection extendedAttributes;
    private String orgID;
    private String orgName;
    private String processExecutorType;
    private RelationType relationType;
    private ReferenceHumanType referenceHumanType;
    private String referenceHumanId;
    private String performDatafieldId;
    private final String referenceHumanName;
    private String permissionOwnerId;
    private String hierarchyId;
    private String hierarchyNameKey;
    private String refPositionId;
    private String refPositionNameKey;
    private String scriptRef;
    private ParticipantInvolveType involeType;
    private String exceptFormRef;
    private String caseID;
    private String participantValueRef;
    private Map<String, String> ExParDefMap;
    private String WFROrgAttribute;
    private final String[] exMapKey;

    public ParticipantDef(ActivityDef destContainedActivityDef) {
        block6: {
            this.referenceHumanName = KpdlResourceUtils.PARTICIPANT_REFERENCEHUMANNAME.getName();
            this.hierarchyNameKey = KpdlResourceUtils.PARTICIPANT_RELATION_HIERARCHYNAME.getName();
            this.refPositionNameKey = KpdlResourceUtils.PARTICIPANT_RELATION_REF_POSITIONNAME.getName();
            this.WFROrgAttribute = null;
            this.exMapKey = new String[]{"WFRoleNum", "WFRoleType", "WFRoleState", "WFAdminName", "WFRoleGroupNum", "userNum", "userType", "FormalName", "ActualName"};
            this.container = destContainedActivityDef;
            this.participantValueRef = this.id = Uuid.create().toString() + BOSTYPE;
            this.name = "";
            this.orgType = new OrgTypeDef();
            this.description = "";
            this.participantType = ParticipantType.ROLE;
            this.extendedAttributes = new ExtendedAttributeCollection();
            this.relationType = RelationType.SELF;
            this.referenceHumanType = ReferenceHumanType.EMPLOYEE;
            this.referenceHumanId = "";
            this.orgID = "";
            this.orgName = "";
            this.permissionOwnerId = "";
            this.processExecutorType = "";
            this.hierarchyId = "";
            if (this.container != null && this.container.getContainer() != null) {
                try {
                    if (this.getReferenceHumanNameResource() == null) {
                        this.setReferenceHumanName(new Resource(this.referenceHumanName, this.id));
                    }
                    if (this.getRelationHierarchyNameResource() == null) {
                        this.setRelationHierarchyNameRes(new Resource(this.hierarchyNameKey, this.id));
                    }
                    if (this.getRelationPositionNameResource() == null) {
                        this.setReferencePositionNameRes(new Resource(this.refPositionNameKey, this.id));
                    }
                }
                catch (WfException e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)"ParticipantDef.construct error", (Throwable)((Object)e));
                }
            }
        }
    }

    public ParticipantDef(ActivityDef destContainedActivityDef, Element destParticipantDefElement) throws WfKpdlParseException {
        this(destContainedActivityDef);
        this.parse(destParticipantDefElement);
    }

    public Map<String, String> getExParDefMap() {
        return this.ExParDefMap;
    }

    public void setExParDefMap(Map<String, String> exParDefMap) {
        this.ExParDefMap = exParDefMap;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String destDescription) {
        this.description = destDescription;
    }

    public ExtendedAttributeCollection getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String destName) {
        this.name = destName;
    }

    public ParticipantType getParticipantType() {
        return this.participantType;
    }

    public void setParticipantType(ParticipantType destParticipantType) {
        this.participantType = destParticipantType;
    }

    public String getParticipantValue() {
        return this.participantValueRef;
    }

    public void setParticipantValue(String destID) {
        this.participantValueRef = destID;
    }

    public OrgTypeDef getOrgType() {
        return this.orgType;
    }

    public void setOrgType(OrgTypeDef def) {
        this.orgType = def;
    }

    public String getReferenceHumanId() {
        return this.referenceHumanId;
    }

    public ReferenceHumanType getReferenceHumanType() {
        return this.referenceHumanType;
    }

    public RelationType getRelationType() {
        return this.relationType;
    }

    public void setReferenceHumanId(String string) {
        this.referenceHumanId = string;
    }

    public String getReferenceHumanName() {
        if (this.container == null || this.container.getContainer() == null) {
            return null;
        }
        return this.getReferenceHumanName(this.container.getContainer().getLocale());
    }

    public Resource getReferenceHumanNameResource() {
        if (this.container == null || this.container.getContainer() == null) {
            return null;
        }
        return this.resources.get(this.referenceHumanName + this.id);
    }

    public String getReferenceHumanName(Locale locale) {
        if (this.getReferenceHumanNameResource() == null) {
            return null;
        }
        return this.getReferenceHumanNameResource().getValue(locale);
    }

    public String getRelationHierarchyName(Locale locale) {
        if (this.getRelationHierarchyNameResource() == null) {
            return null;
        }
        return this.getRelationHierarchyNameResource().getValue(locale);
    }

    public String getRelationPositionName(Locale locale) {
        if (this.getRelationPositionNameResource() == null) {
            return null;
        }
        return this.getRelationPositionNameResource().getValue(locale);
    }

    public void setReferenceHumanName(String destReferenceHumanName) throws WfException {
        if (this.container.getContainer().isReadOnly()) {
            throw new WfException("Read only");
        }
        this.setReferenceHumanName(this.container.getContainer().getLocale(), destReferenceHumanName);
    }

    public void setRelationHierarchyName(Locale locale, String hierarchyName) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.getContainer().isReadOnly()) {
            throw new WfException("Read only");
        }
        if (hierarchyName == null) {
            throw new IllegalArgumentException();
        }
        if (this.getRelationHierarchyNameResource() == null) {
            this.setRelationHierarchyNameRes(new Resource(this.hierarchyNameKey, this.id, locale, hierarchyName));
        } else {
            this.getRelationHierarchyNameResource().setValue(locale, hierarchyName);
        }
    }

    public void setRelationPositionName(Locale locale, String positionName) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.getContainer().isReadOnly()) {
            throw new WfException("Read only");
        }
        if (positionName == null) {
            throw new IllegalArgumentException();
        }
        if (this.getRelationPositionNameResource() == null) {
            this.setReferencePositionNameRes(new Resource(this.refPositionNameKey, this.id, locale, positionName));
        } else {
            this.getRelationPositionNameResource().setValue(locale, positionName);
        }
    }

    private Resource getRelationHierarchyNameResource() {
        if (this.container == null || this.container.getContainer() == null) {
            return null;
        }
        return this.resources.get(this.hierarchyNameKey + this.id);
    }

    private Resource getRelationPositionNameResource() {
        if (this.container == null || this.container.getContainer() == null) {
            return null;
        }
        return this.resources.get(this.refPositionNameKey + this.id);
    }

    public void setReferenceHumanName(Locale locale, String destReferenceHumanName) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.getContainer().isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destReferenceHumanName == null) {
            throw new IllegalArgumentException();
        }
        if (this.getReferenceHumanNameResource() == null) {
            this.setReferenceHumanName(new Resource(this.referenceHumanName, this.id, locale, destReferenceHumanName));
        } else {
            this.getReferenceHumanNameResource().setValue(locale, destReferenceHumanName);
        }
    }

    public void setReferenceHumanName(Resource destReferenceHumanName) throws WfException {
        if (this.container.getContainer().isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(this.referenceHumanName + this.id, destReferenceHumanName);
    }

    public void setReferencePositionNameRes(Resource destReferenceHumanName) throws WfException {
        if (this.container.getContainer().isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(this.refPositionNameKey + this.id, destReferenceHumanName);
    }

    public void setRelationHierarchyNameRes(Resource hierarchyNameRes) throws WfException {
        if (this.container.getContainer().isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(this.hierarchyNameKey + this.id, hierarchyNameRes);
    }

    public void setReferenceHumanType(ReferenceHumanType type) {
        this.referenceHumanType = type;
    }

    public void setRelationType(RelationType type) {
        this.relationType = type;
    }

    public int check() {
        return 0;
    }

    @Override
    public Element toElement() {
        Element orgIDElement;
        Element participantElement = new Element("Participant", DefinitionConstants.NS_INSTANCE_KPDL);
        participantElement.setAttribute("Id", this.id);
        participantElement.setAttribute("Name", this.name);
        if (!StringUtils.isEmpty((String)this.participantValueRef)) {
            participantElement.setAttribute("participantValue", this.participantValueRef);
        }
        if (!StringUtils.isEmpty((String)this.scriptRef)) {
            participantElement.setAttribute("scriptDef", this.scriptRef);
        }
        if (!StringUtils.isEmpty((String)this.exceptFormRef)) {
            participantElement.setAttribute("exceptFrom", this.exceptFormRef);
        }
        if (this.orgType != null) {
            participantElement.setAttribute("OrgTypeId", this.orgType.getOrgTypeID());
            participantElement.setAttribute("OrgType", this.orgType.getOrgTypeAlias());
        }
        if (this.WFROrgAttribute != null && this.WFROrgAttribute.length() > 0) {
            participantElement.setAttribute("WFROrgAttribute", this.WFROrgAttribute);
        }
        if (this.performDatafieldId != null) {
            participantElement.setAttribute("PerformDatafieldId", this.performDatafieldId);
        }
        Element participantTypeElement = new Element("ParticipantType", DefinitionConstants.NS_INSTANCE_KPDL);
        participantTypeElement.setText(this.participantType.getName());
        participantElement.addContent((Content)participantTypeElement);
        Element descriptionElement = new Element("Description", DefinitionConstants.NS_INSTANCE_KPDL);
        descriptionElement.setText(this.description);
        participantElement.addContent((Content)descriptionElement);
        if (this.orgID != null && this.orgID.length() > 0) {
            orgIDElement = new Element("OrgID", DefinitionConstants.NS_INSTANCE_KPDL);
            orgIDElement.setText(this.orgID);
            participantElement.addContent((Content)orgIDElement);
        }
        if (this.orgName != null && this.orgName.length() > 0) {
            Element orgNameElement = new Element("OrgName", DefinitionConstants.NS_INSTANCE_KPDL);
            orgNameElement.setText(this.orgName);
            participantElement.addContent((Content)orgNameElement);
        }
        if (this.permissionOwnerId != null && this.permissionOwnerId.length() > 0) {
            Element permissionOwnerIdElement = new Element("PermissionOwnerId", DefinitionConstants.NS_INSTANCE_KPDL);
            permissionOwnerIdElement.setText(this.permissionOwnerId);
            participantElement.addContent((Content)permissionOwnerIdElement);
        }
        if (this.extendedAttributes != null) {
            participantElement.addContent((Content)this.extendedAttributes.toElement());
        }
        if (this.participantType.equals((Object)ParticipantType.RELATION)) {
            Element relationInfoElement = new Element("RelationInfo", DefinitionConstants.NS_INSTANCE_KPDL);
            relationInfoElement.setAttribute("ReferenceHumanId", this.referenceHumanId == null ? "" : this.referenceHumanId);
            relationInfoElement.setAttribute("ReferenceHumanName", this.referenceHumanName == null ? "" : this.referenceHumanName);
            relationInfoElement.setAttribute("ReferenceHumanType", this.referenceHumanType != null ? this.referenceHumanType.getName() : ReferenceHumanType.EMPLOYEE.getName());
            relationInfoElement.setAttribute("RelationType", this.relationType != null ? this.relationType.getName() : RelationType.SELF.getName());
            relationInfoElement.setAttribute("HierarchyID", this.hierarchyId != null ? this.hierarchyId : "");
            relationInfoElement.setAttribute("ReferencePositionID", this.refPositionId != null ? this.refPositionId : "");
            participantElement.addContent((Content)relationInfoElement);
        }
        if (this.resources != null) {
            participantElement.addContent((Content)this.resources.toElement());
        }
        if (this.processExecutorType != null && this.processExecutorType.length() > 0) {
            orgIDElement = new Element("ProcessExecutorType", DefinitionConstants.NS_INSTANCE_KPDL);
            orgIDElement.setText(this.processExecutorType);
            participantElement.addContent((Content)orgIDElement);
        }
        if (this.ExParDefMap != null && this.ExParDefMap.size() > 0) {
            Element exElement = new Element("ExParDefMap", DefinitionConstants.NS_INSTANCE_KPDL);
            for (Map.Entry<String, String> e : this.ExParDefMap.entrySet()) {
                String ek = e.getKey().toString();
                String ev = e.getValue().toString();
                exElement.setAttribute(ek, ev);
            }
            participantElement.addContent((Content)exElement);
        }
        return participantElement;
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    public String getPerformDatafieldId() {
        return this.performDatafieldId;
    }

    public void setPerformDatafieldId(String string) {
        this.performDatafieldId = string;
    }

    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String string) {
        this.orgID = string;
    }

    public String getPermissionOwnerId() {
        return this.permissionOwnerId;
    }

    public void setPermissionOwnerId(String permissionOwnerId) {
        this.permissionOwnerId = permissionOwnerId;
    }

    public String getHierarchyId() {
        return this.hierarchyId;
    }

    public void setHierarchyId(String hierarchyID) {
        this.hierarchyId = hierarchyID;
    }

    public String getRefPositionId() {
        if (this.refPositionId != null && this.refPositionId.trim().length() == 0) {
            return null;
        }
        return this.refPositionId;
    }

    public void setRefPositionId(String refPositionId) {
        this.refPositionId = refPositionId;
    }

    public String getCaseID() {
        return this.caseID;
    }

    public void setCaseID(String caseID) {
        this.caseID = caseID;
    }

    public String getExceptFormRef() {
        return this.exceptFormRef;
    }

    public void setExceptFormRef(String exceptFormRef) {
        this.exceptFormRef = exceptFormRef;
    }

    public ParticipantInvolveType getInvoleType() {
        return this.involeType;
    }

    public void setInvoleType(ParticipantInvolveType involeType) {
        this.involeType = involeType;
    }

    public String getScriptRef() {
        return this.scriptRef;
    }

    public void setScriptRef(String scriptRef) {
        this.scriptRef = scriptRef;
    }

    @Override
    protected IKpdlElement innerParse(Element destParticipantDefElement) throws WfKpdlParseException {
        Element exMapElement;
        Element processExecutorTypeElement;
        Element resourcesElement;
        Element tempRelationInfoElement;
        OrgTypeDef tempOrgTypeDef;
        if (destParticipantDefElement == null) {
            throw new IllegalArgumentException();
        }
        this.id = XmlUtil.readStringAttr(destParticipantDefElement, "Id");
        this.name = XmlUtil.readStringAttr(destParticipantDefElement, "Name");
        this.participantValueRef = XmlUtil.readStringAttr(destParticipantDefElement, "participantValue");
        this.scriptRef = XmlUtil.readStringAttr(destParticipantDefElement, "scriptDef");
        this.exceptFormRef = XmlUtil.readStringAttr(destParticipantDefElement, "exceptFrom");
        String OrgTypeIdStr = destParticipantDefElement.getAttributeValue("OrgTypeId");
        String OrgTypeStr = destParticipantDefElement.getAttributeValue("OrgType");
        this.orgType = tempOrgTypeDef = new OrgTypeDef(OrgTypeIdStr, OrgTypeStr);
        this.performDatafieldId = XmlUtil.readStringAttr(destParticipantDefElement, "PerformDatafieldId");
        String participantTypeStr = XmlUtil.readString(destParticipantDefElement, "ParticipantType", DefinitionConstants.NS_INSTANCE_KPDL);
        this.participantType = ParticipantType.getEnum(participantTypeStr);
        this.description = XmlUtil.readString(destParticipantDefElement, "Description", DefinitionConstants.NS_INSTANCE_KPDL);
        Element orgIDElement = destParticipantDefElement.getChild("OrgID", DefinitionConstants.NS_INSTANCE_KPDL);
        this.orgID = orgIDElement != null ? XmlUtil.readText(orgIDElement) : "";
        Element orgNameElement = destParticipantDefElement.getChild("OrgName", DefinitionConstants.NS_INSTANCE_KPDL);
        this.orgName = orgNameElement != null ? XmlUtil.readText(orgNameElement) : "";
        Element permissionOwnerIdElement = destParticipantDefElement.getChild("PermissionOwnerId", DefinitionConstants.NS_INSTANCE_KPDL);
        this.permissionOwnerId = permissionOwnerIdElement != null ? XmlUtil.readText(permissionOwnerIdElement) : "";
        Element extendedAttributesElement = destParticipantDefElement.getChild("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL);
        if (extendedAttributesElement != null) {
            this.extendedAttributes = new ExtendedAttributeCollection(extendedAttributesElement);
        }
        if ((tempRelationInfoElement = destParticipantDefElement.getChild("RelationInfo", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.referenceHumanId = XmlUtil.readStringAttr(tempRelationInfoElement, "ReferenceHumanId");
            if (tempRelationInfoElement.getAttributeValue("ReferenceHumanType") != null) {
                this.referenceHumanType = ReferenceHumanType.getEnum(tempRelationInfoElement.getAttributeValue("ReferenceHumanType"));
            }
            if (tempRelationInfoElement.getAttributeValue("RelationType") != null) {
                this.relationType = RelationType.getEnum(tempRelationInfoElement.getAttributeValue("RelationType"));
            }
            this.hierarchyId = XmlUtil.readStringAttr(tempRelationInfoElement, "HierarchyID");
            this.refPositionId = XmlUtil.readStringAttr(tempRelationInfoElement, "ReferencePositionID");
        }
        if ((resourcesElement = destParticipantDefElement.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.resources = new ResourceCollection(this, resourcesElement);
        }
        if ((processExecutorTypeElement = destParticipantDefElement.getChild("ProcessExecutorType", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.processExecutorType = XmlUtil.readText(processExecutorTypeElement);
        }
        if ((exMapElement = destParticipantDefElement.getChild("ExParDefMap", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            HashMap<String, String> temp = new HashMap<String, String>();
            for (String key : this.exMapKey) {
                String value = exMapElement.getAttributeValue(key);
                if (value == null || value.length() <= 0) continue;
                temp.put(key, value);
            }
            this.setExParDefMap(temp);
        }
        this.WFROrgAttribute = destParticipantDefElement.getAttributeValue("WFROrgAttribute");
        return this;
    }

    public String getUniqueID() {
        return this.id;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.participantValueRef = id;
    }

    public void setId(String id) {
        this.resources.updateResourceId(this.getReferenceHumanNameResource(), id);
        this.id = id;
    }

    @Override
    protected void afterParse(IKpdlElement kpdlElement) throws UpgradeException {
        IUpgradeManager manager = UpgradeManagerFactory.createUpgrageManager();
        String thisVersion = "V5.0";
        try {
            thisVersion = ((ProcessDef)this.getContainer().getContainer()).getProcessHeader().getVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] params = new Object[]{thisVersion, "V6.1.0", this.getClass().getName(), this};
        IWfUpgrader[] upgraders = manager.getUpgraders(params);
        int n = upgraders.length;
        for (int i = 0; i < n; ++i) {
            upgraders[i].upgrade(kpdlElement);
        }
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getProcessExecutorType() {
        return this.processExecutorType;
    }

    public void setProcessExecutorType(String processExecutorType) {
        this.processExecutorType = processExecutorType;
    }

    public String getWFROrgAttribute() {
        return this.WFROrgAttribute;
    }

    public void setWFROrgAttribute(String wFROrgAttribute) {
        this.WFROrgAttribute = wFROrgAttribute;
    }
}

