/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import org.jdom2.Element;

public class PartnerLinkDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = 9020348112360701795L;
    public static final String BOS_TYPE = "PLINKDEF";
    private String id;
    private String name;
    private String myRoleName;
    private String partnerRoleName;
    private String partnerLinkTypeName;

    public PartnerLinkDef(ProcessDef processDef) {
        this.container = processDef;
        this.id = Uuid.create() + BOS_TYPE;
    }

    public PartnerLinkDef(ProcessDef processDef, Element destElement) throws WfKpdlParseException {
        this.container = processDef;
        this.parse(destElement);
    }

    @Override
    public String bosType() {
        return BOS_TYPE;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    protected IKpdlElement innerParse(Element destElement) throws WfKpdlParseException {
        this.id = XmlUtil.readStringAttr(destElement, "Id");
        this.name = XmlUtil.readStringAttr(destElement, "Name");
        this.myRoleName = XmlUtil.readStringAttr(destElement, "MyRoleName");
        this.partnerRoleName = XmlUtil.readStringAttr(destElement, "PartnerRoleName");
        this.partnerLinkTypeName = XmlUtil.readStringAttr(destElement, "PartnerLinkTypeName");
        return this;
    }

    @Override
    public Element toElement() {
        Element partnerLinkTypeElement = new Element("PartnerLink", DefinitionConstants.NS_INSTANCE_KPDL);
        partnerLinkTypeElement.setAttribute("Id", this.id);
        partnerLinkTypeElement.setAttribute("Name", this.name);
        if (!StringUtils.isEmpty((String)this.myRoleName)) {
            partnerLinkTypeElement.setAttribute("MyRoleName", this.myRoleName);
        }
        if (!StringUtils.isEmpty((String)this.partnerRoleName)) {
            partnerLinkTypeElement.setAttribute("PartnerRoleName", this.partnerRoleName);
        }
        partnerLinkTypeElement.setAttribute("PartnerLinkTypeName", this.partnerLinkTypeName);
        return partnerLinkTypeElement;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMyRoleName() {
        return this.myRoleName;
    }

    public void setMyRoleName(String myRoleName) {
        this.myRoleName = myRoleName;
    }

    public String getPartnerRoleName() {
        return this.partnerRoleName;
    }

    public void setPartnerRoleName(String partnerRoleName) {
        this.partnerRoleName = partnerRoleName;
    }

    public String getPartnerLinkTypeName() {
        return this.partnerLinkTypeName;
    }

    public void setPartnerLinkTypeName(String partnerLinkTypeName) {
        this.partnerLinkTypeName = partnerLinkTypeName;
    }
}

