/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.AccessLevel;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ApplicationCollection;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.AssignmentMessage;
import com.kingdee.bos.workflow.define.CorrelationSetCollection;
import com.kingdee.bos.workflow.define.DataFieldCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.ExecutionObjectType;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.IExecuteObject;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ImportDef;
import com.kingdee.bos.workflow.define.ImportDefCollection;
import com.kingdee.bos.workflow.define.KpdlResourceUtils;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.PartnerLinkDefCollection;
import com.kingdee.bos.workflow.define.PartnerLinkTypeDefCollection;
import com.kingdee.bos.workflow.define.ProcessDefCleaner;
import com.kingdee.bos.workflow.define.ProcessHeaderDef;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.ScriptCollection;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.TransactionBlockCollection;
import com.kingdee.bos.workflow.define.TransactionBlockDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.define.diagram.ActivityNode;
import com.kingdee.bos.workflow.define.diagram.Diagram;
import com.kingdee.bos.workflow.define.diagram.Line;
import com.kingdee.bos.workflow.define.diagram.Node;
import com.kingdee.bos.workflow.define.enhanced.Abstracts;
import com.kingdee.bos.workflow.define.enhanced.EMessage;
import com.kingdee.bos.workflow.define.enhanced.IAbstractActivity;
import com.kingdee.bos.workflow.define.enhanced.IEMessageActivity;
import com.kingdee.bos.workflow.define.enhanced.IMessageActivity;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ProcessDef
extends AbstractKpdlElement
implements IExecuteObject,
IAbstractActivity,
Serializable {
    private static final long serialVersionUID = 482109949177857939L;
    private static final String BOSTYPE = "WFPRCDEF";
    public static final String EXT_AUTO_MERGE_APPROVE = "autoMergeApprove";
    public static final String EXT_AUTO_MERGE_APPROVE_FORWARD = "autoMergeApproveForward";
    public static final String EXT_MUST_DESIGNATE_DIRECTACTIVITY_PERFORMER = "mustDesignateDirectActivityPerformer";
    public static final String EXT_MUST_DESIGNATE_ALLACTIVITY_PERFORMER = "mustDesignateAllActivityPerformer";
    public static final String EXT_USE_LAST_APPROVE_OPINION = "useLastApproveOpinion";
    private String id;
    private static final String NAME = KpdlResourceUtils.PROCESS_NAME.getName();
    private String code;
    private ProcessType type;
    private AccessLevel accessLevel;
    private ProcessHeaderDef processHeader;
    private FormalParameterCollection formalParameters;
    private DataFieldCollection dataFields;
    private ApplicationCollection applications;
    private ActivityCollection activitys;
    private TransitionCollection transitions;
    private TransactionBlockCollection transactionBlocks;
    private ScriptCollection scripts;
    private ExtendedAttributeCollection extendedAttributes;
    private StartActivityDef start;
    private EndActivityDef end;
    private boolean isReadOnly;
    private String hashValue;
    private boolean isTransationProcess = false;
    private Diagram diagram;
    private ImportDefCollection imports;
    private PartnerLinkTypeDefCollection partnerLinkTypes;
    private PartnerLinkDefCollection partnerLinks;
    private CorrelationSetCollection correlationSets;
    private boolean isDuplicated = false;
    private Map allBizObjInProcess;
    private String mainBizObjId = null;
    private boolean isSendMail = false;
    private boolean isSendSMS = false;
    private String billBostype = "";
    private Abstracts abs = null;

    public boolean isDuplicated() {
        return this.isDuplicated;
    }

    public void setDuplicated(boolean b) {
        this.isDuplicated = b;
    }

    public Map getAllBizObjInProcess() {
        return this.allBizObjInProcess;
    }

    public void setAllBizObjInProcess(Map allBizObjInProcess) {
        this.allBizObjInProcess = allBizObjInProcess;
    }

    @Override
    public ExecutionObjectType getExecuteObjectType() {
        return ExecutionObjectType.PROCESS;
    }

    private void parseProcessHeader(Element destProcessHeaderElement) throws WfKpdlParseException {
        this.processHeader = new ProcessHeaderDef(this, destProcessHeaderElement);
        this.isSendMail = Boolean.valueOf(destProcessHeaderElement.getAttributeValue("isSendMail"));
        this.isSendSMS = Boolean.valueOf(destProcessHeaderElement.getAttributeValue("isSendMobelMsg"));
    }

    private Element toProcessHeaderElement() {
        return this.getProcessHeader().toElement();
    }

    private void toSelfElement(Element processElement) {
        processElement.addNamespaceDeclaration(Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        processElement.addNamespaceDeclaration(Namespace.getNamespace((String)"schemaLocation", (String)"http://www.kingdee.com/2003/K-PDL1.0 K-PDL.xsd"));
        processElement.addNamespaceDeclaration(Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema"));
        int size = this.imports.size();
        for (int i = 0; i < size; ++i) {
            ImportDef importDef = this.imports.getImportDef(i);
            processElement.addNamespaceDeclaration(Namespace.getNamespace((String)importDef.getNamespacePrefix(), (String)importDef.getNamespace()));
        }
        processElement.setAttribute("Id", this.id);
        processElement.setAttribute("Name", KpdlResourceUtils.PROCESS_NAME.getName());
        processElement.setAttribute("AccessLevel", this.accessLevel.getName());
        processElement.setAttribute("Type", this.type.getName());
        processElement.setAttribute("Code", this.code != null ? this.code : "");
        processElement.setAttribute("BizPackage", KpdlResourceUtils.PROCESS_BIZPACKAGE.getName());
        processElement.setAttribute("isTransationProcess", String.valueOf(this.isTransationProcess));
        processElement.setAttribute("isDuplicated", String.valueOf(this.isDuplicated));
    }

    private void toHeaderElement(Element processElement) {
        Element processHeaderElement = this.toProcessHeaderElement();
        if (processHeaderElement != null) {
            processElement.addContent((Content)processHeaderElement);
        } else {
            processElement.addContent((Content)new Element("ProcessHeader", DefinitionConstants.NS_INSTANCE_KPDL));
        }
    }

    private void toFormalParametersElement(Element processElement) {
        if (this.formalParameters != null && this.formalParameters.size() > 0) {
            Element formalParametersElement = this.formalParameters.toElement();
            if (formalParametersElement != null) {
                processElement.addContent((Content)formalParametersElement);
            }
        } else {
            processElement.addContent((Content)new Element("FormalParameters", DefinitionConstants.NS_INSTANCE_KPDL));
        }
    }

    private void toDataFieldsElement(Element processElement) {
        if (this.dataFields != null && this.dataFields.size() > 0) {
            Element dataFieldsElement = this.dataFields.toElement();
            if (dataFieldsElement != null) {
                processElement.addContent((Content)dataFieldsElement);
            }
        } else {
            processElement.addContent((Content)new Element("DataFields", DefinitionConstants.NS_INSTANCE_KPDL));
        }
    }

    private void toApplicationsElement(Element processElement) {
        if (this.applications != null && this.applications.size() > 0) {
            Element applicationsElement = this.applications.toElement();
            if (applicationsElement != null) {
                processElement.addContent((Content)applicationsElement);
            }
        } else {
            processElement.addContent((Content)new Element("Applications", DefinitionConstants.NS_INSTANCE_KPDL));
        }
    }

    private void toActivitysElement(Element processElement) {
        if (this.activitys != null && this.activitys.size() > 0) {
            Element activitysElement = this.activitys.toElement();
            if (activitysElement != null) {
                processElement.addContent((Content)activitysElement);
            }
        } else {
            processElement.addContent((Content)new Element("Activities", DefinitionConstants.NS_INSTANCE_KPDL));
        }
    }

    private void toTransitionsElement(Element processElement) {
        if (this.transitions != null && this.transitions.size() > 0) {
            Element transitionsElement = this.transitions.toElement();
            if (transitionsElement != null) {
                processElement.addContent((Content)transitionsElement);
            }
        } else {
            processElement.addContent((Content)new Element("Transitions", DefinitionConstants.NS_INSTANCE_KPDL));
        }
    }

    private void toTransactionsElement(Element processElement) {
        if (this.transactionBlocks != null && this.transactionBlocks.size() > 0) {
            Element transactionsElement = this.transactionBlocks.toElement();
            if (transactionsElement != null) {
                processElement.addContent((Content)transactionsElement);
            }
        } else {
            processElement.addContent((Content)new Element("Transactions", DefinitionConstants.NS_INSTANCE_KPDL));
        }
    }

    private void toExtendedAttributesElement(Element processElement) {
        if (this.extendedAttributes != null && this.extendedAttributes.size() > 0) {
            Element extendedAttributesElement = this.extendedAttributes.toElement();
            if (extendedAttributesElement != null) {
                processElement.addContent((Content)extendedAttributesElement);
            }
        } else {
            processElement.addContent((Content)new Element("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL));
        }
    }

    private void toScriptsElement(Element processElement) {
        if (this.scripts != null && this.scripts.size() > 0) {
            Element extendedScriptsElement = this.scripts.toElement();
            if (extendedScriptsElement != null) {
                processElement.addContent((Content)extendedScriptsElement);
            }
        } else {
            processElement.addContent((Content)new Element("Scripts", DefinitionConstants.NS_INSTANCE_KPDL));
        }
    }

    private void toDiagramElement(Element processElement) {
        if (this.diagram != null) {
            Element diagramElement = this.diagram.toElement();
            if (diagramElement != null) {
                processElement.addContent((Content)diagramElement);
            }
        } else {
            processElement.addContent((Content)new Element("Diagram", DefinitionConstants.NS_INSTANCE_KPDL));
        }
    }

    private void toResourceElement(Element processElement) {
        if (this.resources != null && this.resources.size() > 0) {
            Element resourcesElement = this.resources.toElement();
            if (resourcesElement != null) {
                processElement.addContent((Content)resourcesElement);
            }
        } else {
            processElement.addContent((Content)new Element("Resources", DefinitionConstants.NS_INSTANCE_KPDL));
        }
    }

    private void toAbstractElement(Element processElement) {
        if (this.abs != null) {
            processElement.addContent((Content)this.abs.toElement());
        }
    }

    private void toImportsElement(Element processElement) {
        Element importsElement = this.imports.toElement();
        processElement.addContent((Content)importsElement);
    }

    private void toPartnerLinkTypesElement(Element processElement) {
        Element partnerLinkTypesElement = this.partnerLinkTypes.toElement();
        processElement.addContent((Content)partnerLinkTypesElement);
    }

    private void toPartnerLinksElement(Element processElement) {
        Element partnerLinksElement = this.partnerLinks.toElement();
        processElement.addContent((Content)partnerLinksElement);
    }

    private void toCorrelationSetsElement(Element processElement) {
        if (this.correlationSets != null && this.correlationSets.size() > 0) {
            Element correlationSetsElement = this.correlationSets.toElement();
            if (correlationSetsElement != null) {
                processElement.addContent((Content)correlationSetsElement);
            }
        } else {
            processElement.addContent((Content)new Element("CorrelationSets", DefinitionConstants.NS_INSTANCE_KPDL));
        }
    }

    @Override
    public Element toElement() {
        Element processElement = new Element("Process", DefinitionConstants.NS_INSTANCE_KPDL);
        this.toSelfElement(processElement);
        this.toHeaderElement(processElement);
        this.toImportsElement(processElement);
        this.toPartnerLinkTypesElement(processElement);
        this.toPartnerLinksElement(processElement);
        this.toCorrelationSetsElement(processElement);
        this.toFormalParametersElement(processElement);
        this.toDataFieldsElement(processElement);
        this.toApplicationsElement(processElement);
        this.toActivitysElement(processElement);
        this.toTransitionsElement(processElement);
        this.toTransactionsElement(processElement);
        this.toExtendedAttributesElement(processElement);
        this.toScriptsElement(processElement);
        this.toDiagramElement(processElement);
        this.toResourceElement(processElement);
        this.toAbstractElement(processElement);
        this.toMainBizObjId(processElement);
        this.toBizObjInProcess(processElement);
        return processElement;
    }

    public ProcessDef() throws WfKpdlParseException {
        this(false);
    }

    private ProcessDef(boolean isReadOnly) throws WfKpdlParseException {
        this.isReadOnly = isReadOnly;
        if (!isReadOnly) {
            this.diagram = new Diagram(this);
        }
        this.resources = new ResourceCollection();
        this.locale = Locale.getDefault();
        this.id = Uuid.create().toString() + BOSTYPE;
        this.code = "";
        this.resources.set(NAME, new Resource(NAME, this.id, "ProcessName"));
        this.type = ProcessType.NORMAL;
        this.accessLevel = AccessLevel.PUBLIC;
        this.isTransationProcess = false;
        this.processHeader = new ProcessHeaderDef(this);
        this.formalParameters = new FormalParameterCollection(this);
        this.dataFields = new DataFieldCollection(this);
        this.applications = new ApplicationCollection(this);
        this.activitys = new ActivityCollection(this);
        this.transitions = new TransitionCollection(this);
        this.transactionBlocks = new TransactionBlockCollection(this);
        this.extendedAttributes = new ExtendedAttributeCollection();
        this.scripts = new ScriptCollection();
        this.imports = new ImportDefCollection(this);
        this.partnerLinkTypes = new PartnerLinkTypeDefCollection(this);
        this.partnerLinks = new PartnerLinkDefCollection(this);
        this.correlationSets = new CorrelationSetCollection(this);
    }

    ProcessDef(Locale locale) throws WfKpdlParseException {
        this();
        this.locale = locale;
    }

    ProcessDef(String destHashValue, String destOriginalString, boolean destIsReadOnly) throws WfKpdlParseException {
        this(destIsReadOnly);
        this.hashValue = destHashValue;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String string) {
        this.code = string;
    }

    public ExtendedAttributeCollection getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(ExtendedAttributeCollection destExtendedAttributes) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        this.extendedAttributes = destExtendedAttributes;
    }

    public Resource getNameResource() {
        return this.resources.get(NAME + this.id);
    }

    public String getName() {
        return this.getName(this.locale);
    }

    public String getName(Locale locale) {
        if (this.getNameResource() == null) {
            return null;
        }
        return this.getNameResource().getValue(locale);
    }

    public void setName(String destName) throws WfException {
        this.setName(this.locale, destName);
    }

    public void setName(Locale locale, String destName) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (this.getNameResource() == null) {
            this.setName(new Resource(NAME, this.id, locale, destName));
        } else {
            this.getNameResource().setValue(locale, destName);
        }
    }

    public void setName(Resource destName) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        this.resources.set(NAME + this.id, destName);
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public ResourceCollection getResources() {
        return this.resources;
    }

    public void setDiagram(Diagram diagram) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (diagram == null) {
            throw new IllegalArgumentException();
        }
        this.diagram = diagram;
    }

    public void setResources(ResourceCollection collection) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        this.resources = collection;
    }

    public void setAccessLevel(AccessLevel destAcessLevel) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        this.accessLevel = destAcessLevel;
    }

    public void setID(String destID) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (destID == null || destID.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.getResources().updateResourceId(this.getNameResource(), destID);
        this.getResources().updateResourceId(this.getProcessHeader().getBizPackageResource(), destID);
        this.getResources().updateResourceId(this.getProcessHeader().getDescriptionResource(), destID);
        this.getResources().updateResourceId(this.getProcessHeader().getVendorResource(), destID);
        this.getResources().updateResourceId(this.getProcessHeader().getProcessTopicResource(), destID);
        this.id = destID;
    }

    public ApplicationDef getApplicationDef(String applicationDefID) {
        if (applicationDefID == null || applicationDefID.length() == 0) {
            return null;
        }
        return this.applications.get(applicationDefID);
    }

    public boolean addApplicationDef(ApplicationDef destApplicationDef) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (destApplicationDef == null) {
            throw new IllegalArgumentException();
        }
        return this.applications.add(destApplicationDef.getID(), destApplicationDef);
    }

    public String getOriginalString() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setIsReadOnly(boolean pIsReadOnly) throws WfException {
        this.isReadOnly = pIsReadOnly;
    }

    public DataFieldDef getDataFieldDef(String dataFieldDefID) throws WfException {
        if (dataFieldDefID == null || dataFieldDefID.length() == 0) {
            throw new IllegalArgumentException();
        }
        return this.dataFields.get(dataFieldDefID);
    }

    public boolean addDataFieldDef(DataFieldDef destDataFieldDef) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (destDataFieldDef == null) {
            throw new IllegalArgumentException();
        }
        return this.dataFields.add(destDataFieldDef.getID(), destDataFieldDef);
    }

    public TransitionCollection getTransitions() {
        return this.transitions;
    }

    public TransactionBlockCollection getTransactions() {
        return this.transactionBlocks;
    }

    public TransactionBlockDef getTransactionDef(String id) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException();
        }
        return this.transactionBlocks.get(id);
    }

    public void setTransitions(TransitionCollection destTransitions) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (destTransitions == null) {
            throw new IllegalArgumentException();
        }
        this.transitions = destTransitions;
    }

    public void setScripts(ScriptCollection destScripts) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (destScripts == null) {
            throw new IllegalArgumentException();
        }
        this.scripts = destScripts;
    }

    public TransitionDef getTransitionDef(String transitionDefID) {
        if (transitionDefID == null) {
            throw new IllegalArgumentException();
        }
        return this.transitions.get(transitionDefID);
    }

    public boolean addTransitionDef(TransitionDef destTransitionDef) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (destTransitionDef == null) {
            throw new IllegalArgumentException();
        }
        destTransitionDef.setContainedProcessDef(this);
        return this.transitions.add(destTransitionDef.getID(), destTransitionDef);
    }

    public ActivityCollection getActivitys() {
        return this.activitys;
    }

    public ActivityCollection getActivitys(ActivityType type) {
        ActivityCollection activities = new ActivityCollection(this);
        for (int i = 0; i < this.activitys.size(); ++i) {
            if (!this.activitys.get(i).getType().equals((Object)type)) continue;
            activities.add(this.activitys.get(i));
        }
        return activities;
    }

    public void setActivitys(ActivityCollection destActivitys) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (destActivitys == null) {
            throw new IllegalArgumentException();
        }
        this.activitys = destActivitys;
    }

    public ActivityDef getActivityDef(String activityId) {
        if (activityId == null || activityId.length() == 0) {
            throw new IllegalArgumentException();
        }
        return this.activitys.get(activityId);
    }

    public EventActivityDef getEventActivity(String activityId) {
        if (StringUtils.isEmpty((String)activityId)) {
            throw new IllegalArgumentException();
        }
        ActivityCollection aCol = this.getActivitys(ActivityType.EVENT);
        for (int i = 0; i < aCol.size(); ++i) {
            ActivityDef def = aCol.get(i);
            if (!def.getID().equalsIgnoreCase(activityId)) continue;
            return (EventActivityDef)def;
        }
        return null;
    }

    public boolean addActivityDef(ActivityDef destActivityDef) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (destActivityDef == null) {
            throw new IllegalArgumentException();
        }
        destActivityDef.setContainer(this);
        if (this.diagram == null) {
            this.diagram = new Diagram(this);
        }
        ActivityNode node = new ActivityNode(this.diagram);
        node.setRefActivity(destActivityDef);
        return this.activitys.add(destActivityDef.getID(), destActivityDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartActivityDef getStartActivity() {
        if (!this.isReadOnly || this.start == null) {
            ProcessDef processDef = this;
            synchronized (processDef) {
                if (this.start == null) {
                    for (int i = 0; i < this.activitys.size(); ++i) {
                        if (!this.activitys.get(i).getClass().equals(StartActivityDef.class)) continue;
                        this.start = (StartActivityDef)this.activitys.get(i);
                    }
                }
            }
        }
        return this.start;
    }

    public void setStartActivity(StartActivityDef pStart) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (pStart == null) {
            throw new IllegalArgumentException();
        }
        this.start = pStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndActivityDef getEndActivity() {
        if (!this.isReadOnly || this.end == null) {
            ProcessDef processDef = this;
            synchronized (processDef) {
                if (this.end == null) {
                    for (int i = 0; i < this.activitys.size(); ++i) {
                        if (!this.activitys.get(i).getClass().equals(EndActivityDef.class)) continue;
                        this.end = (EndActivityDef)this.activitys.get(i);
                    }
                }
            }
        }
        return this.end;
    }

    public void setEndActivity(EndActivityDef pEnd) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (pEnd == null) {
            throw new IllegalArgumentException();
        }
        this.end = pEnd;
    }

    public FormalParameterCollection getFormalParameters() {
        return this.formalParameters;
    }

    public void setFormalParameters(FormalParameterCollection destFormalParametersElement) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (destFormalParametersElement == null) {
            throw new IllegalArgumentException();
        }
        this.formalParameters = destFormalParametersElement;
    }

    public DataFieldCollection getDataFields() {
        return this.dataFields;
    }

    public void setDataFields(DataFieldCollection destDataFields) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (destDataFields == null) {
            throw new IllegalArgumentException();
        }
        this.dataFields = destDataFields;
    }

    public ApplicationCollection getApplications() {
        return this.applications;
    }

    public void setApplications(ApplicationCollection destApplications) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (destApplications == null) {
            throw new IllegalArgumentException();
        }
        this.applications = destApplications;
    }

    public String getDocHash() {
        return this.hashValue;
    }

    public String getHashValue() {
        return this.hashValue;
    }

    public void setHashValue(String hashValue) {
        this.hashValue = hashValue;
    }

    public String toXml() {
        Element processElement = this.toElement();
        return XmlUtil.elementToString(processElement);
    }

    @Override
    public String getID() {
        return this.id;
    }

    public ScriptCollection getScripts() {
        return this.scripts;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public ProcessHeaderDef getProcessHeader() {
        if (this.processHeader == null) {
            this.processHeader = new ProcessHeaderDef(this);
        }
        return this.processHeader;
    }

    public void setProcessHeader(ProcessHeaderDef destProcessHeader) {
        this.processHeader = destProcessHeader;
    }

    public ProcessType getType() {
        return this.type;
    }

    public void setType(ProcessType type) {
        this.type = type;
    }

    public boolean destroyActivity(String activityId) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (this.activitys != null) {
            ActivityDef activity = this.activitys.get(activityId);
            if (activity != null) {
                this.destroyTransitionByActivity(activity);
                this.destroyApplicationByActivity(activity);
                this.activitys.remove(activityId);
                this.resources.remove(KpdlResourceUtils.ACTIVITY_NAME.getName() + activityId);
                this.resources.remove(KpdlResourceUtils.ACTIVITYHEADER_DESCRIPTION.getName() + activityId);
            }
            return true;
        }
        return false;
    }

    public boolean destroyTransitionByActivity(ActivityDef activity) throws WfException {
        int i;
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (activity == null) {
            return true;
        }
        if (activity.getIncomingTransitions() != null) {
            TransitionCollection incomingTrans = activity.getIncomingTransitions();
            for (i = 0; i < incomingTrans.size(); ++i) {
                this.destroyTransition(incomingTrans.get(i).getID());
            }
        }
        if (activity.getOutgoingTransitions() != null) {
            TransitionCollection outgoingTrans = activity.getOutgoingTransitions();
            for (i = 0; i < outgoingTrans.size(); ++i) {
                this.destroyTransition(outgoingTrans.get(i).getID());
            }
        }
        return false;
    }

    public boolean destroyTransition(String transitionId) throws WfException {
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (this.transitions != null) {
            block4: {
                try {
                    this.transitions.remove(transitionId);
                    this.resources.remove((Object)((Object)KpdlResourceUtils.TRANSITION_NAME) + transitionId);
                    this.resources.remove((Object)((Object)KpdlResourceUtils.TRANSITION_DESCRIPTION) + transitionId);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"ProcessDef.destoryTransition error", (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    public boolean destroyApplicationByActivity(ActivityDef activity) throws WfException {
        int i;
        ToolActivityDef toolActivity;
        if (this.isReadOnly) {
            throw new WfException("Read only");
        }
        if (activity == null) {
            return true;
        }
        boolean isRef = false;
        if (activity.getType().equals((Object)ActivityType.MANPOWER)) {
            ManpowerActivityDef manpowerActivity = (ManpowerActivityDef)activity;
            if (manpowerActivity.getRelatedApplication() != null) {
                for (int i2 = 0; i2 < this.activitys.size(); ++i2) {
                    if (!this.activitys.get(i2).getType().equals((Object)ActivityType.MANPOWER) || ((ManpowerActivityDef)this.activitys.get(i2)).getRelatedApplication() == null || !((ManpowerActivityDef)this.activitys.get(i2)).getRelatedApplication().getID().equals(manpowerActivity.getRelatedApplication().getID())) continue;
                    isRef = true;
                    break;
                }
                if (!isRef) {
                    this.destroyApplication(manpowerActivity.getRelatedApplication().getID());
                    this.destroyApplication(manpowerActivity.getRedoApplication().getID());
                }
            }
            return true;
        }
        if (activity.getType().equals((Object)ActivityType.TOOL) && (toolActivity = (ToolActivityDef)activity).getRelatedApplication() != null) {
            for (i = 0; i < this.activitys.size(); ++i) {
                if (!this.activitys.get(i).getType().equals((Object)ActivityType.TOOL) || ((ToolActivityDef)this.activitys.get(i)).getRelatedApplication() == null || !((ToolActivityDef)this.activitys.get(i)).getRelatedApplication().getID().equals(toolActivity.getRelatedApplication().getID())) continue;
                isRef = true;
                break;
            }
            if (!isRef) {
                this.destroyApplication(toolActivity.getRelatedApplication().getID());
                this.destroyApplication(toolActivity.getRedoApplication().getID());
            }
        }
        if (activity.getType().equals((Object)ActivityType.EVENT)) {
            EventActivityDef eventActivity = (EventActivityDef)activity;
            if (eventActivity.getRelatedApplication() != null) {
                for (i = 0; i < this.activitys.size(); ++i) {
                    if (!this.activitys.get(i).getType().equals((Object)ActivityType.EVENT) || ((EventActivityDef)this.activitys.get(i)).getRelatedApplication() == null || !((EventActivityDef)this.activitys.get(i)).getRelatedApplication().getID().equals(eventActivity.getRelatedApplication().getID())) continue;
                    isRef = true;
                    break;
                }
            }
            if (!isRef) {
                this.destroyApplication(eventActivity.getRelatedApplication().getID());
                this.destroyApplication(eventActivity.getRedoApplication().getID());
            }
        }
        return false;
    }

    public boolean destroyApplication(String id) {
        boolean isRemoved = false;
        if (id == null && this.applications == null) {
            return true;
        }
        isRemoved = this.applications.remove(id) != null;
        this.resources.remove(KpdlResourceUtils.APPLICATION_NAME.getName() + id);
        this.resources.remove(KpdlResourceUtils.APPLICATION_DESCRIPTION.getName() + id);
        return isRemoved;
    }

    public boolean destroyDataField(String dataFieldId) {
        if (dataFieldId == null || dataFieldId.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.getActivitys() != null) {
            for (int i = 0; i < this.activitys.size(); ++i) {
                SubflowActivityDef subflowActivity;
                ToolActivityDef toolActivity;
                ManpowerActivityDef manpowerActivity;
                if (this.getActivitys().get(i).getType().equals((Object)ActivityType.MANPOWER) && (manpowerActivity = (ManpowerActivityDef)this.getActivitys().get(i)).getActualParameters() != null) {
                    ActualParameterCollection actualParams = manpowerActivity.getActualParameters();
                    for (int j = 0; j < actualParams.size(); ++j) {
                        if (!actualParams.get(i).getExpr().equals(this.getID())) continue;
                        actualParams.get(i).setExpr("");
                    }
                }
                if (this.getActivitys().get(i).getType().equals((Object)ActivityType.TOOL) && (toolActivity = (ToolActivityDef)this.getActivitys().get(i)).getActualParameters() != null) {
                    for (int j = 0; j < toolActivity.getActualParameters().size(); ++j) {
                        if (!toolActivity.getActualParameters().get(i).getExpr().equals(this.getID())) continue;
                        toolActivity.getActualParameters().get(i).setExpr("");
                    }
                }
                if (!this.getActivitys().get(i).getType().equals((Object)ActivityType.SUBFLOW) || (subflowActivity = (SubflowActivityDef)this.getActivitys().get(i)).getActualParameters() == null) continue;
                for (int j = 0; j < subflowActivity.getActualParameters().size(); ++j) {
                    if (!subflowActivity.getActualParameters().get(i).getExpr().equals(this.getID())) continue;
                    subflowActivity.getActualParameters().get(i).setExpr("");
                }
            }
        }
        if (this.getFormalParameters() != null) {
            String[] formualParameters = new String[this.getFormalParameters().size()];
            for (int i = 0; i < this.getFormalParameters().size(); ++i) {
                if (!this.getFormalParameters().get(i).getID().equals(this.getID())) continue;
                formualParameters[i] = this.getFormalParameters().get(i).getID();
            }
            for (int j = 0; j < formualParameters.length; ++j) {
                this.getFormalParameters().remove(formualParameters[j]);
                this.resources.remove(KpdlResourceUtils.FORMALPARAMETER_BOALIES.getName() + formualParameters[j]);
                this.resources.remove(KpdlResourceUtils.FORMALPARAMETER_PROPERTYALIES.getName() + formualParameters[j]);
                this.resources.remove(KpdlResourceUtils.FORMALPARAMETER_DESCRIPTION.getName() + formualParameters[j]);
            }
        }
        if (this.getDataFields() != null && this.getDataFields().get(dataFieldId) != null) {
            this.getDataFields().remove(dataFieldId);
            this.resources.remove(KpdlResourceUtils.DATAFIELD_NAME.getName() + dataFieldId);
            this.resources.remove(KpdlResourceUtils.DATAFIELD_DESCRIPTION.getName() + dataFieldId);
        }
        return true;
    }

    public ActivityCollection getStartupActivities() throws WfException {
        ActivityCollection activities = null;
        ActivityCollection postActivities = this.getStartActivity().getPostActivities();
        if (this.getStartActivity() != null && postActivities != null) {
            activities = new ActivityCollection(this);
            for (int i = 0; i < postActivities.size(); ++i) {
                activities.add(postActivities.get(i));
            }
            if (this.getEndActivity() != null) {
                activities.remove(this.getEndActivity().getID());
            }
        }
        return activities;
    }

    public ProcessDef cloneProcess() {
        ProcessDef cloneProcess;
        block2: {
            cloneProcess = null;
            try {
                cloneProcess = new ProcessDef();
                cloneProcess.parse(this.toElement());
            }
            catch (WfException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Process.cloneProcess error", (Throwable)((Object)e));
            }
        }
        return cloneProcess;
    }

    public boolean destroyNode(String id) throws WfException {
        if (this.diagram != null && this.diagram.getNodes() != null) {
            return this.destoryNode(this.diagram.getNodes().get(id));
        }
        return true;
    }

    public boolean destoryNode(Node node) throws WfException {
        ActivityNode actNode;
        boolean isRemoved = false;
        if (node != null && this.diagram != null && this.diagram.getNodes() != null && (isRemoved = this.diagram.getNodes().remove(node.getID())) && node instanceof ActivityNode && (actNode = (ActivityNode)node).getRefActivity() != null) {
            isRemoved = this.destroyActivity(actNode.getRefActivity().getID());
        }
        return isRemoved;
    }

    public boolean destroyLine(String id) throws WfException {
        if (this.diagram != null && this.diagram.getLines() != null) {
            return this.destoryLine(this.diagram.getLines().get(id));
        }
        return true;
    }

    public boolean destoryLine(Line line) throws WfException {
        if (this.diagram != null && this.diagram.getLines() != null && line != null) {
            boolean isRemoved = false;
            isRemoved = this.diagram.getLines().remove(line.getID());
            if (isRemoved && line.getRefTransition() != null && !line.getRefTransition().getID().equals("")) {
                isRemoved = this.destroyTransition(line.getRefTransition().getID());
            }
            return isRemoved;
        }
        return true;
    }

    public void clearUp() throws WfException {
        ProcessDefCleaner cleaner = new ProcessDefCleaner(this);
        cleaner.execute();
    }

    public TransitionCollection getTransitionsByActivity(String fromActivityId, String toActivityId) {
        if (fromActivityId == null || toActivityId == null) {
            throw new IllegalArgumentException();
        }
        TransitionCollection trans = new TransitionCollection(this);
        if (this.transitions != null) {
            for (int i = 0; i < this.transitions.size(); ++i) {
                if (!fromActivityId.equals(this.transitions.get(i).getFrom().getID()) || !toActivityId.equals(this.transitions.get(i).getTo().getID())) continue;
                trans.add(this.transitions.get(i).getID(), this.transitions.get(i));
            }
        }
        return trans;
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    public boolean isTransationProcess() {
        return this.isTransationProcess;
    }

    public void setTransationProcess(boolean isTransationProcess) {
        this.isTransationProcess = isTransationProcess;
    }

    private void parseSelf(Element rootElement) throws WfKpdlParseException {
        Element resourcesElement = rootElement.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL);
        if (resourcesElement != null) {
            this.resources = new ResourceCollection(this, resourcesElement);
        }
        this.id = XmlUtil.readStringAttr(rootElement, "Id");
        if (rootElement.getAttributeValue("Type") != null) {
            this.type = ProcessType.getEnum(rootElement.getAttributeValue("Type"));
        }
        this.accessLevel = AccessLevel.getEnum(rootElement.getAttributeValue("AccessLevel"));
        this.code = XmlUtil.readStringAttr(rootElement, "Code");
        this.isTransationProcess = Boolean.valueOf(rootElement.getAttributeValue("isTransationProcess"));
        this.isDuplicated = Boolean.valueOf(rootElement.getAttributeValue("isDuplicated"));
    }

    private void parseHeader(Element rootElement) throws WfKpdlParseException {
        Element processHeaderElement = rootElement.getChild("ProcessHeader", DefinitionConstants.NS_INSTANCE_KPDL);
        if (processHeaderElement == null) {
            throw new WfKpdlParseException("miss process header element");
        }
        this.parseProcessHeader(processHeaderElement);
    }

    private void parseImports(Element rootElement) throws WfKpdlParseException {
        Element importsElement = rootElement.getChild("Imports", DefinitionConstants.NS_INSTANCE_KPDL);
        if (importsElement != null) {
            this.imports = new ImportDefCollection(this, importsElement);
        }
    }

    private void parsePartnerLinkTypes(Element rootElement) throws WfKpdlParseException {
        Element partnerLinkTypesElement = rootElement.getChild("PartnerLinkTypes", DefinitionConstants.NS_INSTANCE_KPDL);
        if (partnerLinkTypesElement != null) {
            this.partnerLinkTypes = new PartnerLinkTypeDefCollection(this, partnerLinkTypesElement);
        }
    }

    private void parsePartnerLinks(Element rootElement) throws WfKpdlParseException {
        Element partnerLinksElement = rootElement.getChild("PartnerLinks", DefinitionConstants.NS_INSTANCE_KPDL);
        if (partnerLinksElement != null) {
            this.partnerLinks = new PartnerLinkDefCollection(this, partnerLinksElement);
        }
    }

    private void parseFormalParameters(Element rootElement) throws WfKpdlParseException {
        Element formalParamsElement = rootElement.getChild("FormalParameters", DefinitionConstants.NS_INSTANCE_KPDL);
        if (formalParamsElement != null) {
            this.formalParameters = new FormalParameterCollection(formalParamsElement, this);
        }
    }

    private void parseDataFields(Element rootElement) throws WfKpdlParseException {
        Element dataFieldsElement = rootElement.getChild("DataFields", DefinitionConstants.NS_INSTANCE_KPDL);
        if (dataFieldsElement != null) {
            this.dataFields = new DataFieldCollection(this, dataFieldsElement);
        }
    }

    private void parseApplications(Element rootElement) throws WfKpdlParseException {
        Element applicationsElement = rootElement.getChild("Applications", DefinitionConstants.NS_INSTANCE_KPDL);
        if (applicationsElement != null) {
            this.applications = new ApplicationCollection(this, applicationsElement);
        }
    }

    private void parseActivities(Element rootElement) throws WfKpdlParseException {
        Element activitysElement = rootElement.getChild("Activities", DefinitionConstants.NS_INSTANCE_KPDL);
        if (activitysElement != null) {
            this.activitys = new ActivityCollection(this, activitysElement);
        }
        if (this.isSendMail) {
            ActivityCollection acts = this.getActivitys();
            Iterator i = acts.iterator();
            while (i.hasNext()) {
                ActivityDef actf = (ActivityDef)i.next();
                if (!(actf instanceof IMessageActivity)) continue;
                AssignmentMessage msg = ((IMessageActivity)((Object)actf)).getMessage();
                msg.setSendMail(this.isSendMail);
                if (!(actf instanceof IEMessageActivity)) continue;
                EMessage emsg = ((IEMessageActivity)((Object)actf)).getEMessage();
                if (emsg == null) {
                    emsg = new EMessage(actf);
                }
                emsg.setEnable(this.isSendSMS);
                emsg.setContent(msg.getBody());
            }
        }
    }

    private void parseTransitions(Element rootElement) throws WfKpdlParseException {
        Element transitionsElement = rootElement.getChild("Transitions", DefinitionConstants.NS_INSTANCE_KPDL);
        if (transitionsElement != null) {
            this.transitions = new TransitionCollection(this, transitionsElement);
        }
    }

    private void parseScripts(Element rootElement) throws WfKpdlParseException {
        Element scriptsElement = rootElement.getChild("Scripts", DefinitionConstants.NS_INSTANCE_KPDL);
        if (scriptsElement != null) {
            this.scripts = new ScriptCollection(this, scriptsElement);
        }
    }

    private void parseExtendedAttributes(Element rootElement) throws WfKpdlParseException {
        Element extendedAttributesElement = rootElement.getChild("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL);
        if (extendedAttributesElement != null) {
            this.extendedAttributes = new ExtendedAttributeCollection(extendedAttributesElement);
        }
    }

    private void parseDiagram(Element rootElement) throws WfKpdlParseException {
        Element diagramElement;
        if (!this.isReadOnly && (diagramElement = rootElement.getChild("Diagram", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.diagram = new Diagram(diagramElement, this);
        }
    }

    private void parseTransactions(Element rootElement) throws WfKpdlParseException {
        Element transactionsElement = rootElement.getChild("Transactions", DefinitionConstants.NS_INSTANCE_KPDL);
        if (transactionsElement != null) {
            this.transactionBlocks = new TransactionBlockCollection(this, transactionsElement);
        }
    }

    private void parseAbstracts(Element rootElement) throws WfKpdlParseException {
        Element abstractElement = rootElement.getChild("abstracts", DefinitionConstants.NS_INSTANCE_KPDL);
        this.abs = null;
        if (abstractElement != null) {
            this.abs = new Abstracts(this);
            this.abs.parse(abstractElement);
        }
    }

    @Override
    protected IKpdlElement innerParse(Element rootElement) throws WfKpdlParseException {
        this.parseSelf(rootElement);
        this.parseHeader(rootElement);
        this.parseImports(rootElement);
        this.parsePartnerLinkTypes(rootElement);
        this.parsePartnerLinks(rootElement);
        this.parseCorrelatonSets(rootElement);
        this.parseFormalParameters(rootElement);
        this.parseDataFields(rootElement);
        this.parseApplications(rootElement);
        this.parseActivities(rootElement);
        this.parseTransitions(rootElement);
        this.parseScripts(rootElement);
        this.parseExtendedAttributes(rootElement);
        this.parseDiagram(rootElement);
        this.parseTransactions(rootElement);
        this.parseAbstracts(rootElement);
        this.parseMainBizObjId(rootElement);
        this.parseBizObjInProcess(rootElement);
        return this;
    }

    private void parseCorrelatonSets(Element rootElement) throws WfKpdlParseException {
        Element correlationSetsElement = rootElement.getChild("CorrelationSets", DefinitionConstants.NS_INSTANCE_KPDL);
        if (correlationSetsElement != null) {
            this.correlationSets = new CorrelationSetCollection(this, correlationSetsElement);
        }
    }

    public void clearupOriginalString() {
    }

    @Override
    public void setAbstract(Abstracts abs) {
        this.abs = abs;
    }

    @Override
    public Abstracts getAbstract() {
        return this.abs;
    }

    public ImportDefCollection getImports() {
        return this.imports;
    }

    public PartnerLinkTypeDefCollection getPartnerLinkTypes() {
        return this.partnerLinkTypes;
    }

    public PartnerLinkDefCollection getPartnerLinks() {
        return this.partnerLinks;
    }

    public CorrelationSetCollection getCorrelationSets() {
        return this.correlationSets;
    }

    private void toBizObjInProcess(Element processElement) {
        if (this.allBizObjInProcess != null) {
            Element pe = new Element("AllBizObjInProcess", DefinitionConstants.NS_INSTANCE_KPDL);
            for (Object name : this.allBizObjInProcess.keySet()) {
                Element bizobjel = new Element("BizObj", DefinitionConstants.NS_INSTANCE_KPDL);
                bizobjel.setAttribute("name", String.valueOf(name));
                List list = (List)this.allBizObjInProcess.get(name);
                int len = list.size();
                for (int i = 0; i < len; ++i) {
                    Element bizobjpropel = new Element("Property", DefinitionConstants.NS_INSTANCE_KPDL);
                    bizobjpropel.setAttribute("name", String.valueOf(list.get(i)));
                    bizobjel.addContent((Content)bizobjpropel);
                }
                pe.addContent((Content)bizobjel);
            }
            processElement.addContent((Content)pe);
        }
    }

    private void parseBizObjInProcess(Element rootElement) {
        Element pe = rootElement.getChild("AllBizObjInProcess", DefinitionConstants.NS_INSTANCE_KPDL);
        this.allBizObjInProcess = new HashMap();
        if (pe != null) {
            List bizobjList = pe.getChildren("BizObj", DefinitionConstants.NS_INSTANCE_KPDL);
            int len = bizobjList.size();
            for (int i = 0; i < len; ++i) {
                Element bizobjel = (Element)bizobjList.get(i);
                String name = XmlUtil.readStringAttr(bizobjel, "name");
                ArrayList<String> list = new ArrayList<String>();
                this.allBizObjInProcess.put(name, list);
                List property = bizobjel.getChildren("Property", DefinitionConstants.NS_INSTANCE_KPDL);
                int lenj = property.size();
                for (int j = 0; j < lenj; ++j) {
                    Element bizobjpropel = (Element)property.get(j);
                    String propname = XmlUtil.readStringAttr(bizobjpropel, "name");
                    list.add(propname);
                }
            }
        }
    }

    public String getMainBizObjId() {
        return this.mainBizObjId;
    }

    public void setMainBizObjId(String mainBizObjId) {
        this.mainBizObjId = mainBizObjId;
    }

    private void toMainBizObjId(Element processElement) {
        if (this.mainBizObjId != null) {
            Element pe = new Element("MainBizObjId", DefinitionConstants.NS_INSTANCE_KPDL);
            pe.setAttribute("id", this.mainBizObjId);
            processElement.addContent((Content)pe);
        }
    }

    private void parseMainBizObjId(Element rootElement) {
        String id;
        Element pe = rootElement.getChild("MainBizObjId", DefinitionConstants.NS_INSTANCE_KPDL);
        this.mainBizObjId = pe != null ? (id = XmlUtil.readStringAttr(pe, "id")) : null;
    }

    public String getBillBostype() {
        return this.billBostype;
    }

    public void setBillBostype(String billBostype) {
        this.billBostype = billBostype;
    }
}

