/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.util.SortedStringObjectMap;
import com.kingdee.util.Uuid;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class Resource
implements IKpdlElement {
    private static final long serialVersionUID = -5958216900041243211L;
    private String id;
    private String key;
    private Map values;
    private Locale defaultLocale = Locale.getDefault();

    public Resource() {
        this.values = new SortedStringObjectMap();
        this.id = Uuid.create().toString() + "WFRESDEF";
    }

    public Resource(String destKey, String destId) {
        this();
        this.setPK(destKey, destId);
    }

    public Resource(String destKey, String destId, String value) {
        this(destKey, destId, Locale.getDefault(), value);
    }

    public Resource(String destKey, String destId, Locale locale, String value) {
        this(destKey, destId);
        this.setValue(locale, value);
    }

    public Resource(Element destElement) throws WfKpdlParseException {
        this();
        this.parse(destElement);
    }

    @Override
    public Element toElement() {
        Element resourceElement = new Element("Resource", DefinitionConstants.NS_INSTANCE_KPDL);
        resourceElement.setAttribute("Key", this.key);
        resourceElement.setAttribute("Id", this.id);
        if (this.values != null && this.values.size() > 0) {
            Object value = null;
            Element languageElement = null;
            for (Map.Entry entry : this.values.entrySet()) {
                Object locale = entry.getKey();
                value = entry.getValue();
                if (locale != null) {
                    languageElement = new Element("Language");
                    languageElement.setAttribute("Locale", locale.toString());
                    String valueStr = value != null ? value.toString() : "";
                    languageElement.addContent((Content)new CDATA(valueStr));
                    resourceElement.addContent((Content)languageElement);
                }
                languageElement = null;
            }
        }
        return resourceElement;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Resource ");
        if (this.values != null && this.values.size() > 0) {
            Object value = null;
            for (Map.Entry entry : this.values.entrySet()) {
                Object locale = entry.getKey();
                value = entry.getValue();
                if (locale == null) continue;
                sb.append("[(" + locale + ")" + value + "]");
            }
        }
        return sb.toString();
    }

    public String getPK() {
        return this.key + this.id;
    }

    public void setPK(String destKey, String destId) {
        this.setID(destId);
        this.setKey(destKey);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string.intern();
    }

    public String getValue() {
        return this.getValue(this.defaultLocale);
    }

    public String getValue(Locale locale) {
        Object v;
        if (locale == null) {
            locale = this.defaultLocale;
        }
        if ((v = this.values.get(locale.toString())) == null) {
            Locale L2 = new Locale("l2");
            v = this.values.get(L2.toString());
        }
        return v != null ? v.toString() : "";
    }

    public String getPossibleValue(Locale locale) {
        String v = "";
        if (locale != null) {
            v = this.getValue(locale);
        }
        if (v == null || v.length() == 0) {
            for (Object o : this.values.values()) {
                if (o == null || o.toString() == null || o.toString().length() <= 0) continue;
                v = o.toString();
                break;
            }
        }
        return v;
    }

    public void setValue(String string) {
        this.setValue(this.defaultLocale, string);
    }

    public void setValue(Locale locale, String string) {
        if (locale == null) {
            locale = this.defaultLocale;
        }
        this.values.put(locale.toString(), string);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string.intern();
    }

    @Override
    public IKpdlElement parse(Element destElement) throws WfKpdlParseException {
        if (destElement == null) {
            throw new IllegalArgumentException();
        }
        this.key = destElement.getAttributeValue("Key");
        this.id = destElement.getAttributeValue("Id");
        if (destElement.getChildren() != null) {
            Iterator languageIterator = destElement.getChildren().iterator();
            Element languageElement = null;
            String value = null;
            while (languageIterator.hasNext()) {
                languageElement = (Element)languageIterator.next();
                if (languageElement == null) continue;
                String locale = languageElement.getAttributeValue("Locale");
                value = languageElement.getText();
                String oldValue = languageElement.getAttributeValue("Value");
                if (oldValue != null && oldValue.length() > 0) {
                    value = oldValue;
                }
                if (locale == null || locale.length() <= 0 || value == null || value.length() <= 0) continue;
                this.values.put(locale, value);
            }
        }
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }
}

