/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.AbstractKpdlElementCollection;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class ResourceCollection
extends AbstractKpdlElementCollection {
    public ResourceCollection() {
    }

    public ResourceCollection(AbstractKpdlElement container) {
        this.container = container;
    }

    public ResourceCollection(Element destResourceElement) throws WfKpdlParseException {
        this();
        this.parse(destResourceElement);
        this.trimToSize();
    }

    public ResourceCollection(AbstractKpdlElement container, Element destResourceElement) throws WfKpdlParseException {
        this(destResourceElement);
        this.container = container;
    }

    public boolean add(String key, Resource value) {
        return this.addObject(key, (Object)value);
    }

    public Resource set(String key, Resource value) {
        return (Resource)this.setObject(key, (Object)value);
    }

    @Override
    public Object remove(String key) {
        return this.removeObjectByKey(key);
    }

    public Resource get(String key) {
        return (Resource)this.getObject(key);
    }

    public Resource get(int i) {
        return (Resource)this.getObject(i);
    }

    @Override
    public Element toElement() {
        Element resourcesElement = new Element("Resources", DefinitionConstants.NS_INSTANCE_KPDL);
        for (int i = 0; i < this.size(); ++i) {
            resourcesElement.addContent((Content)this.get(i).toElement());
        }
        return resourcesElement;
    }

    @Override
    public IKpdlElement parse(Element destElement) throws WfKpdlParseException {
        if (destElement == null) {
            throw new IllegalArgumentException();
        }
        List resourceElementList = destElement.getChildren("Resource", DefinitionConstants.NS_INSTANCE_KPDL);
        Element resourceElement = null;
        Resource tempResourceDef = null;
        for (int i = 0; i < resourceElementList.size(); ++i) {
            resourceElement = (Element)resourceElementList.get(i);
            tempResourceDef = new Resource(resourceElement);
            this.add(tempResourceDef.getPK(), tempResourceDef);
        }
        return this;
    }

    public Resource updateResourceId(Resource resource, String id) {
        if (resource == null) {
            return null;
        }
        if (this.containsKey(resource.getPK())) {
            this.remove(resource.getPK());
        }
        resource.setID(id);
        this.add(resource.getPK(), resource);
        return resource;
    }
}

