/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.ConditionDef;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public class RouterActivityDef
extends ActivityDef {
    private static final long serialVersionUID = -3017178016038460449L;
    private boolean isSync = false;
    private boolean isMutexSplit = false;
    private ConditionDef syncCondition;
    private boolean cancelPriorAct = false;

    public boolean isSync() {
        return this.isSync;
    }

    @Override
    protected String getTypeResource() {
        return "router";
    }

    public boolean isCancelPriorAct() {
        return this.cancelPriorAct;
    }

    public void setSync(boolean b) {
        this.isSync = b;
    }

    public void setCancelPriorAct(boolean cancelPriorAct) {
        this.cancelPriorAct = cancelPriorAct;
    }

    public ConditionDef getSyncCondition() {
        return this.syncCondition;
    }

    public void setSyncCondition(ConditionDef def) {
        this.syncCondition = def;
    }

    public RouterActivityDef() {
        try {
            this.setName("Router");
        }
        catch (WfException e) {
            log.error((Object)"RouterActivityDef error", (Throwable)((Object)e));
        }
        this.type = ActivityType.ROUTER;
        if (this.activityHeader != null) {
            this.activityHeader.setRollback(true);
        }
    }

    public RouterActivityDef(ProcessDef process) {
        super(process);
        try {
            this.setName("Router");
        }
        catch (WfException e) {
            log.error((Object)"RouterActivityDef.construct setName error", (Throwable)((Object)e));
        }
        this.type = ActivityType.ROUTER;
        if (this.activityHeader != null) {
            this.activityHeader.setRollback(true);
        }
    }

    public RouterActivityDef(ProcessDef destContainedProcessDef, Element element) throws WfKpdlParseException {
        super(destContainedProcessDef, element);
        this.type = ActivityType.ROUTER;
        this.parse(element);
    }

    @Override
    public IKpdlElement innerParse(Element element) throws WfKpdlParseException {
        super.innerParse(element);
        this.isSync = Boolean.valueOf(element.getAttributeValue("IsSync"));
        this.isMutexSplit = Boolean.valueOf(element.getAttributeValue("IsMutexSplit"));
        Element conditionElem = element.getChild("Condition", DefinitionConstants.NS_INSTANCE_KPDL);
        if (conditionElem != null) {
            this.syncCondition = new ConditionDef(conditionElem);
        }
        this.cancelPriorAct = "true".equals(element.getAttributeValue("cancelPriorAct"));
        return this;
    }

    @Override
    public Element toElement() {
        Element routerElement = super.toElement();
        if (routerElement != null) {
            routerElement.setName("Router");
            routerElement.setAttribute("IsSync", String.valueOf(this.isSync));
            routerElement.setAttribute("cancelPriorAct", String.valueOf(this.cancelPriorAct));
            routerElement.setAttribute("IsMutexSplit", String.valueOf(this.isMutexSplit));
            if (this.syncCondition != null) {
                routerElement.addContent((Content)this.syncCondition.toElement());
            }
        }
        return routerElement;
    }

    public boolean isMutexSplit() {
        return this.isMutexSplit;
    }

    public void setMutexSplit(boolean b) {
        this.isMutexSplit = b;
    }

    @Override
    public String getIconResource(String state) {
        if (state.equals("closed.completed")) {
            return this.isSync ? "imgWf_wait_complete" : "imgWf_empty_complete";
        }
        return this.getIconResource();
    }

    @Override
    public String getIconResource() {
        return this.isSync ? "imgWf_wait" : "imgWf_empty";
    }

    @Override
    public String getActDigest(Locale l) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u4e92\u65a5\u8def\u7531\uff1a").append(this.isMutexSplit);
        sb.append("\r\n").append(super.getActDigest(l));
        return sb.toString();
    }

    public RouterActivityDef deepClone(RouterActivityDef info) {
        info = (RouterActivityDef)super.deepClone(info);
        RouterActivityDef dc = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(info);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream bis = new ObjectInputStream(bais);
            dc = (RouterActivityDef)bis.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return dc;
    }
}

