/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import java.util.Date;
import org.jdom2.Element;

public class ScheduleDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -8800605170098607015L;
    public static final String SchedualeKey = "Scheduale";
    public static final String RetryTimeKey = "RetryTime";
    public static final String TypeKey = "Type";
    public static final String BeginTimeKey = "BeginTime";
    public static final String EndTimeKey = "EndTime";
    public static final String UseCalendarKey = "UseCalendar";
    public static final String InWorkingDayKey = "InWorkingDay";
    public static final String OrgUnitIdKey = "OrgUnitId";
    public static final String InstructionTypeKey = "InstructionType";
    private int retryTime;
    private String define;
    private ScheduleType type;
    private Date beginTime;
    private Date endTime;
    private boolean useCalendar;
    private boolean inWorkingDay = true;
    private String orgUnitId;
    private int instructionType;

    public ScheduleDef(AbstractKpdlElement process) {
        this.container = process;
        this.type = ScheduleType.EVERYDAY;
        this.beginTime = new Date();
        this.endTime = new Date();
        this.useCalendar = false;
    }

    public ScheduleDef(AbstractKpdlElement process, Element destElement) throws WfKpdlParseException {
        this(process);
        this.parse(destElement);
    }

    @Override
    public Element toElement() {
        Element schedualeElement = new Element(SchedualeKey, DefinitionConstants.NS_INSTANCE_KPDL);
        schedualeElement.setAttribute(RetryTimeKey, String.valueOf(this.retryTime));
        schedualeElement.setAttribute(TypeKey, this.type.getName());
        schedualeElement.setAttribute(BeginTimeKey, String.valueOf(this.beginTime.getTime()));
        schedualeElement.setAttribute(EndTimeKey, String.valueOf(this.beginTime.getTime()));
        schedualeElement.setAttribute(UseCalendarKey, String.valueOf(this.useCalendar));
        if (this.useCalendar) {
            schedualeElement.setAttribute(InWorkingDayKey, String.valueOf(this.inWorkingDay));
            schedualeElement.setAttribute(OrgUnitIdKey, this.orgUnitId);
        }
        schedualeElement.setText(this.define);
        schedualeElement.setAttribute(InstructionTypeKey, String.valueOf(this.instructionType));
        return schedualeElement;
    }

    public String getDefine() {
        return this.define;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public void setDefine(String string) {
        this.define = string;
    }

    public void setRetryTime(int i) {
        this.retryTime = i;
    }

    @Override
    public String getID() {
        throw new RuntimeException("NotSupport");
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public ScheduleType getType() {
        return this.type;
    }

    public void setBeginTime(Date date) {
        this.beginTime = date;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public void setType(ScheduleType type) {
        this.type = type;
    }

    @Override
    public String bosType() {
        return null;
    }

    @Override
    protected IKpdlElement innerParse(Element destElement) throws WfKpdlParseException {
        if (destElement == null) {
            throw new IllegalArgumentException();
        }
        if (!destElement.getName().equals(SchedualeKey)) {
            String msg = "The current element's name is " + destElement.getName();
            throw new IllegalArgumentException(msg);
        }
        this.retryTime = this.getAttributeValue2Int(destElement, RetryTimeKey);
        this.type = ScheduleType.getEnum(destElement.getAttributeValue(TypeKey), ScheduleType.EVERYDAY);
        this.beginTime = this.getAttributeValue2Date(destElement, BeginTimeKey);
        this.endTime = this.getAttributeValue2Date(destElement, EndTimeKey);
        this.useCalendar = this.getAttributeValue2Boolean(destElement, UseCalendarKey);
        if (this.useCalendar) {
            this.inWorkingDay = this.getAttributeValue2Boolean(destElement, InWorkingDayKey, true);
            this.orgUnitId = XmlUtil.readStringAttr(destElement, OrgUnitIdKey);
        }
        this.instructionType = this.getAttributeValue2Int(destElement, InstructionTypeKey);
        this.define = XmlUtil.readText(destElement);
        return this;
    }

    public String getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    public boolean isUseCalendar() {
        return this.useCalendar;
    }

    public void setUseCalendar(boolean useCalendar) {
        this.useCalendar = useCalendar;
    }

    public boolean isInWorkingDay() {
        return this.inWorkingDay;
    }

    public void setInWorkingDay(boolean inWorkingDay) {
        this.inWorkingDay = inWorkingDay;
    }

    public int getInstructionType() {
        return this.instructionType;
    }

    public void setInstructionType(int instructionType) {
        this.instructionType = instructionType;
    }

    private int getAttributeValue2Int(Element element, String attributeKey) {
        String value = element.getAttributeValue(attributeKey);
        boolean defaultvalue = false;
        if (value == null || value.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(element.getAttributeValue(attributeKey));
        }
        catch (NumberFormatException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ScheduleDef.parse parseschedule " + attributeKey + "error"), (Throwable)e);
            }
            return 0;
        }
    }

    private Date getAttributeValue2Date(Element element, String attributeKey) {
        try {
            return new Date(Long.valueOf(element.getAttributeValue(attributeKey)));
        }
        catch (NumberFormatException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ScheduleDef.parse parseschedule " + attributeKey + " error"), (Throwable)e);
            }
            return null;
        }
    }

    private boolean getAttributeValue2Boolean(Element element, String attributeKey) {
        return this.getAttributeValue2Boolean(element, attributeKey, false);
    }

    private boolean getAttributeValue2Boolean(Element element, String attributeKey, boolean defaultValue) {
        String value = element.getAttributeValue(attributeKey);
        if (value != null && value.trim().length() > 0) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }
}

