/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.DeadlineCollection;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.ExecutionMode;
import com.kingdee.bos.workflow.define.IImplementationActivity;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

public class SubflowActivityDef
extends ActivityDef
implements IImplementationActivity {
    private static final long serialVersionUID = 1956789978762304880L;
    private String refProcDefId;
    private ExecutionMode execution;
    private ParticipantCollection participants;
    private ActualParameterCollection actualParameters;
    private DeadlineCollection deadlines;

    @Override
    public String getIconResource(String state) {
        if (state.equals("closed.completed")) {
            return "imgWf_subflow_complete";
        }
        if (state.equals("open.running")) {
            return "imgWf_subflow_running";
        }
        if (state.equals("closed.terminated")) {
            return "imgWf_subflow_terminate";
        }
        if (state.equals("closed.aborted")) {
            return "imgWf_subflow_abort";
        }
        if (state.equals("open.not_running.suspended") || state.equals("open.not_running.blocked")) {
            return "imgWf_subflow_suspend";
        }
        return this.getIconResource();
    }

    @Override
    public String getIconResource() {
        return "imgWf_subflow";
    }

    @Override
    protected String getTypeResource() {
        return "subflow";
    }

    public SubflowActivityDef(ProcessDef process) {
        block3: {
            super(process);
            if (process != null) {
                try {
                    this.setName("SubflowActivity");
                }
                catch (WfException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"SubflowActivityDef.construct error", (Throwable)((Object)e));
                }
            }
        }
        this.refProcDefId = "";
        this.execution = ExecutionMode.SYNCHR;
        this.actualParameters = new ActualParameterCollection(this.container());
        this.deadlines = new DeadlineCollection(this);
        this.participants = new ParticipantCollection();
        this.setType(ActivityType.SUBFLOW);
    }

    public SubflowActivityDef(ProcessDef container, Element element) throws WfKpdlParseException {
        super(container, element);
        Element tempActualParams;
        this.setType(ActivityType.SUBFLOW);
        this.refProcDefId = XmlUtil.readStringAttr(element, "RefProcDefId");
        if (element.getAttributeValue("Execution") != null) {
            this.execution = ExecutionMode.getEnum(element.getAttributeValue("Execution"));
        }
        this.actualParameters = (tempActualParams = element.getChild("ActualParameters", DefinitionConstants.NS_INSTANCE_KPDL)) != null ? new ActualParameterCollection(this, tempActualParams) : new ActualParameterCollection(this);
        Element tempDeadlines = element.getChild("Deadlines", DefinitionConstants.NS_INSTANCE_KPDL);
        this.deadlines = tempDeadlines != null ? new DeadlineCollection(this, tempDeadlines) : new DeadlineCollection(this);
        Element tempParticipants = element.getChild("Participants", DefinitionConstants.NS_INSTANCE_KPDL);
        this.participants = tempParticipants != null ? new ParticipantCollection(this, tempParticipants) : new ParticipantCollection();
    }

    public String getSubflowId() {
        return this.refProcDefId;
    }

    public ExecutionMode getSynchrMode() {
        if (this.execution == null) {
            return ExecutionMode.SYNCHR;
        }
        return this.execution;
    }

    public void setSubflowId(String string) {
        this.refProcDefId = string;
    }

    public void setSynchrMode(ExecutionMode mode) {
        this.execution = mode;
    }

    @Override
    public ActualParameterCollection getActualParameters() {
        return this.actualParameters;
    }

    public DeadlineCollection getDeadlines() {
        return this.deadlines;
    }

    public ParticipantCollection getParticipants() {
        return this.participants;
    }

    public void setActualParameters(ActualParameterCollection collection) {
        this.actualParameters = collection;
    }

    public void setDeadlines(DeadlineCollection collection) {
        this.deadlines = collection;
    }

    public void setParticipants(ParticipantCollection collection) {
        this.participants = collection;
    }

    public ExecutionMode getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionMode mode) {
        this.execution = mode;
    }

    @Override
    public Element toElement() {
        Element subflowElement = super.toElement();
        if (subflowElement != null) {
            subflowElement.setName("SubFlow");
            if (this.refProcDefId != null && this.refProcDefId.length() > 0) {
                subflowElement.setAttribute("RefProcDefId", this.refProcDefId);
            }
            subflowElement.setAttribute("Execution", this.execution.getName());
            if (this.actualParameters != null && this.actualParameters.size() > 0) {
                subflowElement.addContent((Content)this.actualParameters.toElement());
            } else {
                subflowElement.addContent((Content)new Element("ActualParameters", DefinitionConstants.NS_INSTANCE_KPDL));
            }
            if (this.participants != null && this.participants.size() > 0) {
                subflowElement.addContent((Content)this.participants.toElement());
            } else {
                subflowElement.addContent((Content)new Element("Participants", DefinitionConstants.NS_INSTANCE_KPDL));
            }
            if (this.deadlines != null && this.deadlines.size() > 0) {
                subflowElement.addContent((Content)this.deadlines.toElement());
            } else {
                subflowElement.addContent((Content)new Element("Deadlines", DefinitionConstants.NS_INSTANCE_KPDL));
            }
        }
        return subflowElement;
    }

    public SubflowActivityDef deepClone(SubflowActivityDef info) {
        info = (SubflowActivityDef)super.deepClone(info);
        SubflowActivityDef dc = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(info);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream bis = new ObjectInputStream(bais);
            dc = (SubflowActivityDef)bis.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return dc;
    }
}

