/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.ScriptDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.Uuid;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public class TagDef
extends AbstractKpdlElement {
    private static final String BOSTYPE = "WFTAGDEF";
    private String id = Uuid.create().toString() + "WFTAGDEF";
    private ScriptDef script;

    public TagDef() {
    }

    public TagDef(AbstractKpdlElement container) {
        this.container = container;
    }

    public TagDef(AbstractKpdlElement container, Element destElement) throws WfKpdlParseException {
        this(container);
        this.parse(destElement);
    }

    @Override
    public Element toElement() {
        Element tagElement = new Element("Tag", DefinitionConstants.NS_INSTANCE_KPDL);
        tagElement.setAttribute("Id", this.id);
        if (this.script != null) {
            Element tempHandleScriptElement = new Element("TagScript", DefinitionConstants.NS_INSTANCE_KPDL);
            tempHandleScriptElement.addContent((Content)this.script.toElement());
            tagElement.addContent((Content)tempHandleScriptElement);
        }
        if (this.resources != null) {
            tagElement.addContent((Content)this.resources.toElement());
        }
        return tagElement;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    public void setTagName(Locale locale, String tag) {
        Resource resource = this.resources.get("TAGNAME" + this.id);
        if (resource == null) {
            resource = new Resource("TAGNAME", this.id);
            this.resources.set(resource.getPK(), resource);
        }
        resource.setValue(locale, tag);
    }

    public String getTagName(Locale locale) {
        Resource resource = this.resources.get("TAGNAME" + this.id);
        if (resource == null) {
            resource = new Resource("TAGNAME", this.id);
            this.resources.set(resource.getPK(), resource);
        }
        return resource.getValue(locale);
    }

    @Override
    protected IKpdlElement innerParse(Element destElement) throws WfKpdlParseException {
        Element resourcesElement;
        Element scriptElement;
        if (destElement == null) {
            throw new IllegalArgumentException();
        }
        this.id = XmlUtil.readStringAttr(destElement, "Id");
        Element tagScriptElement = destElement.getChild("TagScript", DefinitionConstants.NS_INSTANCE_KPDL);
        if (tagScriptElement != null && (scriptElement = tagScriptElement.getChild("Script", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.script = new ScriptDef(this.getContainer(), scriptElement);
        }
        if ((resourcesElement = destElement.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.resources = new ResourceCollection(this, resourcesElement);
        }
        return null;
    }

    public ScriptDef getScript() {
        return this.script;
    }

    public void setScript(ScriptDef script) {
        this.script = script;
    }
}

