/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.ExecutionObjectType;
import com.kingdee.bos.workflow.define.IExecuteObject;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.TransactionMode;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class TransactionBlockDef
extends AbstractKpdlElement
implements IExecuteObject {
    private static final long serialVersionUID = 1399754141180232115L;
    private static final String BOSTYPE = "WFTRBDEF";
    private String innerId = Uuid.create().toString() + "WFTRBDEF";
    private String innerStartActivity;
    private List innerActivitiesReference;
    private TransactionMode mode = TransactionMode.ASYNCHRONISM;

    protected TransactionBlockDef() {
        this.innerActivitiesReference = new ArrayList();
    }

    public TransactionBlockDef(ProcessDef process) {
        this();
        this.setContainer(process);
    }

    protected TransactionBlockDef(ProcessDef containedProcessDef, Element destTransactionBlockDefElement) throws WfKpdlParseException {
        this(containedProcessDef);
        this.parse(destTransactionBlockDefElement);
    }

    public List getActivities() {
        return this.innerActivitiesReference;
    }

    public void setActivities(List activities) {
        this.innerActivitiesReference = activities;
    }

    public void setContainer(ProcessDef dstContainer) {
        if (dstContainer == null) {
            throw new IllegalArgumentException("\"container\" is null!");
        }
        this.container = dstContainer;
    }

    public String getStartActivity() {
        return this.innerStartActivity;
    }

    public void setStartActivity(String startActivityDef) {
        this.innerStartActivity = startActivityDef;
    }

    @Override
    public String getID() {
        return this.innerId;
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    @Override
    public ExecutionObjectType getExecuteObjectType() {
        return ExecutionObjectType.TRANSACTIONBLOCK;
    }

    public TransactionMode getMode() {
        return this.mode;
    }

    public void setMode(TransactionMode mode) {
        this.mode = mode;
    }

    @Override
    public Element toElement() {
        Element transactionBlockElement = new Element("TransactionBlock", DefinitionConstants.NS_INSTANCE_KPDL);
        transactionBlockElement.setAttribute("Id", this.innerId);
        transactionBlockElement.setAttribute("TransactionMode", this.mode.getName());
        Element startActivityElement = new Element("StartActivity", DefinitionConstants.NS_INSTANCE_KPDL);
        startActivityElement.setAttribute("ActivityId", this.innerStartActivity);
        transactionBlockElement.addContent((Content)startActivityElement);
        Element activitiesReferenceElement = new Element("ActivitiesReference", DefinitionConstants.NS_INSTANCE_KPDL);
        transactionBlockElement.addContent((Content)activitiesReferenceElement);
        int size = this.innerActivitiesReference.size();
        for (int i = 0; i <= size - 1; ++i) {
            String activityId = (String)this.innerActivitiesReference.get(i);
            Element activityReferenceElement = new Element("ActivityReference", DefinitionConstants.NS_INSTANCE_KPDL);
            activityReferenceElement.setAttribute("ActivityId", activityId);
            activitiesReferenceElement.addContent((Content)activityReferenceElement);
        }
        return transactionBlockElement;
    }

    @Override
    protected IKpdlElement innerParse(Element destElement) throws WfKpdlParseException {
        if (destElement == null) {
            throw new IllegalArgumentException();
        }
        this.innerId = XmlUtil.readStringAttr(destElement, "Id");
        if (destElement.getAttributeValue("Mode") != null && destElement.getAttributeValue("Mode").trim().length() > 0) {
            this.mode = TransactionMode.getEnum(destElement.getAttributeValue("Mode"));
        }
        Element startActivityElement = destElement.getChild("StartActivity", DefinitionConstants.NS_INSTANCE_KPDL);
        this.innerStartActivity = XmlUtil.readStringAttr(startActivityElement, "ActivityId");
        Element activitiesReferenceElement = destElement.getChild("ActivitiesReference", DefinitionConstants.NS_INSTANCE_KPDL);
        List activityReferences = activitiesReferenceElement.getChildren("ActivityReference", DefinitionConstants.NS_INSTANCE_KPDL);
        int size = activityReferences.size();
        for (int i = 0; i <= size - 1; ++i) {
            Element activityReferenceElement = (Element)activityReferences.get(i);
            String activityId = XmlUtil.readStringAttr(activityReferenceElement, "ActivityId");
            this.innerActivitiesReference.add(activityId);
        }
        assert (this.innerActivitiesReference instanceof ArrayList);
        ((ArrayList)this.innerActivitiesReference).trimToSize();
        return this;
    }
}

