/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ConditionDef;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.ExpressionCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.KpdlResourceUtils;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.define.diagram.Line;
import com.kingdee.bos.workflow.define.diagram.LineCollection;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.Uuid;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public class TransitionDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -8789981576967540007L;
    private static final String BOSTYPE = "WFTRNDEF";
    private ConditionDef condition;
    private static final String DESCRIPTION = KpdlResourceUtils.TRANSITION_DESCRIPTION.getName();
    private ExtendedAttributeCollection extendedAttributes;
    private String id;
    private static final String NAME = KpdlResourceUtils.TRANSITION_NAME.getName();
    private String from;
    private String to;
    private String path;
    private String fromPort;
    private String toPort;
    private Line relatedLine;

    public TransitionDef(ProcessDef process) {
        block5: {
            this.setContainer(process);
            this.condition = new ConditionDef();
            this.id = Uuid.create().toString() + BOSTYPE;
            if (this.container != null) {
                try {
                    if (this.getDescriptionResource() == null) {
                        this.setDescription(new Resource(DESCRIPTION, this.id));
                    }
                    if (this.getNameResource() == null) {
                        this.setName(new Resource(NAME, this.id, ""));
                    }
                }
                catch (WfException e) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)"TransitionDef.construct error", (Throwable)((Object)e));
                }
            }
        }
        this.extendedAttributes = new ExtendedAttributeCollection();
        this.fromPort = "p1";
        this.toPort = "p2";
    }

    public TransitionDef(ProcessDef container, Element destTransitionDefElement) throws WfKpdlParseException {
        this(container);
        if (container == null) {
            throw new IllegalArgumentException("container process is null");
        }
        this.container = container;
        this.parse(destTransitionDefElement);
    }

    protected final ProcessDef container() {
        return (ProcessDef)this.container;
    }

    public ActivityDef getFrom() {
        if (this.from == null || this.from.equals("")) {
            return null;
        }
        return this.container().getActivityDef(this.from);
    }

    public void setFrom(ActivityDef from) {
        this.from = from.getID();
    }

    public String getDescription() {
        if (this.container == null) {
            return null;
        }
        return this.getDescription(this.container.getLocale());
    }

    public Resource getDescriptionResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(DESCRIPTION + this.id);
    }

    public String getDescription(Locale locale) {
        if (this.getDescriptionResource() == null) {
            return null;
        }
        return this.getDescriptionResource().getValue(locale);
    }

    public void setDescription(String destDescription) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.setDescription(this.container.getLocale(), destDescription);
    }

    public void setDescription(Locale locale, String destDescription) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destDescription == null) {
            throw new IllegalArgumentException();
        }
        if (this.getDescriptionResource() == null) {
            this.setDescription(new Resource(DESCRIPTION, this.id, locale, destDescription));
        } else {
            this.getDescriptionResource().setValue(locale, destDescription);
        }
    }

    public void setDescription(Resource destDescription) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(DESCRIPTION + this.id, destDescription);
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setID(String destId) {
        this.resources.updateResourceId(this.getDescriptionResource(), destId);
        this.resources.updateResourceId(this.getNameResource(), destId);
        this.id = destId;
    }

    public String getName() {
        return this.getName(this.container.getLocale());
    }

    public Resource getNameResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(NAME + this.id);
    }

    public String getName(Locale locale) {
        if (this.getNameResource() == null) {
            return null;
        }
        return this.getNameResource().getValue(locale);
    }

    public void setName(String destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.setName(this.container.getLocale(), destName);
    }

    public void setName(Locale locale, String destName) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destName == null) {
            throw new IllegalArgumentException();
        }
        if (this.getNameResource() == null) {
            this.setName(new Resource(NAME, this.id, locale, destName));
        } else {
            this.getNameResource().setValue(locale, destName);
        }
    }

    public void setName(Resource destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(NAME + this.id, destName);
    }

    public ActivityDef getTo() {
        if (this.to == null || this.to.equals("")) {
            return null;
        }
        return this.container().getActivityDef(this.to);
    }

    public void setTo(ActivityDef to) {
        this.to = to.getID();
    }

    public ConditionDef getCondition() {
        return this.condition;
    }

    public ExpressionCollection getXpressionList() {
        if (this.condition != null) {
            return this.condition.getXpressionList();
        }
        return null;
    }

    public void setCondition(ConditionDef destCondition) {
        this.condition = destCondition;
    }

    public ProcessDef getContainedProcessDef() {
        return this.container();
    }

    public void setContainedProcessDef(ProcessDef destContainedProcessDef) {
        this.container = destContainedProcessDef;
    }

    public String getPath() {
        return this.getRelatedLine().getPath();
    }

    public void setPath(String destPath) {
        this.getRelatedLine().setPath(destPath);
    }

    public String getFromPort() {
        return this.getRelatedLine().getFromPort();
    }

    public String getToPort() {
        return this.getRelatedLine().getToPort();
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public void setFromPort(String string) {
        this.getRelatedLine().setFromPort(string);
    }

    public void setTo(String string) {
        this.to = string;
    }

    public void setToPort(String string) {
        this.getRelatedLine().setToPort(string);
    }

    public ExtendedAttributeCollection getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public int check() {
        return 0;
    }

    @Override
    public Element toElement() {
        if (this.getRelatedLine() == null || !this.container().getDiagram().getLines().containsKey(this.getRelatedLine().getID())) {
            return null;
        }
        Element transitionElement = new Element("Transition", DefinitionConstants.NS_INSTANCE_KPDL);
        transitionElement.setAttribute("Id", this.id);
        if (this.from != null) {
            transitionElement.setAttribute("From", this.from);
        }
        if (this.to != null) {
            transitionElement.setAttribute("To", this.to);
        }
        transitionElement.setAttribute("Name", NAME);
        if (this.condition != null) {
            transitionElement.addContent((Content)this.condition.toElement());
        }
        Element descriptionElement = new Element("Description", DefinitionConstants.NS_INSTANCE_KPDL);
        descriptionElement.setText(DESCRIPTION);
        transitionElement.addContent((Content)descriptionElement);
        if (this.extendedAttributes != null && this.extendedAttributes.size() > 0) {
            transitionElement.addContent((Content)this.extendedAttributes.toElement());
        } else {
            transitionElement.addContent((Content)new Element("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL));
        }
        Element pathElement = new Element("Path", DefinitionConstants.NS_INSTANCE_KPDL);
        pathElement.setText(this.path);
        transitionElement.addContent((Content)pathElement);
        if (this.fromPort != null || this.toPort != null) {
            Element portElement = new Element("Port", DefinitionConstants.NS_INSTANCE_KPDL);
            portElement.setAttribute("From", this.fromPort == null ? "" : this.fromPort);
            portElement.setAttribute("To", this.toPort == null ? "" : this.toPort);
            transitionElement.addContent((Content)portElement);
        }
        if (this.resources != null) {
            transitionElement.addContent((Content)this.resources.toElement());
        }
        return transitionElement;
    }

    public Line getRelatedLine() {
        if (this.relatedLine == null && this.container() != null && this.container().getDiagram() != null && this.container().getDiagram().getLines() != null) {
            LineCollection lines = this.container().getDiagram().getLines();
            for (int i = 0; i < lines.size(); ++i) {
                if (lines.get(i).getRefTransition() == null || !lines.get(i).getRefTransition().getID().equals(this.id)) continue;
                this.relatedLine = lines.get(i);
            }
        }
        return this.relatedLine;
    }

    @Override
    public void setContainer(AbstractKpdlElement element) {
        super.setContainer(element);
        this.container = (ProcessDef)element;
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    @Override
    protected IKpdlElement innerParse(Element destTransitionDefElement) throws WfKpdlParseException {
        Element resourcesElement;
        Element tempExtendedAttrListElement;
        this.id = XmlUtil.readStringAttr(destTransitionDefElement, "Id");
        this.from = XmlUtil.readStringAttr(destTransitionDefElement, "From");
        this.to = XmlUtil.readStringAttr(destTransitionDefElement, "To");
        Element tempConditionElement = destTransitionDefElement.getChild("Condition", DefinitionConstants.NS_INSTANCE_KPDL);
        if (tempConditionElement != null) {
            this.condition = new ConditionDef(this, tempConditionElement);
        }
        if ((tempExtendedAttrListElement = destTransitionDefElement.getChild("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.extendedAttributes = new ExtendedAttributeCollection(tempExtendedAttrListElement);
        }
        this.path = XmlUtil.readString(destTransitionDefElement, "Path", DefinitionConstants.NS_INSTANCE_KPDL);
        Element tempPortElement = destTransitionDefElement.getChild("Port", DefinitionConstants.NS_INSTANCE_KPDL);
        if (tempPortElement != null) {
            this.fromPort = XmlUtil.readStringAttr(tempPortElement, "From");
            this.toPort = XmlUtil.readStringAttr(tempPortElement, "To");
        }
        if ((resourcesElement = destTransitionDefElement.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.resources = new ResourceCollection(this, resourcesElement);
        }
        return this;
    }
}

