/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import org.jdom2.Element;

public class WSOperationDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = 8302570378144533744L;
    private String serviceName;
    private String portName;
    private String operationName;
    private String endpoint;
    private String nameSpace;
    public static final String BOS_TYPE = "WSOPEDEF";

    public WSOperationDef(ApplicationDef applicationDef) {
        this.container = applicationDef;
    }

    public WSOperationDef(ApplicationDef applicationDef, Element destElement) throws WfKpdlParseException {
        this(applicationDef);
        this.parse(destElement);
    }

    @Override
    public Element toElement() {
        Element element = new Element("WSOperation", DefinitionConstants.NS_INSTANCE_KPDL);
        element.setAttribute("ServiceName", StringUtils.cnulls((String)this.serviceName));
        element.setAttribute("PortName", StringUtils.cnulls((String)this.portName));
        element.setAttribute("OperationName", this.operationName);
        element.setAttribute("Endpoint", StringUtils.cnulls((String)this.endpoint));
        element.setAttribute("NameSpace", StringUtils.cnulls((String)this.nameSpace));
        return element;
    }

    @Override
    protected IKpdlElement innerParse(Element destElement) throws WfKpdlParseException {
        this.serviceName = XmlUtil.readStringAttr(destElement, "ServiceName");
        this.portName = XmlUtil.readStringAttr(destElement, "PortName");
        this.operationName = XmlUtil.readStringAttr(destElement, "OperationName");
        this.endpoint = XmlUtil.readStringAttr(destElement, "Endpoint");
        this.nameSpace = XmlUtil.readStringAttr(destElement, "NameSpace");
        return this;
    }

    @Override
    public String getID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String bosType() {
        return BOS_TYPE;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }
}

