/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class WebBillManpowerActivityDef
extends ManpowerActivityDef {
    private static final long serialVersionUID = -7937713457111945477L;
    private String url;
    private String operation;
    private String uiState;
    private Map extentedProp;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getUiState() {
        return this.uiState;
    }

    public void setUiState(String uiState) {
        this.uiState = uiState;
    }

    public Map getExtentedProp() {
        return this.extentedProp;
    }

    public void setExtentedProp(Map extentedProp) {
        this.extentedProp = extentedProp;
    }

    public WebBillManpowerActivityDef(ProcessDef process) {
        super(process);
        try {
            this.setName("WebBillManpower");
        }
        catch (WfException wfException) {
            // empty catch block
        }
        this.url = "";
        this.operation = "";
        this.uiState = "";
        this.extentedProp = new HashMap();
    }

    public WebBillManpowerActivityDef(ProcessDef container, Element destManpowerActivityDefElement) throws WfKpdlParseException {
        super(container, destManpowerActivityDefElement);
        this.url = XmlUtil.readStringAttr(destManpowerActivityDefElement, "WebBillManpower_URL");
        this.operation = XmlUtil.readStringAttr(destManpowerActivityDefElement, "WebBillManpower_OPERATION");
        this.uiState = XmlUtil.readStringAttr(destManpowerActivityDefElement, "WebBillManpower_UISTATE");
        Element extentedPropElement = null;
        if (this.extentedProp == null) {
            this.extentedProp = new HashMap();
        } else {
            this.extentedProp.clear();
        }
        Element extentedPropElements = destManpowerActivityDefElement.getChild("WebBillManpower_EXTENTEDPROPS", DefinitionConstants.NS_INSTANCE_KPDL);
        List extentedPropsElement = extentedPropElements.getChildren("WebBillManpower_EXTENTEDPROP", DefinitionConstants.NS_INSTANCE_KPDL);
        int len = extentedPropsElement.size();
        for (int i = 0; i < len; ++i) {
            extentedPropElement = (Element)extentedPropsElement.get(i);
            String key = XmlUtil.readStringAttr(extentedPropElement, "KEY");
            String value = XmlUtil.readStringAttr(extentedPropElement, "VALUE");
            if (StringUtils.isEmpty((String)key)) continue;
            this.extentedProp.put(key, value);
        }
    }

    @Override
    public Element toElement() {
        Element element = super.toElement();
        if (element != null) {
            element.setName("WebBillManpower");
        }
        if (!StringUtils.isEmpty((String)this.url)) {
            element.setAttribute("WebBillManpower_URL", this.url);
        }
        if (!StringUtils.isEmpty((String)this.operation)) {
            element.setAttribute("WebBillManpower_OPERATION", this.operation);
        }
        if (!StringUtils.isEmpty((String)this.uiState)) {
            element.setAttribute("WebBillManpower_UISTATE", this.uiState);
        }
        Iterator iter = this.extentedProp.keySet().iterator();
        Element extentedPropsElement = new Element("WebBillManpower_EXTENTEDPROPS", DefinitionConstants.NS_INSTANCE_KPDL);
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (StringUtils.isEmpty((String)key)) continue;
            String value = (String)this.extentedProp.get(key);
            if (value == null) {
                value = "";
            }
            Element extentedPropElement = new Element("WebBillManpower_EXTENTEDPROP", DefinitionConstants.NS_INSTANCE_KPDL);
            extentedPropElement.setAttribute("KEY", key);
            extentedPropElement.setAttribute("VALUE", value);
            extentedPropsElement.addContent((Content)extentedPropElement);
        }
        element.addContent((Content)extentedPropsElement);
        return element;
    }
}

