/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define.diagram;

import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.define.diagram.Line;
import com.kingdee.bos.workflow.define.diagram.LineCollection;
import com.kingdee.bos.workflow.define.diagram.Node;
import com.kingdee.bos.workflow.define.diagram.NodeCollection;
import java.io.Serializable;
import org.jdom2.Content;
import org.jdom2.Element;

public class Diagram
implements Serializable {
    private static final long serialVersionUID = 1680421206176581567L;
    private ProcessDef container;
    private NodeCollection nodes;
    private LineCollection lines;

    public Diagram(ProcessDef destProc) {
        this.container = destProc;
        this.nodes = new NodeCollection(this);
        this.lines = new LineCollection(this);
    }

    public Diagram(Element element, ProcessDef destProc) throws WfKpdlParseException {
        this(destProc);
        if (element == null || destProc == null) {
            throw new IllegalArgumentException();
        }
        this.parse(element);
    }

    public void parse(Element destElement) throws WfKpdlParseException {
        Element linesElement;
        Element nodesElement = destElement.getChild("Nodes", DefinitionConstants.NS_INSTANCE_KPDL);
        if (nodesElement != null) {
            this.nodes = new NodeCollection(this, nodesElement);
        }
        if ((linesElement = destElement.getChild("Lines", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.lines = new LineCollection(this, linesElement);
        }
    }

    public ProcessDef getProcess() {
        return this.container;
    }

    public Element toElement() {
        Element diagramElement = new Element("Diagram", DefinitionConstants.NS_INSTANCE_KPDL);
        if (this.nodes != null) {
            diagramElement.addContent((Content)this.nodes.toElement());
        } else {
            diagramElement.addContent((Content)new Element("Nodes", DefinitionConstants.NS_INSTANCE_KPDL));
        }
        if (this.lines != null) {
            diagramElement.addContent((Content)this.lines.toElement());
        } else {
            diagramElement.addContent((Content)new Element("Lines", DefinitionConstants.NS_INSTANCE_KPDL));
        }
        return diagramElement;
    }

    public LineCollection getLines() {
        return this.lines;
    }

    public NodeCollection getNodes() {
        return this.nodes;
    }

    public void setLines(LineCollection collection) {
        this.lines = collection;
    }

    public void setNodes(NodeCollection collection) {
        this.nodes = collection;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public void addLine(Line line) {
        this.lines.add(line);
    }
}

