/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define.validation;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.validation.IRule;
import com.kingdee.bos.workflow.define.validation.ResultInfo;
import com.kingdee.bos.workflow.define.validation.ResultType;
import com.kingdee.bos.workflow.define.validation.RuleCollection;
import com.kingdee.bos.workflow.define.validation.ValidateSolution;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ModelValidateManager {
    private RuleCollection rules = null;
    private ValidateSolution validateSolu = null;
    private List resultList = null;
    private Locale locale = Locale.getDefault();

    private void init() {
        if (this.rules == null) {
            this.rules = new RuleCollection();
        }
        if (this.resultList == null) {
            this.resultList = new ArrayList();
        }
        if (this.validateSolu == null) {
            this.validateSolu = new ValidateSolution();
        }
    }

    public List check(ProcessDef process) throws WfException {
        this.init();
        this.resultList.clear();
        for (int i = 0; i < this.rules.size(); ++i) {
            IRule rule = this.rules.get(i);
            if (!rule.getIsMainRule()) continue;
            this.resultList.addAll(rule.check(process));
        }
        return this.resultList;
    }

    public boolean saveSolution(ValidateSolution solution) {
        return false;
    }

    public void loadSolution(ValidateSolution validateSolution) {
        this.validateSolu = validateSolution;
        this.rules = this.validateSolu.rules;
    }

    public boolean getHasError() {
        if (this.resultList == null) {
            return false;
        }
        for (int i = 0; i < this.resultList.size(); ++i) {
            if (!((ResultInfo)this.resultList.get((int)i)).resultType.equals((Object)ResultType.ERROR)) continue;
            return true;
        }
        return false;
    }

    public List getResultList() {
        return this.resultList;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

